/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import jmri.Block;
import jmri.Bundle;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Section;
import jmri.SensorManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.TransitSection;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transit
extends AbstractNamedBean {
    public static final int IDLE = 2;
    public static final int ASSIGNED = 4;
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    private int mState = 2;
    private final ArrayList<TransitSection> mTransitSectionList = new ArrayList();
    private int mMaxSequence = 0;
    private final ArrayList<Integer> blockSecSeqList = new ArrayList();
    private final ArrayList<Integer> destBlocksSeqList = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(Transit.class);

    public Transit(String systemName, String userName) {
        super(systemName, userName);
    }

    public Transit(String systemName) {
        super(systemName);
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void setState(int state) {
        if (state == 2 || state == 4) {
            int old = this.mState;
            this.mState = state;
            this.firePropertyChange("state", old, this.mState);
        } else {
            log.error("Attempt to set Transit state to illegal value - {}", (Object)state);
        }
    }

    public void addTransitSection(TransitSection s) {
        this.mTransitSectionList.add(s);
        this.mMaxSequence = s.getSequenceNumber();
    }

    public ArrayList<TransitSection> getTransitSectionList() {
        return new ArrayList<TransitSection>(this.mTransitSectionList);
    }

    public int getMaxSequence() {
        return this.mMaxSequence;
    }

    public void removeAllSections() {
        this.mTransitSectionList.clear();
    }

    public boolean containsSection(Section s) {
        return this.mTransitSectionList.stream().anyMatch(ts -> ts.getSection() == s);
    }

    public ArrayList<Section> getSectionListBySeq(int seq) {
        ArrayList<Section> list = new ArrayList<Section>();
        for (TransitSection ts : this.mTransitSectionList) {
            if (seq != ts.getSequenceNumber()) continue;
            list.add(ts.getSection());
        }
        return list;
    }

    public ArrayList<TransitSection> getTransitSectionListBySeq(int seq) {
        ArrayList<TransitSection> list = new ArrayList<TransitSection>();
        for (TransitSection ts : this.mTransitSectionList) {
            if (seq != ts.getSequenceNumber()) continue;
            list.add(ts);
        }
        return list;
    }

    public ArrayList<Integer> getSeqListBySection(Section s) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (TransitSection ts : this.mTransitSectionList) {
            if (s != ts.getSection()) continue;
            list.add(ts.getSequenceNumber());
        }
        return list;
    }

    public boolean containsBlock(Block block) {
        for (Block b : this.getInternalBlocksList()) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    public int getBlockCount(Block block) {
        int count = 0;
        for (Block b : this.getInternalBlocksList()) {
            if (b != block) continue;
            ++count;
        }
        return count;
    }

    public Section getSectionFromBlockAndSeq(Block b, int seq) {
        for (TransitSection ts : this.mTransitSectionList) {
            Section s;
            if (ts.getSequenceNumber() != seq || !(s = ts.getSection()).containsBlock(b)) continue;
            return s;
        }
        return null;
    }

    public Section getSectionFromConnectedBlockAndSeq(Block b, int seq) {
        for (TransitSection ts : this.mTransitSectionList) {
            Section s;
            if (ts.getSequenceNumber() != seq || !(s = ts.getSection()).connectsToBlock(b)) continue;
            return s;
        }
        return null;
    }

    public int getDirectionFromSectionAndSeq(Section s, int seq) {
        for (TransitSection ts : this.mTransitSectionList) {
            if (ts.getSection() != s || ts.getSequenceNumber() != seq) continue;
            return ts.getDirection();
        }
        return 0;
    }

    public TransitSection getTransitSectionFromSectionAndSeq(Section s, int seq) {
        for (TransitSection ts : this.mTransitSectionList) {
            if (ts.getSection() != s || ts.getSequenceNumber() != seq) continue;
            return ts;
        }
        return null;
    }

    public ArrayList<Block> getInternalBlocksList() {
        ArrayList<Block> list = new ArrayList<Block>();
        this.blockSecSeqList.clear();
        this.mTransitSectionList.forEach(ts -> ts.getSection().getBlockList().stream().forEach(b -> {
            list.add((Block)b);
            this.blockSecSeqList.add(ts.getSequenceNumber());
        }));
        return list;
    }

    public ArrayList<Integer> getBlockSeqList() {
        return new ArrayList<Integer>(this.blockSecSeqList);
    }

    public ArrayList<Block> getEntryBlocksList() {
        ArrayList<Block> list = new ArrayList<Block>();
        ArrayList<Block> internalBlocks = this.getInternalBlocksList();
        this.blockSecSeqList.clear();
        for (TransitSection ts : this.mTransitSectionList) {
            List<EntryPoint> ePointList = ts.getDirection() == 4 ? ts.getSection().getForwardEntryPointList() : ts.getSection().getReverseEntryPointList();
            for (EntryPoint ep : ePointList) {
                Block eb = ep.getFromBlock();
                boolean isInternal = false;
                for (Block ib : internalBlocks) {
                    if (eb != ib) continue;
                    isInternal = true;
                }
                if (isInternal) continue;
                list.add(eb);
                this.blockSecSeqList.add(ts.getSequenceNumber());
            }
        }
        return list;
    }

    public ArrayList<Block> getDestinationBlocksList(Block startBlock, boolean startInTransit) {
        ArrayList<Block> list = new ArrayList<Block>();
        this.destBlocksSeqList.clear();
        if (startBlock == null) {
            return list;
        }
        int startSeq = -1;
        ArrayList<Block> startBlocks = startInTransit ? this.getInternalBlocksList() : this.getEntryBlocksList();
        int k = 0;
        while (k < startBlocks.size() && startSeq == -1) {
            if (startBlock == startBlocks.get(k)) {
                startSeq = this.blockSecSeqList.get(k);
            }
            ++k;
        }
        ArrayList<Block> internalBlocks = this.getInternalBlocksList();
        if (startInTransit) {
            int i = internalBlocks.size();
            while (i > 0) {
                if (this.blockSecSeqList.get(i - 1) > startSeq) {
                    list.add(internalBlocks.get(i - 1));
                    this.destBlocksSeqList.add(this.blockSecSeqList.get(i - 1));
                }
                --i;
            }
        } else {
            int i = internalBlocks.size();
            while (i > 0) {
                if (this.blockSecSeqList.get(i - 1) >= startSeq) {
                    list.add(internalBlocks.get(i - 1));
                    this.destBlocksSeqList.add(this.blockSecSeqList.get(i - 1));
                }
                --i;
            }
        }
        return list;
    }

    public ArrayList<Integer> getDestBlocksSeqList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.destBlocksSeqList.size()) {
            list.add(this.destBlocksSeqList.get(i));
            ++i;
        }
        return list;
    }

    public boolean canBeResetWhenDone() {
        TransitSection firstTS = this.mTransitSectionList.get(0);
        int lastIndex = this.mTransitSectionList.size() - 1;
        TransitSection lastTS = this.mTransitSectionList.get(lastIndex);
        boolean OK = false;
        while (!OK) {
            if (firstTS.getSection() != lastTS.getSection()) {
                if (lastTS.isAlternate() && lastIndex > 1) {
                    lastTS = this.mTransitSectionList.get(--lastIndex);
                } else {
                    log.warn("Section mismatch {} {}", (Object)firstTS.getSection().getDisplayName(USERSYS), (Object)lastTS.getSection().getDisplayName(USERSYS));
                    return false;
                }
            }
            OK = true;
        }
        if (firstTS.getDirection() != lastTS.getDirection()) {
            log.warn("Direction mismatch {} {}", (Object)firstTS.getSection().getDisplayName(USERSYS), (Object)lastTS.getSection().getDisplayName(USERSYS));
            return false;
        }
        return true;
    }

    @Deprecated
    public int checkSignals(LayoutEditor panel) {
        if (panel == null) {
            log.error("checkSignals called with a null LayoutEditor panel");
            return -1;
        }
        int numErrors = 0;
        for (TransitSection ts : this.mTransitSectionList) {
            numErrors += ts.getSection().placeDirectionSensors(panel);
        }
        return numErrors;
    }

    @Deprecated
    public int validateConnectivity(LayoutEditor panel) {
        LoggingUtil.deprecationWarning(log, "validateConnectivity");
        if (panel == null) {
            log.error("validateConnectivity called with a null LayoutEditor panel");
            return -1;
        }
        int numErrors = 0;
        int i = 0;
        while (i < this.mTransitSectionList.size()) {
            String s = this.mTransitSectionList.get(i).getSection().validate(panel);
            if (!s.equals("")) {
                log.error(s);
                ++numErrors;
            }
            ++i;
        }
        return numErrors;
    }

    public int initializeBlockingSensors() {
        int numErrors = 0;
        int i = 0;
        while (i < this.mTransitSectionList.size()) {
            Section s = this.mTransitSectionList.get(i).getSection();
            try {
                if (s.getForwardBlockingSensor() != null) {
                    if (s.getState() == 2) {
                        s.getForwardBlockingSensor().setState(2);
                    }
                } else {
                    log.warn("Missing forward blocking sensor for section {}", (Object)s.getDisplayName(USERSYS));
                    ++numErrors;
                }
            }
            catch (JmriException jmriException) {
                log.error("Exception when initializing forward blocking Sensor for Section {}", (Object)s.getDisplayName(USERSYS));
                ++numErrors;
            }
            try {
                if (s.getReverseBlockingSensor() != null) {
                    if (s.getState() == 2) {
                        s.getReverseBlockingSensor().setState(2);
                    }
                } else {
                    log.warn("Missing reverse blocking sensor for section {}", (Object)s.getDisplayName(USERSYS));
                    ++numErrors;
                }
            }
            catch (JmriException jmriException) {
                log.error("Exception when initializing reverse blocking Sensor for Section {}", (Object)s.getDisplayName(USERSYS));
                ++numErrors;
            }
            ++i;
        }
        return numErrors;
    }

    @SuppressFBWarnings(value={"UC_USELESS_OBJECT"}, justification="SpotBugs doesn't see that toBeRemoved is being read by the forEach clause")
    public void removeTemporarySections() {
        ArrayList<TransitSection> toBeRemoved = new ArrayList<TransitSection>();
        for (TransitSection ts2 : this.mTransitSectionList) {
            if (!ts2.isTemporary()) continue;
            toBeRemoved.add(ts2);
        }
        toBeRemoved.forEach(ts -> this.mTransitSectionList.remove(ts));
    }

    public boolean removeLastTemporarySection(Section s) {
        TransitSection last = this.mTransitSectionList.get(this.mTransitSectionList.size() - 1);
        if (last.getSection() != s) {
            log.info("Section asked to be removed is not the last one");
            return false;
        }
        if (!last.isTemporary()) {
            log.info("Section asked to be removed is not a temporary section");
            return false;
        }
        this.mTransitSectionList.remove(last);
        return true;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameTransit");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb;
        if ("CanDelete".equals(evt.getPropertyName()) && (nb = (NamedBean)evt.getOldValue()) instanceof Section && this.containsSection((Section)nb)) {
            throw new PropertyVetoException(Bundle.getMessage("VetoTransitSection", this.getDisplayName()), evt);
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        SignalHeadManager head = InstanceManager.getDefault(SignalHeadManager.class);
        SignalMastManager mast = InstanceManager.getDefault(SignalMastManager.class);
        if (bean != null) {
            this.getTransitSectionList().forEach(transitSection -> {
                if (bean.equals(transitSection.getSection())) {
                    report.add(new NamedBeanUsageReport("TransitSection"));
                }
                if (bean.equals(sm.getSensor(transitSection.getStopAllocatingSensor()))) {
                    report.add(new NamedBeanUsageReport("TransitSensorStopAllocation"));
                }
                transitSection.getTransitSectionActionList().forEach(action -> {
                    int whenCode = action.getWhenCode();
                    int whatCode = action.getWhatCode();
                    if ((whenCode == 7 || whenCode == 8) && bean.equals(sm.getSensor(action.getStringWhen()))) {
                        report.add(new NamedBeanUsageReport("TransitActionSensorWhen", transitSection.getSection()));
                    }
                    if ((whatCode == 12 || whatCode == 13) && bean.equals(sm.getSensor(action.getStringWhat()))) {
                        report.add(new NamedBeanUsageReport("TransitActionSensorWhat", transitSection.getSection()));
                    }
                    if (whatCode == 14 || whatCode == 15) {
                        if (bean.equals(head.getSignalHead(action.getStringWhat()))) {
                            report.add(new NamedBeanUsageReport("TransitActionSignalHeadWhat", transitSection.getSection()));
                        }
                        if (bean.equals(mast.getSignalMast(action.getStringWhat()))) {
                            report.add(new NamedBeanUsageReport("TransitActionSignalMastWhat", transitSection.getSection()));
                        }
                    }
                });
            });
        }
        return report;
    }
}

