/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.CheckForNull;
import jmri.Bundle;
import jmri.DigitalIO;
import jmri.InvokeOnLayoutThread;
import jmri.JmriException;
import jmri.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Sensor
extends DigitalIO {
    public static final int ACTIVE = 2;
    public static final int INACTIVE = 4;
    public static final Long MAX_DEBOUNCE = 9999999L;
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"}, justification="Private not available in interface")
    public static final Logger log = LoggerFactory.getLogger(Sensor.class);

    @Override
    default public boolean isConsistentState() {
        return true;
    }

    @Override
    @InvokeOnLayoutThread
    default public void setCommandedState(int s) {
        try {
            this.setState(s);
        }
        catch (JmriException ex) {
            log.error("setCommandedState", (Throwable)ex);
        }
    }

    @Override
    default public int getCommandedState() {
        return this.getState();
    }

    @InvokeOnLayoutThread
    public void setKnownState(int var1) throws JmriException;

    @InvokeOnLayoutThread
    public void setInverted(boolean var1);

    public boolean getInverted();

    public boolean canInvert();

    @Override
    public void dispose();

    public int getRawState();

    public void setSensorDebounceGoingActiveTimer(long var1);

    public long getSensorDebounceGoingActiveTimer();

    public void setSensorDebounceGoingInActiveTimer(long var1);

    public long getSensorDebounceGoingInActiveTimer();

    public void setUseDefaultTimerSettings(boolean var1);

    public boolean getUseDefaultTimerSettings();

    public void setReporter(@CheckForNull Reporter var1);

    @CheckForNull
    public Reporter getReporter();

    @InvokeOnLayoutThread
    public void setPullResistance(PullResistance var1);

    public PullResistance getPullResistance();

    public static enum PullResistance {
        PULL_UP("up", "PullResistanceUp"),
        PULL_DOWN("down", "PullResistanceDown"),
        PULL_OFF("off", "PullResistanceOff");

        String shortName;
        String peopleName;

        private PullResistance(String shName, String peopleKey) {
            this.shortName = shName;
            this.peopleName = Bundle.getMessage(peopleKey);
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getPeopleName() {
            return this.peopleName;
        }

        public static PullResistance getByShortName(String shName) {
            PullResistance[] pullResistanceArray = PullResistance.values();
            int n = pullResistanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                PullResistance p = pullResistanceArray[n2];
                if (p.shortName.equals(shName)) {
                    return p;
                }
                ++n2;
            }
            throw new IllegalArgumentException("argument value " + shName + " not valid");
        }

        public static PullResistance getByPeopleName(String pName) {
            PullResistance[] pullResistanceArray = PullResistance.values();
            int n = pullResistanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                PullResistance p = pullResistanceArray[n2];
                if (p.peopleName.equals(pName)) {
                    return p;
                }
                ++n2;
            }
            throw new IllegalArgumentException("argument value " + pName + " not valid");
        }

        public String toString() {
            return this.peopleName;
        }
    }
}

