/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.BlockManager;
import jmri.Bundle;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Path;
import jmri.Section;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.managers.AbstractManager;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionManager
extends AbstractManager<Section>
implements InstanceManagerAutoDefault {
    private static final Logger log = LoggerFactory.getLogger(SectionManager.class);

    public SectionManager() {
        this.addListeners();
    }

    final void addListeners() {
        InstanceManager.getDefault(SensorManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(BlockManager.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 130;
    }

    @Override
    public char typeLetter() {
        return 'Y';
    }

    @Override
    public Class<Section> getNamedBeanClass() {
        return Section.class;
    }

    @Nonnull
    public Section createNewSection(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        Section y;
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        if (systemName.isEmpty()) {
            throw new IllegalArgumentException("Section System Name Empty");
        }
        String sysName = systemName;
        if (!sysName.startsWith(this.getSystemNamePrefix())) {
            sysName = this.makeSystemName(sysName);
        }
        if (userName != null && !userName.isEmpty() && (y = (Section)this.getByUserName(userName)) != null) {
            throw new IllegalArgumentException("Section Already Exists with UserName " + userName);
        }
        y = (Section)this.getBySystemName(sysName);
        if (y != null) {
            throw new IllegalArgumentException("Section Already Exists with SystemName " + sysName);
        }
        y = new Section(sysName, userName);
        this.register(y);
        this.updateAutoNumber(systemName);
        return y;
    }

    @Nonnull
    public Section createNewSection(String userName) throws IllegalArgumentException {
        return this.createNewSection(this.getAutoSystemName(), userName);
    }

    public void deleteSection(Section y) {
        this.deregister(y);
        y.dispose();
    }

    public Section getSection(String name) {
        Section y = (Section)this.getByUserName(name);
        if (y != null) {
            return y;
        }
        return (Section)this.getBySystemName(name);
    }

    public int validateAllSections(JmriJFrame frame, LayoutEditor lePanel) {
        SortedSet set = this.getNamedBeanSet();
        int numSections = 0;
        int numErrors = 0;
        if (set.size() <= 0) {
            return -2;
        }
        for (Section section : set) {
            String s = section.validate(lePanel);
            if (!s.isEmpty()) {
                log.error(s);
                ++numErrors;
            }
            ++numSections;
        }
        log.debug("Validated {} Sections - {} errors or warnings.", (Object)numSections, (Object)numErrors);
        return numErrors;
    }

    public int setupDirectionSensors(LayoutEditor lePanel) {
        if (lePanel == null) {
            return -1;
        }
        SortedSet set = this.getNamedBeanSet();
        int numSections = 0;
        int numErrors = 0;
        if (set.size() <= 0) {
            return -2;
        }
        for (Section section : set) {
            int errors = section.placeDirectionSensors(lePanel);
            numErrors += errors;
            ++numSections;
        }
        log.debug("Checked direction sensors for {} Sections - {} errors or warnings.", (Object)numSections, (Object)numErrors);
        return numErrors;
    }

    public int removeDirectionSensorsFromSSL(LayoutEditor lePanel) {
        if (lePanel == null) {
            return -1;
        }
        ConnectivityUtil cUtil = lePanel.getConnectivityUtil();
        SortedSet set = this.getNamedBeanSet();
        if (set.size() <= 0) {
            return -2;
        }
        int numErrors = 0;
        ArrayList<String> sensorList = new ArrayList<String>();
        for (Section s : set) {
            String name = s.getReverseBlockingSensorName();
            if (name != null && !name.isEmpty()) {
                sensorList.add(name);
            }
            if ((name = s.getForwardBlockingSensorName()) == null || name.isEmpty()) continue;
            sensorList.add(name);
        }
        SignalHeadManager shManager = InstanceManager.getDefault(SignalHeadManager.class);
        for (SignalHead sh : shManager.getNamedBeanSet()) {
            if (cUtil.removeSensorsFromSignalHeadLogic(sensorList, sh)) continue;
            ++numErrors;
        }
        return numErrors;
    }

    public void initializeBlockingSensors() {
        for (Section s : this.getNamedBeanSet()) {
            try {
                if (s.getForwardBlockingSensor() != null) {
                    s.getForwardBlockingSensor().setState(2);
                }
                if (s.getReverseBlockingSensor() == null) continue;
                s.getReverseBlockingSensor().setState(2);
            }
            catch (JmriException jmriException) {
                log.error("Exception when initializing blocking Sensors for Section {}", (Object)s.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
            }
        }
    }

    public void generateBlockSections() {
        LayoutBlockManager LayoutBlockManager2 = InstanceManager.getDefault(LayoutBlockManager.class);
        for (LayoutBlock layoutBlock : LayoutBlockManager2.getNamedBeanSet()) {
            if (layoutBlock.getNumberOfThroughPaths() != 0 || this.blockSectionExists(layoutBlock)) continue;
            this.createBlockSection(layoutBlock);
        }
    }

    private boolean blockSectionExists(LayoutBlock layoutBlock) {
        for (Section section : this.getNamedBeanSet()) {
            if (section.getNumBlocks() != 1 || section.getSectionType() == 2 || !layoutBlock.getBlock().equals(section.getEntryBlock())) continue;
            return true;
        }
        return false;
    }

    private void createBlockSection(LayoutBlock layoutBlock) {
        Block endBlock;
        Section section;
        try {
            section = this.createNewSection(layoutBlock.getUserName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Could not create Section from LayoutBlock {}", (Object)layoutBlock.getDisplayName());
            return;
        }
        section.addBlock(layoutBlock.getBlock());
        ArrayList<EntryPoint> entryPointList = new ArrayList<EntryPoint>();
        Block sb = layoutBlock.getBlock();
        List<Path> paths = sb.getPaths();
        int j = 0;
        while (j < paths.size()) {
            Path p = paths.get(j);
            if (p.getBlock() != sb) {
                String pbDir = Path.decodeDirection(p.getFromBlockDirection());
                EntryPoint ep = new EntryPoint(sb, p.getBlock(), pbDir);
                entryPointList.add(ep);
            }
            ++j;
        }
        Block beginBlock = sb;
        List<EntryPoint> epList = this.getBlockEntryPointsList(beginBlock, entryPointList);
        if (epList.size() == 1) {
            epList.get(0).setTypeForward();
        }
        if ((epList = this.getBlockEntryPointsList(endBlock = sb, entryPointList)).size() == 1) {
            epList.get(0).setTypeReverse();
        }
        int j2 = 0;
        while (j2 < entryPointList.size()) {
            EntryPoint ep = entryPointList.get(j2);
            if (ep.isForwardType()) {
                section.addToForwardList(ep);
            } else if (ep.isReverseType()) {
                section.addToReverseList(ep);
            }
            ++j2;
        }
    }

    private List<EntryPoint> getBlockEntryPointsList(Block b, List<EntryPoint> entryPointList) {
        ArrayList<EntryPoint> list = new ArrayList<EntryPoint>();
        int i = 0;
        while (i < entryPointList.size()) {
            EntryPoint ep = entryPointList.get(i);
            if (ep.getBlock().equals(b)) {
                list.add(ep);
            }
            ++i;
        }
        return list;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSections" : "BeanNameSection");
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(SensorManager.class).removeVetoableChangeListener(this);
        InstanceManager.getDefault(BlockManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

