/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import jmri.Bundle;

@Immutable
public final class ProgrammingMode {
    public static final ProgrammingMode PAGEMODE = new ProgrammingMode("PAGEMODE");
    public static final ProgrammingMode OPSBITMODE = new ProgrammingMode("OPSBITMODE");
    public static final ProgrammingMode OPSACCEXTBYTEMODE = new ProgrammingMode("OPSACCEXTBYTEMODE");
    public static final ProgrammingMode OPSACCBITMODE = new ProgrammingMode("OPSACCBITMODE");
    public static final ProgrammingMode OPSACCEXTBITMODE = new ProgrammingMode("OPSACCEXTBITMODE");
    public static final ProgrammingMode OPSACCBYTEMODE = new ProgrammingMode("OPSACCBYTEMODE");
    public static final ProgrammingMode ADDRESSMODE = new ProgrammingMode("ADDRESSMODE");
    public static final ProgrammingMode OPSBYTEMODE = new ProgrammingMode("OPSBYTEMODE");
    public static final ProgrammingMode DIRECTBYTEMODE = new ProgrammingMode("DIRECTBYTEMODE");
    public static final ProgrammingMode REGISTERMODE = new ProgrammingMode("REGISTERMODE");
    public static final ProgrammingMode DIRECTBITMODE = new ProgrammingMode("DIRECTBITMODE");
    public static final ProgrammingMode DIRECTMODE = new ProgrammingMode("DIRECTMODE");
    @Nonnull
    private final String standardName;
    @Nonnull
    private final String localName;

    public ProgrammingMode(@Nonnull String standardName) {
        this.standardName = standardName;
        this.localName = Bundle.getMessage(standardName);
    }

    public ProgrammingMode(@Nonnull String standardName, @Nonnull String localName) {
        this.standardName = standardName;
        this.localName = localName;
    }

    @Nonnull
    public String toString() {
        return this.localName;
    }

    @Nonnull
    public String getStandardName() {
        return this.standardName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProgrammingMode)) {
            return false;
        }
        ProgrammingMode that = (ProgrammingMode)o;
        return this.standardName.equals(that.standardName);
    }

    public int hashCode() {
        return this.standardName.hashCode();
    }
}

