/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.Bundle;
import jmri.InstanceManagerAutoDefault;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.managers.AbstractManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedBeanHandleManager
extends AbstractManager<NamedBean>
implements InstanceManagerAutoDefault {
    ArrayList<NamedBeanHandle> namedBeanHandles = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(NamedBeanHandleManager.class);

    @Nonnull
    @CheckReturnValue
    public <T extends NamedBean> NamedBeanHandle<T> getNamedBeanHandle(@Nonnull String name, @Nonnull T bean) {
        Objects.requireNonNull(bean, "bean must be nonnull");
        Objects.requireNonNull(name, "name must be nonnull");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty in getNamedBeanHandle");
        }
        NamedBeanHandle<T> temp = new NamedBeanHandle<T>(name, bean);
        for (NamedBeanHandle h : this.namedBeanHandles) {
            if (!temp.equals(h)) continue;
            return h;
        }
        this.namedBeanHandles.add(temp);
        return temp;
    }

    public <T extends NamedBean> void renameBean(@Nonnull String oldName, @Nonnull String newName, @Nonnull T bean) {
        NamedBeanHandle<T> oldBean = new NamedBeanHandle<T>(oldName, bean);
        for (NamedBeanHandle h : this.namedBeanHandles) {
            if (!oldBean.equals(h)) continue;
            h.setName(newName);
        }
        this.updateListenerRef(oldName, newName, bean);
    }

    public <T extends NamedBean> void moveBean(@Nonnull T oldBean, @Nonnull T newBean, @Nonnull String name) {
        NamedBeanHandle<T> oldNamedBean = new NamedBeanHandle<T>(name, oldBean);
        for (NamedBeanHandle h : this.namedBeanHandles) {
            if (!oldNamedBean.equals(h)) continue;
            h.setBean(newBean);
        }
        this.moveListener(oldBean, newBean, name);
    }

    public void updateBeanFromUserToSystem(@Nonnull NamedBean bean) {
        String systemName = bean.getSystemName();
        String userName = bean.getUserName();
        if (userName == null) {
            log.warn("updateBeanFromUserToSystem requires non-blank user name: \"{}\" not renamed", (Object)systemName);
            return;
        }
        this.renameBean(userName, systemName, bean);
    }

    public void updateBeanFromSystemToUser(@Nonnull NamedBean bean) throws JmriException {
        String userName = bean.getUserName();
        String systemName = bean.getSystemName();
        if (userName == null || userName.equals("")) {
            log.error("UserName is empty, can not update items to use UserName");
            throw new JmriException("UserName is empty, can not update items to use UserName");
        }
        this.renameBean(systemName, userName, bean);
    }

    @CheckReturnValue
    public <T extends NamedBean> boolean inUse(@Nonnull String name, @Nonnull T bean) {
        NamedBeanHandle temp = new NamedBeanHandle(name, bean);
        return this.namedBeanHandles.stream().anyMatch(h -> temp.equals(h));
    }

    @CheckForNull
    @CheckReturnValue
    public <T extends NamedBean> NamedBeanHandle<T> newNamedBeanHandle(@Nonnull String name, @Nonnull T bean, @Nonnull Class<T> type) {
        return this.getNamedBeanHandle(name, bean);
    }

    private void updateListenerRef(@Nonnull String oldName, @Nonnull String newName, @Nonnull NamedBean nBean) {
        PropertyChangeListener[] listeners;
        PropertyChangeListener[] propertyChangeListenerArray = listeners = nBean.getPropertyChangeListenersByReference(oldName);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            nBean.updateListenerRef(listener, newName);
            ++n2;
        }
    }

    private void moveListener(@Nonnull NamedBean oldBean, @Nonnull NamedBean newBean, @Nonnull String currentName) {
        PropertyChangeListener[] listeners;
        PropertyChangeListener[] propertyChangeListenerArray = listeners = oldBean.getPropertyChangeListenersByReference(currentName);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            String listenerRef = oldBean.getListenerRef(l);
            oldBean.removePropertyChangeListener(l);
            newBean.addPropertyChangeListener(l, currentName, listenerRef);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void registerSelf() {
    }

    @Override
    @CheckReturnValue
    public char typeLetter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String makeSystemName(@Nonnull String s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Nonnull
    @CheckReturnValue
    @Deprecated
    public List<String> getSystemNameList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void register(@Nonnull NamedBean n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deregister(@Nonnull NamedBean n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @CheckReturnValue
    public int getXMLOrder() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNames" : "BeanName");
    }

    @Override
    public Class<NamedBean> getNamedBeanClass() {
        return NamedBean.class;
    }
}

