/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.NamedBean;

public class NamedBeanHandle<T extends NamedBean> {
    String name;
    T bean;

    public NamedBeanHandle(@Nonnull String name, @Nonnull T bean) {
        this.name = name;
        this.bean = bean;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @CheckReturnValue
    public T getBean() {
        return this.bean;
    }

    public void setBean(@Nonnull T bean) {
        this.bean = bean;
    }

    public void setName(String name) {
        this.name = name;
    }

    @CheckReturnValue
    public String toString() {
        return "NamedBeanHandle named \"" + this.name + "\" for system name \"" + this.bean.getSystemName() + "\"";
    }

    @CheckReturnValue
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedBeanHandle tmp = (NamedBeanHandle)obj;
        if (!tmp.getName().equals(this.getName())) {
            return false;
        }
        return tmp.getBean() == this.getBean();
    }

    @CheckReturnValue
    public int hashCode() {
        return 259 + this.getName().hashCode();
    }
}

