/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.Arrays;
import java.util.List;
import jmri.Version;
import jmri.profile.ProfileManager;

public interface Metadata {
    public static final String JMRIVERSION = "JMRIVERSION";
    public static final String JMRIVERCANON = "JMRIVERCANON";
    public static final String JMRIVERMAJOR = "JMRIVERMAJOR";
    public static final String JMRIVERMINOR = "JMRIVERMINOR";
    public static final String JMRIVERTEST = "JMRIVERTEST";
    public static final String JVMVERSION = "JVMVERSION";
    public static final String JVMVENDOR = "JVMVENDOR";
    public static final String ACTIVEPROFILE = "activeProfile";
    public static final String COPYRIGHT = "copyright";

    public static String getBySystemName(String name) {
        if (name.equalsIgnoreCase(JMRIVERSION)) {
            return Version.name();
        }
        if (name.equalsIgnoreCase(JMRIVERCANON)) {
            return Version.getCanonicalVersion();
        }
        if (name.equalsIgnoreCase(JMRIVERMAJOR)) {
            return Integer.toString(Version.major);
        }
        if (name.equalsIgnoreCase(JMRIVERMINOR)) {
            return Integer.toString(Version.minor);
        }
        if (name.equalsIgnoreCase(JMRIVERTEST)) {
            return Integer.toString(Version.test);
        }
        if (name.equalsIgnoreCase(JVMVERSION)) {
            return System.getProperty("java.version", "<unknown>");
        }
        if (name.equalsIgnoreCase(JVMVENDOR)) {
            return System.getProperty("java.vendor", "<unknown>");
        }
        if (name.equalsIgnoreCase(ACTIVEPROFILE)) {
            return ProfileManager.getDefault().getActiveProfileName();
        }
        if (name.equalsIgnoreCase(COPYRIGHT)) {
            return Version.getCopyright();
        }
        return System.getProperty(name);
    }

    public static String[] getSystemNameArray() {
        String[] names = new String[]{JMRIVERSION, JMRIVERCANON, JMRIVERMAJOR, JMRIVERMINOR, JMRIVERTEST, JVMVERSION, JVMVENDOR, ACTIVEPROFILE, COPYRIGHT};
        return names;
    }

    public static List<String> getSystemNameList() {
        return Arrays.asList(Metadata.getSystemNameArray());
    }
}

