/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyVetoException;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.SystemConnectionMemo;
import jmri.beans.SilenceablePropertyChangeProvider;
import jmri.beans.VetoableChangeProvider;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Manager<E extends NamedBean>
extends SilenceablePropertyChangeProvider,
VetoableChangeProvider {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"}, justification="Private not available in interface; just needed for deprecation")
    public static final Logger deprecatedManagerLogger = LoggerFactory.getLogger(Manager.class);
    public static final int SENSORS = 10;
    public static final int TURNOUTS = 20;
    public static final int LIGHTS = 30;
    public static final int REPORTERS = 40;
    public static final int MEMORIES = 50;
    public static final int SENSORGROUPS = 60;
    public static final int SIGNALHEADS = 70;
    public static final int SIGNALMASTS = 80;
    public static final int SIGNALGROUPS = 90;
    public static final int BLOCKS = 100;
    public static final int OBLOCKS = 110;
    public static final int LAYOUTBLOCKS = 120;
    public static final int SECTIONS = 130;
    public static final int TRANSITS = 140;
    public static final int BLOCKBOSS = 150;
    public static final int ROUTES = 160;
    public static final int WARRANTS = 170;
    public static final int SIGNALMASTLOGICS = 180;
    public static final int IDTAGS = 190;
    public static final int ANALOGIOS = 200;
    public static final int METERS = 210;
    public static final int STRINGIOS = 220;
    public static final int LOGIXS = 230;
    public static final int CONDITIONALS = 240;
    public static final int AUDIO = 250;
    public static final int TIMEBASE = 260;
    public static final int PANELFILES = 270;
    public static final int ENTRYEXIT = 280;
    public static final int LOGIXNGS = 290;
    public static final int LOGIXNG_CONDITIONALNGS = 300;
    public static final int LOGIXNG_MODULES = 310;
    public static final int LOGIXNG_TABLES = 320;
    public static final int LOGIXNG_DIGITAL_EXPRESSIONS = 330;
    public static final int LOGIXNG_DIGITAL_ACTIONS = 340;
    public static final int LOGIXNG_DIGITAL_BOOLEAN_ACTIONS = 350;
    public static final int LOGIXNG_ANALOG_EXPRESSIONS = 360;
    public static final int LOGIXNG_ANALOG_ACTIONS = 370;
    public static final int LOGIXNG_STRING_EXPRESSIONS = 380;
    public static final int LOGIXNG_STRING_ACTIONS = 390;
    public static final int METERFRAMES = 400;
    public static final int CTCDATA = 410;

    @CheckReturnValue
    @Nonnull
    public SystemConnectionMemo getMemo();

    @CheckReturnValue
    @Nonnull
    public String getSystemPrefix();

    @CheckReturnValue
    public char typeLetter();

    public Class<E> getNamedBeanClass();

    default public String getSystemNamePrefix() {
        return String.valueOf(this.getSystemPrefix()) + this.typeLetter();
    }

    default public String getSubSystemNamePrefix() {
        return this.getSystemNamePrefix();
    }

    @Nonnull
    default public String makeSystemName(@Nonnull String name) throws NamedBean.BadSystemNameException {
        return this.makeSystemName(name, true);
    }

    @Nonnull
    default public String makeSystemName(@Nonnull String name, boolean logErrors) throws NamedBean.BadSystemNameException {
        return this.makeSystemName(name, logErrors, Locale.getDefault());
    }

    @Nonnull
    default public String makeSystemName(@Nonnull String name, boolean logErrors, Locale locale) throws NamedBean.BadSystemNameException {
        String prefix = this.getSystemNamePrefix();
        if (name.trim().isEmpty()) {
            throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemNameInvalidPrefix", prefix);
        }
        return this.validateSystemNameFormat(name.startsWith(prefix) ? name : String.valueOf(prefix) + name, locale);
    }

    @Nonnull
    default public String validateSystemNameFormat(@Nonnull String name) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormat(name, Locale.getDefault());
    }

    @Nonnull
    default public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNamePrefix(name, locale);
    }

    @Nonnull
    default public String validateSystemNamePrefix(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        String prefix = this.getSystemNamePrefix();
        if (name.equals(prefix)) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameMatchesPrefix", name);
        }
        if (!name.startsWith(prefix)) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameInvalidPrefix", prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateTrimmedSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        String prefix;
        String suffix = (name = this.validateSystemNamePrefix(name, locale)).substring((prefix = this.getSystemNamePrefix()).length());
        if (!suffix.equals(suffix.trim())) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameTrailingWhitespace", name, prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateTrimmedMin1NumberSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        if (!(name = this.validateTrimmedSystemNameFormat(name, locale)).matches(".*\\d+.*")) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameMin1Number", name);
        }
        return name;
    }

    default public String validateSystemNameFormatOnlyNumeric(@Nonnull String name, @Nonnull Locale locale) {
        name = this.validateTrimmedSystemNameFormat(name, locale);
        try {
            Integer.parseInt(name.substring(this.getSystemNamePrefix().length()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameNotInteger", name, this.getSystemNamePrefix());
        }
        return name;
    }

    @Nonnull
    default public String validateBadCharsInSystemNameFormat(@Nonnull String name, @Nonnull Locale locale, @Nonnull String[] invalidChars) throws NamedBean.BadSystemNameException {
        name = this.validateSystemNamePrefix(name, locale);
        String[] stringArray = invalidChars;
        int n = invalidChars.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (name.contains(s)) {
                throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCharacter", name, s);
            }
            ++n2;
        }
        return name;
    }

    @Nonnull
    default public String validateUppercaseTrimmedSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        String upper;
        String prefix;
        String suffix = (name = this.validateTrimmedSystemNameFormat(name, locale)).substring((prefix = this.getSystemNamePrefix()).length());
        if (!suffix.equals(upper = suffix.toUpperCase())) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameNotUpperCase", name, prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateIntegerSystemNameFormat(@Nonnull String name, int min, int max, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        name = this.validateTrimmedSystemNameFormat(name, locale);
        String prefix = this.getSystemNamePrefix();
        String suffix = name.substring(prefix.length());
        try {
            int number = Integer.parseInt(suffix);
            if (number < min) {
                throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameIntegerLessThan", name, min);
            }
            if (number > max) {
                throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameIntegerGreaterThan", name, max);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameNotInteger", name, prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateNmraAccessorySystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateIntegerSystemNameFormat(name, 1, 2044, locale);
    }

    @CheckReturnValue
    @OverrideMustInvoke
    default public NameValidity validSystemNameFormat(@Nonnull String systemName) {
        String prefix = this.getSystemNamePrefix();
        if (prefix.equals(systemName)) {
            return NameValidity.VALID_AS_PREFIX_ONLY;
        }
        return systemName.startsWith(prefix) ? NameValidity.VALID : NameValidity.INVALID;
    }

    default public boolean isValidSystemNameFormat(@Nonnull String systemName) {
        return this.validSystemNameFormat(systemName) == NameValidity.VALID;
    }

    public void dispose();

    @CheckReturnValue
    public int getObjectCount();

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public List<String> getSystemNameList();

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public List<E> getNamedBeanList();

    @CheckReturnValue
    @Nonnull
    public SortedSet<E> getNamedBeanSet();

    @CheckReturnValue
    @CheckForNull
    @Deprecated
    default public E getBeanBySystemName(@Nonnull String systemName) {
        LoggingUtil.deprecationWarning(deprecatedManagerLogger, "getBeanBySystemName");
        return this.getBySystemName(systemName);
    }

    @CheckReturnValue
    @CheckForNull
    @Deprecated
    default public E getBeanByUserName(@Nonnull String userName) {
        LoggingUtil.deprecationWarning(deprecatedManagerLogger, "getBeanByUserName");
        return this.getByUserName(userName);
    }

    @CheckReturnValue
    @CheckForNull
    public E getBySystemName(@Nonnull String var1);

    @CheckReturnValue
    @CheckForNull
    public E getByUserName(@Nonnull String var1);

    @CheckReturnValue
    @CheckForNull
    public E getNamedBean(@Nonnull String var1);

    @Nonnull
    default public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        return new LinkedList();
    }

    public void deleteBean(@Nonnull E var1, @Nonnull String var2) throws PropertyVetoException;

    public void register(@Nonnull E var1);

    public void deregister(@Nonnull E var1);

    @CheckReturnValue
    public int getXMLOrder();

    @CheckReturnValue
    @Nonnull
    default public String getBeanTypeHandled() {
        return this.getBeanTypeHandled(false);
    }

    @CheckReturnValue
    @Nonnull
    public String getBeanTypeHandled(boolean var1);

    @CheckReturnValue
    public static int getSystemPrefixLength(@Nonnull String inputName) {
        if (inputName.isEmpty()) {
            throw new NamedBean.BadSystemNameException();
        }
        if (!Character.isLetter(inputName.charAt(0))) {
            throw new NamedBean.BadSystemNameException();
        }
        int i = 1;
        while (i < inputName.length()) {
            if (!Character.isDigit(inputName.charAt(i))) break;
            ++i;
        }
        return i;
    }

    @CheckReturnValue
    @Nonnull
    public static String getSystemPrefix(@Nonnull String inputName) {
        return inputName.substring(0, Manager.getSystemPrefixLength(inputName));
    }

    default public String getEntryToolTip() {
        return null;
    }

    public void addDataListener(ManagerDataListener<E> var1);

    public void removeDataListener(ManagerDataListener<E> var1);

    default public void setDataListenerMute(boolean muted) {
    }

    @Deprecated
    default public void setPropertyChangesMuted(@Nonnull String propertyName, boolean muted) {
        this.setPropertyChangesSilenced(propertyName, muted);
    }

    @Immutable
    public static final class ManagerDataEvent<E extends NamedBean>
    extends EventObject {
        public static final int CONTENTS_CHANGED = 0;
        public static final int INTERVAL_ADDED = 1;
        public static final int INTERVAL_REMOVED = 2;
        private final int type;
        private final int index0;
        private final int index1;
        private final transient E changedBean;
        private final transient Manager<E> source;

        public ManagerDataEvent(@Nonnull Manager<E> source, int type, int index0, int index1, E changedBean) {
            super(source);
            this.source = source;
            this.type = type;
            this.index0 = Math.min(index0, index1);
            this.index1 = Math.max(index0, index1);
            this.changedBean = changedBean;
        }

        @Override
        public Manager<E> getSource() {
            return this.source;
        }

        public int getIndex0() {
            return this.index0;
        }

        public int getIndex1() {
            return this.index1;
        }

        public E getChangedBean() {
            return this.changedBean;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[type=" + this.type + ", index0=" + this.index0 + ", index1=" + this.index1 + "]";
        }
    }

    public static interface ManagerDataListener<E extends NamedBean> {
        public void contentsChanged(ManagerDataEvent<E> var1);

        public void intervalAdded(ManagerDataEvent<E> var1);

        public void intervalRemoved(ManagerDataEvent<E> var1);
    }

    public static enum NameValidity {
        VALID,
        INVALID,
        VALID_AS_PREFIX_ONLY;

    }
}

