/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.concurrent.Immutable;
import jmri.Bundle;

@Immutable
public interface LocoAddress {
    public int getNumber();

    public Protocol getProtocol();

    public static enum Protocol {
        DCC_SHORT("dcc_short", "ProtocolDCC_Short"),
        DCC_LONG("dcc_long", "ProtocolDCC_Long"),
        DCC("dcc", "ProtocolDCC"),
        SELECTRIX("selectrix", "ProtocolSelectrix"),
        MOTOROLA("motorola", "ProtocolMotorola"),
        MFX("mfx", "ProtocolMFX"),
        M4("m4", "ProtocolM4"),
        OPENLCB("openlcb", "ProtocolOpenLCB"),
        LGB("lgb", "ProtocolLGB");

        String shortName;
        String peopleName;

        private Protocol(String shName, String peopleKey) {
            this.shortName = shName;
            this.peopleName = Bundle.getMessage(peopleKey);
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getPeopleName() {
            return this.peopleName;
        }

        public static Protocol getByShortName(String shName) {
            Protocol[] protocolArray = Protocol.values();
            int n = protocolArray.length;
            int n2 = 0;
            while (n2 < n) {
                Protocol p = protocolArray[n2];
                if (p.shortName.equals(shName)) {
                    return p;
                }
                ++n2;
            }
            throw new IllegalArgumentException("argument value " + shName + " not valid");
        }

        public static Protocol getByPeopleName(String pName) {
            Protocol[] protocolArray = Protocol.values();
            int n = protocolArray.length;
            int n2 = 0;
            while (n2 < n) {
                Protocol p = protocolArray[n2];
                if (p.peopleName.equals(pName)) {
                    return p;
                }
                ++n2;
            }
            throw new IllegalArgumentException("argument value " + pName + " not valid");
        }
    }
}

