/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Light;
import jmri.NamedBean;
import jmri.ProvidingManager;

public interface LightManager
extends ProvidingManager<Light> {
    @Nonnull
    public Light provideLight(@Nonnull String var1) throws IllegalArgumentException;

    @Override
    @Nonnull
    default public Light provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideLight(name);
    }

    @Override
    public void dispose();

    @CheckReturnValue
    @CheckForNull
    public Light getLight(@Nonnull String var1);

    @Nonnull
    public Light newLight(@Nonnull String var1, @CheckForNull String var2) throws IllegalArgumentException;

    @Override
    @CheckReturnValue
    @CheckForNull
    public Light getByUserName(@Nonnull String var1);

    @Override
    @CheckReturnValue
    @CheckForNull
    public Light getBySystemName(@Nonnull String var1);

    @CheckReturnValue
    default public boolean validSystemNameConfig(@Nonnull String systemName) {
        try {
            this.validateSystemNameFormat(systemName);
            return true;
        }
        catch (NamedBean.BadSystemNameException badSystemNameException) {
            return false;
        }
    }

    @CheckReturnValue
    @Nonnull
    public String convertSystemNameToAlternate(@Nonnull String var1);

    public void activateAllLights();

    @CheckReturnValue
    public boolean supportsVariableLights(@Nonnull String var1);

    @CheckReturnValue
    public boolean allowMultipleAdditions(@Nonnull String var1);

    @Nonnull
    public String getNextValidAddress(@Nonnull String var1, @Nonnull String var2, boolean var3) throws JmriException;

    @Nonnull
    public String createSystemName(@Nonnull String var1, @Nonnull String var2) throws JmriException;
}

