/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.AnalogIOManager;
import jmri.Disposable;
import jmri.IdTagManager;
import jmri.InstanceInitializer;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.LightManager;
import jmri.MemoryManager;
import jmri.MeterManager;
import jmri.ProxyManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.StringIOManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.util.ThreadingUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstanceManager {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<Class<?>, List<Object>> managerLists = Collections.synchronizedMap(new HashMap());
    private final HashMap<Class<?>, InstanceInitializer> initializers = new HashMap();
    private final HashMap<Class<?>, StateHolder> initState = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(InstanceManager.class);
    private static final boolean traceFileActive = log.isTraceEnabled();
    private static final boolean traceFileAppend = false;
    private int traceFileIndent = 1;
    private static final String traceFileName = "instanceManagerSequence.txt";
    private static PrintWriter traceFileWriter;

    static {
        PrintWriter tempWriter = null;
        try {
            try {
                tempWriter = traceFileActive ? new PrintWriter(new BufferedWriter(new FileWriter(new File(traceFileName), false))) : null;
            }
            catch (IOException e) {
                log.error("failed to open log file", (Throwable)e);
                traceFileWriter = tempWriter;
            }
        }
        finally {
            traceFileWriter = tempWriter;
        }
    }

    public static <T> void store(@Nonnull T item, @Nonnull Class<T> type) {
        log.debug("Store item of type {}", (Object)type.getName());
        if (item == null) {
            NullPointerException npe = new NullPointerException();
            log.error("Should not store null value of type {}", (Object)type.getName());
            throw npe;
        }
        List<T> l = InstanceManager.getList(type);
        l.add(item);
        InstanceManager.getDefault().pcs.fireIndexedPropertyChange(InstanceManager.getListPropertyName(type), l.indexOf(item), null, item);
    }

    @Nonnull
    public static <T> List<T> getList(@Nonnull Class<T> type) {
        return InstanceManager.getDefault().getInstances(type);
    }

    public static <T> void reset(@Nonnull Class<T> type) {
        InstanceManager.getDefault().clear(type);
    }

    public static <T> void deregister(@Nonnull T item, @Nonnull Class<T> type) {
        InstanceManager.getDefault().remove(item, type);
    }

    public <T> void remove(@Nonnull T item, @Nonnull Class<T> type) {
        log.debug("Remove item type {}", (Object)type.getName());
        List<T> l = InstanceManager.getList(type);
        int index = l.indexOf(item);
        if (index != -1) {
            l.remove(item);
            if (item instanceof Disposable) {
                this.dispose((Disposable)item);
            }
        }
        if (l.isEmpty()) {
            this.setInitializationState(type, InitializationState.NOTSET);
        }
        if (index != -1) {
            this.pcs.fireIndexedPropertyChange(InstanceManager.getListPropertyName(type), index, item, null);
        }
    }

    @Nonnull
    public static <T> T getDefault(@Nonnull Class<T> type) {
        log.trace("getDefault of type {}", (Object)type.getName());
        T object = InstanceManager.getNullableDefault(type);
        if (object == null) {
            throw new NullPointerException("Required nonnull default for " + type.getName() + " does not exist.");
        }
        return object;
    }

    @CheckForNull
    public static <T> T getNullableDefault(@Nonnull Class<T> type) {
        return InstanceManager.getDefault().getInstance(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public <T> T getInstance(@Nonnull Class<T> type) {
        log.trace("getOptionalDefault of type {}", (Object)type.getName());
        Class<T> clazz = type;
        synchronized (clazz) {
            List<T> l = this.getInstances(type);
            if (!l.isEmpty()) {
                return l.get(l.size() - 1);
            }
            log.trace("jmri.implementation.SignalSpeedMap init", (Throwable)new Exception());
            if (traceFileActive) {
                this.traceFilePrint("Start initialization: " + type.toString());
                ++this.traceFileIndent;
            }
            InitializationState working = this.getInitializationState(type);
            Exception except = this.getInitializationException(type);
            this.setInitializationState(type, InitializationState.STARTED);
            if (working == InitializationState.STARTED) {
                log.error("Proceeding to initialize {} while already in initialization", type, (Object)new Exception("Thread \"" + Thread.currentThread().getName() + "\""));
                log.error("    Prior initialization:", (Throwable)except);
                if (traceFileActive) {
                    this.traceFilePrint("*** Already in process ***");
                }
            } else if (working == InitializationState.DONE) {
                log.error("Proceeding to initialize {} but initialization is marked as complete", type, (Object)new Exception("Thread \"" + Thread.currentThread().getName() + "\""));
            }
            log.debug("    attempt auto-create of {}", (Object)type.getName());
            if (InstanceManagerAutoDefault.class.isAssignableFrom(type)) {
                try {
                    T obj = type.getConstructor(null).newInstance(null);
                    l.add(obj);
                    if (obj instanceof InstanceManagerAutoInitialize) {
                        ((InstanceManagerAutoInitialize)obj).initialize();
                    }
                    log.debug("      auto-created default of {}", (Object)type.getName());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    log.error("Exception creating auto-default object for {}", (Object)type.getName(), (Object)e);
                    this.setInitializationState(type, InitializationState.FAILED);
                    if (traceFileActive) {
                        --this.traceFileIndent;
                        this.traceFilePrint("End initialization (no object) A: " + type.toString());
                    }
                    return null;
                }
                this.setInitializationState(type, InitializationState.DONE);
                if (traceFileActive) {
                    --this.traceFileIndent;
                    this.traceFilePrint("End initialization A: " + type.toString());
                }
                return l.get(l.size() - 1);
            }
            log.debug("    attempt initializer create of {}", (Object)type.getName());
            if (this.initializers.containsKey(type)) {
                try {
                    Object obj = this.initializers.get(type).getDefault(type);
                    log.debug("      initializer created default of {}", (Object)type.getName());
                    l.add(obj);
                    if (obj instanceof InstanceManagerAutoInitialize) {
                        ((InstanceManagerAutoInitialize)obj).initialize();
                    }
                    this.setInitializationState(type, InitializationState.DONE);
                    if (traceFileActive) {
                        --this.traceFileIndent;
                        this.traceFilePrint("End initialization I: " + type.toString());
                    }
                    return l.get(l.size() - 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error("Known initializer for {} does not provide a default instance for that class", (Object)type.getName());
                }
            } else {
                log.debug("        no initializer registered for {}", (Object)type.getName());
            }
            this.setInitializationState(type, InitializationState.FAILED);
            if (traceFileActive) {
                --this.traceFileIndent;
                this.traceFilePrint("End initialization (no object) E: " + type.toString());
            }
            return null;
        }
    }

    @Nonnull
    public static <T> Optional<T> getOptionalDefault(@Nonnull Class<T> type) {
        return Optional.ofNullable(InstanceManager.getNullableDefault(type));
    }

    @Nonnull
    public static <T> T setDefault(@Nonnull Class<T> type, @Nonnull T item) {
        log.trace("setDefault for type {}", (Object)type.getName());
        if (item == null) {
            NullPointerException npe = new NullPointerException();
            log.error("Should not set default of type {} to null value", (Object)type.getName());
            throw npe;
        }
        Object oldDefault = InstanceManager.containsDefault(type) ? (Object)InstanceManager.getNullableDefault(type) : null;
        List<T> l = InstanceManager.getList(type);
        l.remove(item);
        l.add(item);
        if (oldDefault == null || !oldDefault.equals(item)) {
            InstanceManager.getDefault().pcs.firePropertyChange(InstanceManager.getDefaultsPropertyName(type), oldDefault, item);
        }
        return InstanceManager.getDefault(type);
    }

    public static <T> boolean containsDefault(@Nonnull Class<T> type) {
        List<T> l = InstanceManager.getList(type);
        return !l.isEmpty();
    }

    public static <T> boolean isInitialized(@Nonnull Class<T> type) {
        return InstanceManager.getDefault().managerLists.get(type) != null;
    }

    @Nonnull
    public static String contentsToString() {
        StringBuilder retval = new StringBuilder();
        InstanceManager.getDefault().managerLists.keySet().stream().forEachOrdered(c -> {
            retval.append("List of ");
            retval.append(c);
            retval.append(" with ");
            retval.append(Integer.toString(InstanceManager.getList(c).size()));
            retval.append(" objects\n");
            InstanceManager.getList(c).stream().forEachOrdered(o -> {
                retval.append("    ");
                retval.append(o.getClass().toString());
                retval.append("\n");
            });
        });
        return retval.toString();
    }

    public static synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        InstanceManager.getDefault().pcs.removePropertyChangeListener(l);
    }

    public static synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        InstanceManager.getDefault().pcs.removePropertyChangeListener(propertyName, l);
    }

    public static synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        InstanceManager.getDefault().pcs.addPropertyChangeListener(l);
    }

    public static synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        InstanceManager.getDefault().pcs.addPropertyChangeListener(propertyName, l);
    }

    public static String getDefaultsPropertyName(Class<?> clazz) {
        return "default-" + clazz.getName();
    }

    public static String getListPropertyName(Class<?> clazz) {
        return "list-" + clazz.getName();
    }

    public static LightManager lightManagerInstance() {
        return InstanceManager.getDefault(LightManager.class);
    }

    public static MemoryManager memoryManagerInstance() {
        return InstanceManager.getDefault(MemoryManager.class);
    }

    public static SensorManager sensorManagerInstance() {
        return InstanceManager.getDefault(SensorManager.class);
    }

    public static TurnoutManager turnoutManagerInstance() {
        return InstanceManager.getDefault(TurnoutManager.class);
    }

    public static ThrottleManager throttleManagerInstance() {
        return InstanceManager.getDefault(ThrottleManager.class);
    }

    public static void setTurnoutManager(TurnoutManager p) {
        log.debug(" setTurnoutManager");
        TurnoutManager apm = InstanceManager.getDefault(TurnoutManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: TurnoutManager default isn't an AbstractProxyManager<Turnout>");
        }
    }

    public static void setThrottleManager(ThrottleManager p) {
        InstanceManager.store(p, ThrottleManager.class);
    }

    public static void setLightManager(LightManager p) {
        log.debug(" setLightManager");
        LightManager apm = InstanceManager.getDefault(LightManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: LightManager default isn't an AbstractProxyManager<Light>");
        }
    }

    public static void setReporterManager(ReporterManager p) {
        log.debug(" setReporterManager");
        ReporterManager apm = InstanceManager.getDefault(ReporterManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: ReporterManager default isn't an AbstractProxyManager<Reporter>");
        }
    }

    public static void setSensorManager(SensorManager p) {
        log.debug(" setSensorManager");
        SensorManager apm = InstanceManager.getDefault(SensorManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: SensorManager default isn't an AbstractProxyManager<Sensor>");
        }
    }

    public static void setIdTagManager(IdTagManager p) {
        log.debug(" setIdTagManager");
        IdTagManager apm = InstanceManager.getDefault(IdTagManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: IdTagManager default isn't an AbstractProxyManager<IdTag>");
        }
    }

    public static void setMeterManager(MeterManager p) {
        log.debug(" setMeterManager");
        MeterManager apm = InstanceManager.getDefault(MeterManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: MeterManager default isn't an AbstractProxyManager<Meter>");
        }
    }

    public static void setAnalogIOManager(AnalogIOManager p) {
        log.debug(" setAnalogIOManager");
        AnalogIOManager apm = InstanceManager.getDefault(AnalogIOManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: AnalogIOManager default isn't an AbstractProxyManager<AnalogIO>");
        }
    }

    public static void setStringIOManager(StringIOManager p) {
        log.debug(" setStringIOManager");
        StringIOManager apm = InstanceManager.getDefault(StringIOManager.class);
        if (apm instanceof ProxyManager) {
            ((ProxyManager)((Object)apm)).addManager(p);
        } else {
            log.error("Incorrect setup: StringIOManager default isn't an AbstractProxyManager<StringIO>");
        }
    }

    public InstanceManager() {
        ServiceLoader.load(InstanceInitializer.class).forEach(provider -> provider.getInitalizes().forEach(cls -> {
            this.initializers.put((Class<?>)cls, (InstanceInitializer)provider);
            log.debug("Using {} to provide default instance of {}", (Object)provider.getClass().getName(), (Object)cls.getName());
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T> List<T> getInstances(@Nonnull Class<T> type) {
        log.trace("Get list of type {}", (Object)type.getName());
        Class<T> clazz = type;
        synchronized (clazz) {
            if (this.managerLists.get(type) == null) {
                this.managerLists.put(type, new ArrayList());
                this.pcs.fireIndexedPropertyChange(InstanceManager.getListPropertyName(type), 0, null, null);
            }
            return this.managerLists.get(type);
        }
    }

    private void dispose(@Nonnull Disposable disposable) {
        boolean canDispose = true;
        for (List<Object> list : this.managerLists.values()) {
            if (!list.contains(disposable)) continue;
            canDispose = false;
            break;
        }
        if (canDispose) {
            ThreadingUtil.runOnGUI(disposable::dispose);
        }
    }

    public void clearAll() {
        log.debug("Clearing InstanceManager");
        if (traceFileActive) {
            traceFileWriter.println("clearAll");
        }
        LazyInstanceManager.resetInstanceManager();
        new HashSet(this.managerLists.keySet()).forEach(this::clear);
        this.managerLists.keySet().forEach(type -> {
            if (this.getInitializationState((Class<?>)type) != InitializationState.NOTSET) {
                log.warn("list of {} was reinitialized during clearAll", type, (Object)new Exception());
                if (traceFileActive) {
                    traceFileWriter.println("WARN: list of " + type + " was reinitialized during clearAll");
                }
            }
            if (!this.managerLists.get(type).isEmpty()) {
                log.warn("list of {} was not cleared, {} entries", new Object[]{type, this.managerLists.get(type).size(), new Exception()});
                if (traceFileActive) {
                    traceFileWriter.println("WARN: list of " + type + " was not cleared, " + this.managerLists.get(type).size() + " entries");
                }
            }
        });
        if (traceFileActive) {
            traceFileWriter.println("");
            traceFileWriter.flush();
        }
    }

    public <T> void clear(@Nonnull Class<T> type) {
        log.trace("Clearing managers of {}", (Object)type.getName());
        ArrayList<Object> toClear = new ArrayList<Object>(this.getInstances(type));
        toClear.forEach(o -> this.remove(o, type));
        this.setInitializationState(type, InitializationState.NOTSET);
        this.managerLists.put(type, new ArrayList());
    }

    @Nonnull
    public static InstanceManager getDefault() {
        return LazyInstanceManager.getInstanceManager();
    }

    private void setInitializationState(Class<?> type, InitializationState state) {
        log.trace("set state {} for {}", type, (Object)state);
        if (state == InitializationState.STARTED) {
            this.initState.put(type, new StateHolder(state, new Exception("Thread " + Thread.currentThread().getName())));
        } else {
            this.initState.put(type, new StateHolder(state, null));
        }
    }

    private InitializationState getInitializationState(Class<?> type) {
        StateHolder holder = this.initState.get(type);
        if (holder == null) {
            return InitializationState.NOTSET;
        }
        return holder.state;
    }

    private Exception getInitializationException(Class<?> type) {
        StateHolder holder = this.initState.get(type);
        if (holder == null) {
            return null;
        }
        return holder.exception;
    }

    private void traceFilePrint(String msg) {
        String pad = StringUtils.repeat((char)' ', (int)(this.traceFileIndent * 2));
        String threadName = "[" + Thread.currentThread().getName() + "]";
        String threadNamePad = StringUtils.repeat((char)' ', (int)Math.max(25 - threadName.length(), 0));
        String text = String.valueOf(threadName) + threadNamePad + "|" + pad + msg;
        traceFileWriter.println(text);
        traceFileWriter.flush();
        log.trace(text);
    }

    private static enum InitializationState {
        NOTSET,
        NOTSTARTED,
        STARTED,
        FAILED,
        DONE;

    }

    private static class LazyInstanceManager {
        private static InstanceManager instanceManager = new InstanceManager();

        private LazyInstanceManager() {
        }

        public static InstanceManager getInstanceManager() {
            return instanceManager;
        }

        public static synchronized void resetInstanceManager() {
            try {
                instanceManager = new InstanceManager();
            }
            catch (Exception exception) {
                log.error("can't create new InstanceManager");
            }
        }
    }

    private static final class StateHolder {
        InitializationState state;
        Exception exception;

        StateHolder(InitializationState state, Exception exception) {
            this.state = state;
            this.exception = exception;
        }
    }
}

