/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.concurrent.Immutable;
import jmri.LocoAddress;

@Immutable
public class DccLocoAddress
implements LocoAddress {
    protected final long number;
    protected final LocoAddress.Protocol protocol;

    public DccLocoAddress(int number, boolean isLong) {
        this.number = number;
        this.protocol = isLong ? LocoAddress.Protocol.DCC_LONG : LocoAddress.Protocol.DCC_SHORT;
    }

    public DccLocoAddress(int number, LocoAddress.Protocol protocol) {
        this.number = number;
        this.protocol = protocol;
    }

    public DccLocoAddress(DccLocoAddress l) {
        this.number = l.number;
        this.protocol = l.protocol;
    }

    public boolean equals(Object a) {
        if (a != null && a.getClass().equals(this.getClass())) {
            DccLocoAddress other;
            block4: {
                try {
                    other = (DccLocoAddress)a;
                    if (this.number == other.number) break block4;
                    return false;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }
            return this.protocol == other.protocol;
        }
        return false;
    }

    public int hashCode() {
        switch (this.protocol) {
            case DCC_LONG: {
                return (int)(20000L + this.number & 0xFFFFFFFFFFFFFFFFL);
            }
            case SELECTRIX: {
                return (int)(30000L + this.number & 0xFFFFFFFFFFFFFFFFL);
            }
            case MOTOROLA: {
                return (int)(40000L + this.number & 0xFFFFFFFFFFFFFFFFL);
            }
            case MFX: {
                return (int)(50000L + this.number & 0xFFFFFFFFFFFFFFFFL);
            }
            case M4: {
                return (int)(60000L + this.number & 0xFFFFFFFFFFFFFFFFL);
            }
            case OPENLCB: {
                return (int)(70000L + this.number & 0xFFFFFFFFFFFFFFFFL);
            }
            case LGB: {
                return (int)(80000L + this.number & 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return (int)(this.number & 0xFFFFFFFFFFFFFFFFL);
    }

    public String toString() {
        switch (this.protocol) {
            case DCC_SHORT: {
                return this.number + "(S)";
            }
            case DCC_LONG: {
                return this.number + "(L)";
            }
            case SELECTRIX: {
                return this.number + "(SX)";
            }
            case MOTOROLA: {
                return this.number + "(MM)";
            }
            case M4: {
                return this.number + "(M4)";
            }
            case MFX: {
                return this.number + "(MFX)";
            }
            case OPENLCB: {
                return this.number + "(OpenLCB)";
            }
            case LGB: {
                return this.number + "(LGB)";
            }
        }
        return this.number + "(D)";
    }

    public boolean isLongAddress() {
        return this.protocol != LocoAddress.Protocol.DCC_SHORT;
    }

    @Override
    public LocoAddress.Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public int getNumber() {
        return (int)this.number;
    }
}

