/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import jmri.Bundle;
import jmri.Conditional;
import jmri.ConditionalManager;
import jmri.InstanceManager;
import jmri.Light;
import jmri.Memory;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Timebase;
import jmri.Turnout;
import jmri.jmrit.beantable.LogixTableAction;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalVariable {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.conditional.ConditionalBundle");
    public static final int NUM_COMPARE_OPERATIONS = 5;
    public static final int LESS_THAN = 1;
    public static final int LESS_THAN_OR_EQUAL = 2;
    public static final int EQUAL = 3;
    public static final int GREATER_THAN_OR_EQUAL = 4;
    public static final int GREATER_THAN = 5;
    private boolean _not = false;
    private Conditional.Operator _opern = Conditional.Operator.NONE;
    private Conditional.Type _type = Conditional.Type.NONE;
    private String _name = "";
    private String _dataString = "";
    private int _num1 = 0;
    private int _num2 = 0;
    private String _guiName = "";
    private NamedBeanHandle<?> _namedBean = null;
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private boolean _triggersActions = true;
    private int _state = 1;
    private NamedBeanHandle<?> _namedBeanData = null;
    private static final Logger log = LoggerFactory.getLogger(ConditionalVariable.class);

    public ConditionalVariable() {
    }

    public ConditionalVariable(boolean not, Conditional.Operator opern, Conditional.Type type, String name, boolean trigger) {
        this._not = not;
        this._opern = opern;
        this._type = type;
        this._name = name;
        this._triggersActions = trigger;
        this._guiName = "";
        try {
            Conditional.ItemType itemType = type.getItemType();
            switch (itemType) {
                case SENSOR: {
                    try {
                        Sensor sn = InstanceManager.sensorManagerInstance().provideSensor(this._name);
                        this._namedBean = this.nbhm.getNamedBeanHandle(this._name, sn);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.error("invalid sensor name= \"{}\" in state variable", (Object)this._name);
                    }
                    break;
                }
                case TURNOUT: {
                    try {
                        Turnout tn = InstanceManager.turnoutManagerInstance().provideTurnout(this._name);
                        this._namedBean = this.nbhm.getNamedBeanHandle(this._name, tn);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.error("invalid turnout name= \"{}\" in state variable", (Object)this._name);
                    }
                    break;
                }
                case MEMORY: {
                    try {
                        Memory my = InstanceManager.memoryManagerInstance().provideMemory(this._name);
                        this._namedBean = this.nbhm.getNamedBeanHandle(this._name, my);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.error("invalid memory name= \"{}\" in state variable", (Object)this._name);
                    }
                    break;
                }
                case LIGHT: {
                    try {
                        Light l = InstanceManager.lightManagerInstance().provideLight(this._name);
                        this._namedBean = this.nbhm.getNamedBeanHandle(this._name, l);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.error("invalid light name= \"{}\" in state variable", (Object)this._name);
                    }
                    break;
                }
                case SIGNALHEAD: {
                    SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(this._name);
                    if (s == null) {
                        log.error("invalid signalhead name= \"{}\" in state variable", (Object)this._name);
                        return;
                    }
                    this._namedBean = this.nbhm.getNamedBeanHandle(this._name, s);
                    break;
                }
                case SIGNALMAST: {
                    try {
                        SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(this._name);
                        this._namedBean = this.nbhm.getNamedBeanHandle(this._name, sm);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.error("invalid signalmast name= \"{}\" in state variable", (Object)this._name);
                    }
                    break;
                }
                case ENTRYEXIT: {
                    DestinationPoints nb = InstanceManager.getDefault(EntryExitPairs.class).getBySystemName(this._name);
                    if (nb == null) {
                        log.error("invalid entry exit name= \"{}\" in state variable", (Object)this._name);
                        return;
                    }
                    this._namedBean = this.nbhm.getNamedBeanHandle(this._name, nb);
                    break;
                }
                case CONDITIONAL: {
                    Conditional c = InstanceManager.getDefault(ConditionalManager.class).getConditional(this._name);
                    if (c == null) {
                        log.error("invalid conditional; name= \"{}\" in state variable", (Object)this._name);
                        return;
                    }
                    this._namedBean = this.nbhm.getNamedBeanHandle(this._name, c);
                    break;
                }
                case WARRANT: {
                    Warrant w = InstanceManager.getDefault(WarrantManager.class).getWarrant(this._name);
                    if (w == null) {
                        log.error("invalid warrant name= \"{}\" in state variable", (Object)this._name);
                        return;
                    }
                    this._namedBean = this.nbhm.getNamedBeanHandle(this._name, w);
                    break;
                }
                case OBLOCK: {
                    OBlock b = InstanceManager.getDefault(OBlockManager.class).getOBlock(this._name);
                    if (b == null) {
                        log.error("invalid block name= \"{}\" in state variable", (Object)this._name);
                        return;
                    }
                    this._namedBean = this.nbhm.getNamedBeanHandle(this._name, b);
                    break;
                }
                default: {
                    log.warn("Unexpected type in ConditionalVariable ctor: {} -> {}", (Object)this._type, (Object)itemType);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("could not provide \"{}\" in constructor", (Object)this._name);
            this._namedBean = null;
        }
    }

    public boolean isNegated() {
        return this._not;
    }

    public void setNegation(boolean not) {
        this._not = not;
    }

    public Conditional.Operator getOpern() {
        return this._opern;
    }

    public final void setOpern(Conditional.Operator opern) {
        this._opern = opern;
    }

    public Conditional.Type getType() {
        return this._type;
    }

    public void setType(Conditional.Type type) {
        this._type = type;
    }

    public String getName() {
        if (this._namedBean != null) {
            return this._namedBean.getName();
        }
        this.setName(this._name);
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        NamedBean bean = null;
        Conditional.ItemType itemType = this._type.getItemType();
        try {
            switch (itemType) {
                case NONE: {
                    break;
                }
                case CLOCK: {
                    break;
                }
                case SENSOR: {
                    bean = InstanceManager.sensorManagerInstance().provideSensor(this._name);
                    break;
                }
                case TURNOUT: {
                    bean = InstanceManager.turnoutManagerInstance().provideTurnout(this._name);
                    break;
                }
                case LIGHT: {
                    bean = InstanceManager.lightManagerInstance().getLight(this._name);
                    break;
                }
                case MEMORY: {
                    bean = InstanceManager.memoryManagerInstance().provideMemory(this._name);
                    break;
                }
                case SIGNALMAST: {
                    bean = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(this._name);
                    break;
                }
                case SIGNALHEAD: {
                    bean = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(this._name);
                    break;
                }
                case CONDITIONAL: {
                    bean = InstanceManager.getDefault(ConditionalManager.class).getConditional(this._name);
                    break;
                }
                case WARRANT: {
                    bean = InstanceManager.getDefault(WarrantManager.class).getWarrant(this._name);
                    break;
                }
                case OBLOCK: {
                    bean = InstanceManager.getDefault(OBlockManager.class).getOBlock(this._name);
                    break;
                }
                case ENTRYEXIT: {
                    bean = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(this._name);
                    break;
                }
                default: {
                    log.error("Type {} not set for {}", (Object)itemType, (Object)this._name);
                }
            }
            if (bean != null) {
                this._namedBean = this.nbhm.getNamedBeanHandle(this._name, bean);
            } else {
                log.debug("Did not have or create \"{}\" in setName. namedBean is unchanged", (Object)this._name);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Did not have or create \"{}\" in setName", (Object)this._name);
            this._namedBean = null;
        }
    }

    public NamedBeanHandle<?> getNamedBean() {
        return this._namedBean;
    }

    public NamedBean getBean() {
        if (this._namedBean != null) {
            return this._namedBean.getBean();
        }
        this.setName(this._name);
        if (this._namedBean != null) {
            return this._namedBean.getBean();
        }
        return null;
    }

    public String getDataString() {
        if (this._type.getItemType() == Conditional.ItemType.MEMORY && this._namedBeanData != null) {
            return this._namedBeanData.getName();
        }
        return this._dataString;
    }

    public void setDataString(String data) {
        Memory bean;
        this._dataString = data;
        if (data != null && !data.equals("") && this._type.getItemType() == Conditional.ItemType.MEMORY && (bean = InstanceManager.memoryManagerInstance().getMemory(data)) != null) {
            this._namedBeanData = this.nbhm.getNamedBeanHandle(data, bean);
        }
    }

    public NamedBean getNamedBeanData() {
        if (this._namedBeanData != null) {
            return this._namedBeanData.getBean();
        }
        return null;
    }

    public int getNum1() {
        return this._num1;
    }

    public void setNum1(int num) {
        this._num1 = num;
    }

    public int getNum2() {
        return this._num2;
    }

    public void setNum2(int num) {
        this._num2 = num;
    }

    public String getGuiName() {
        return this._guiName;
    }

    public void setGuiName(String guiName) {
        this._guiName = guiName;
    }

    public boolean doTriggerActions() {
        return this._triggersActions;
    }

    public void setTriggerActions(boolean trigger) {
        this._triggersActions = trigger;
    }

    public int getState() {
        return this._state;
    }

    public void setState(int state) {
        this._state = state;
    }

    public void setState(boolean state) {
        this._state = state ? 4 : 2;
    }

    public String getTestTypeString() {
        return this._type.getTestTypeString();
    }

    public String getOpernString() {
        switch (this._opern) {
            case AND: {
                return Bundle.getMessage("LogicAND");
            }
            case NONE: {
                return "";
            }
            case OR: {
                return Bundle.getMessage("LogicOR");
            }
        }
        return "";
    }

    public boolean evaluate() {
        boolean result = true;
        Conditional.ItemType itemType = this._type.getItemType();
        log.debug("evaluate: \"{}\" type= {} itemType= {}", new Object[]{this.getName(), this._type, itemType});
        block1 : switch (itemType) {
            case SENSOR: {
                Sensor sn = (Sensor)this.getBean();
                if (sn == null) {
                    log.error("invalid sensor name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                if (this._type == Conditional.Type.SENSOR_ACTIVE) {
                    result = sn.getState() == 2;
                    break;
                }
                result = sn.getState() == 4;
                break;
            }
            case TURNOUT: {
                Turnout t = (Turnout)this.getBean();
                if (t == null) {
                    log.error("invalid turnout name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                if (this._type == Conditional.Type.TURNOUT_THROWN) {
                    result = t.getKnownState() == 4;
                    break;
                }
                result = t.getKnownState() == 2;
                break;
            }
            case LIGHT: {
                Light lgt = (Light)this.getBean();
                if (lgt == null) {
                    log.error("invalid light name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                if (this._type == Conditional.Type.LIGHT_ON) {
                    result = lgt.getState() == 2;
                    break;
                }
                result = lgt.getState() == 4;
                break;
            }
            case SIGNALMAST: {
                SignalMast f = (SignalMast)this.getBean();
                if (f == null) {
                    log.error("invalid signal mast name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                switch (this._type) {
                    case SIGNAL_MAST_LIT: {
                        result = f.getLit();
                        break block1;
                    }
                    case SIGNAL_MAST_HELD: {
                        result = f.getHeld();
                        break block1;
                    }
                    case SIGNAL_MAST_ASPECT_EQUALS: {
                        if (f.getAspect() == null) {
                            result = false;
                            break block1;
                        }
                        result = f.getAspect().equals(this._dataString);
                        break block1;
                    }
                }
                log.warn("unexpected type {} in ITEM_TYPE_SIGNALMAST", (Object)this._type);
                break;
            }
            case SIGNALHEAD: {
                SignalHead h = (SignalHead)this.getBean();
                if (h == null) {
                    log.error("invalid signal head name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                switch (this._type) {
                    case SIGNAL_HEAD_RED: {
                        result = h.getAppearance() == 1;
                        break block1;
                    }
                    case SIGNAL_HEAD_YELLOW: {
                        result = h.getAppearance() == 4;
                        break block1;
                    }
                    case SIGNAL_HEAD_GREEN: {
                        result = h.getAppearance() == 16;
                        break block1;
                    }
                    case SIGNAL_HEAD_DARK: {
                        result = h.getAppearance() == 0;
                        break block1;
                    }
                    case SIGNAL_HEAD_FLASHRED: {
                        result = h.getAppearance() == 2;
                        break block1;
                    }
                    case SIGNAL_HEAD_FLASHYELLOW: {
                        result = h.getAppearance() == 8;
                        break block1;
                    }
                    case SIGNAL_HEAD_FLASHGREEN: {
                        result = h.getAppearance() == 32;
                        break block1;
                    }
                    case SIGNAL_HEAD_LUNAR: {
                        result = h.getAppearance() == 64;
                        break block1;
                    }
                    case SIGNAL_HEAD_FLASHLUNAR: {
                        result = h.getAppearance() == 128;
                        break block1;
                    }
                    case SIGNAL_HEAD_LIT: {
                        result = h.getLit();
                        break block1;
                    }
                    case SIGNAL_HEAD_HELD: {
                        result = h.getHeld();
                        break block1;
                    }
                }
                result = false;
                break;
            }
            case MEMORY: {
                boolean caseInsensitive;
                Memory m = (Memory)this.getBean();
                if (m == null) {
                    log.error("invalid memory name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                String value1 = null;
                String value2 = null;
                if (m.getValue() != null) {
                    value1 = m.getValue().toString();
                }
                boolean bl = caseInsensitive = this._type == Conditional.Type.MEMORY_EQUALS_INSENSITIVE || this._type == Conditional.Type.MEMORY_COMPARE_INSENSITIVE;
                if (this._type == Conditional.Type.MEMORY_COMPARE || this._type == Conditional.Type.MEMORY_COMPARE_INSENSITIVE) {
                    Memory m2;
                    if (this._namedBeanData != null) {
                        m2 = (Memory)this._namedBeanData.getBean();
                    } else {
                        try {
                            m2 = InstanceManager.memoryManagerInstance().provideMemory(this._dataString);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            log.error("invalid data memory name= \"{}\" in state variable", (Object)this._dataString);
                            return false;
                        }
                    }
                    if (m2.getValue() != null) {
                        value2 = m2.getValue().toString();
                    }
                } else {
                    value2 = this._dataString;
                }
                result = this.compare(value1, value2, caseInsensitive);
                break;
            }
            case CONDITIONAL: {
                Conditional c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(this.getName());
                if (c == null && (c = InstanceManager.getDefault(ConditionalManager.class).getByUserName(this.getName())) == null) {
                    log.error("invalid conditional name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                if (this._type == Conditional.Type.CONDITIONAL_TRUE) {
                    result = c.getState() == 4;
                    break;
                }
                result = c.getState() == 2;
                break;
            }
            case WARRANT: {
                Warrant w = InstanceManager.getDefault(WarrantManager.class).getWarrant(this.getName());
                if (w == null) {
                    log.error("invalid Warrant name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                switch (this._type) {
                    case ROUTE_FREE: {
                        result = w.routeIsFree();
                        break block1;
                    }
                    case ROUTE_OCCUPIED: {
                        result = w.routeIsOccupied();
                        break block1;
                    }
                    case ROUTE_ALLOCATED: {
                        result = w.isAllocated();
                        break block1;
                    }
                    case ROUTE_SET: {
                        result = w.hasRouteSet();
                        break block1;
                    }
                    case TRAIN_RUNNING: {
                        result = w.getRunMode() != 0;
                        break block1;
                    }
                }
                result = false;
                break;
            }
            case CLOCK: {
                Timebase fastClock = InstanceManager.getDefault(Timebase.class);
                Date currentTime = fastClock.getTime();
                int currentMinutes = currentTime.getHours() * 60 + currentTime.getMinutes();
                int beginTime = ConditionalVariable.fixMidnight(this._num1);
                int endTime = ConditionalVariable.fixMidnight(this._num2);
                if (beginTime <= endTime) {
                    result = beginTime <= currentMinutes && currentMinutes <= endTime;
                    break;
                }
                result = beginTime <= currentMinutes || currentMinutes <= endTime;
                break;
            }
            case OBLOCK: {
                OBlock b = InstanceManager.getDefault(OBlockManager.class).getOBlock(this.getName());
                if (b == null) {
                    log.error("invalid OBlock name= \"{}\" in state variable", (Object)this.getName());
                    return false;
                }
                result = b.statusIs(this._dataString);
                break;
            }
            case ENTRYEXIT: {
                NamedBean e = this.getBean();
                if (this._type == Conditional.Type.ENTRYEXIT_ACTIVE) {
                    result = e.getState() == 2;
                    break;
                }
                result = e.getState() == 4;
                break;
            }
        }
        if (this._not) {
            boolean bl = result = !result;
        }
        if (result) {
            this.setState(4);
        } else {
            this.setState(2);
        }
        return result;
    }

    boolean compare(String value1, String value2, boolean caseInsensitive) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        value1 = value1.trim();
        value2 = value2.trim();
        int n1 = Integer.parseInt(value1);
        try {
            int n2 = Integer.parseInt(value2);
            if (this._num1 == 0) {
                return n1 == n2;
            }
            log.debug("Compare numbers: n1= {} to n2= {}", (Object)n1, (Object)n2);
            switch (this._num1) {
                case 1: {
                    return n1 < n2;
                }
                case 2: {
                    return n1 <= n2;
                }
                case 3: {
                    return n1 == n2;
                }
                case 4: {
                    return n1 >= n2;
                }
                case 5: {
                    return n1 > n2;
                }
            }
            log.error("Compare numbers: invalid compare case: {}", (Object)this._num1);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return false;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Integer.parseInt(value2);
                    return false;
                }
                catch (NumberFormatException numberFormatException3) {
                    log.debug("Compare Strings: value1= {} to value2= {}", (Object)value1, (Object)value2);
                    int compare = caseInsensitive ? value1.compareToIgnoreCase(value2) : value1.compareTo(value2);
                    if (this._num1 == 0) {
                        return compare == 0;
                    }
                    switch (this._num1) {
                        case 1: {
                            if (compare >= 0) break;
                            return true;
                        }
                        case 2: {
                            if (compare > 0) break;
                            return true;
                        }
                        case 3: {
                            if (compare != 0) break;
                            return true;
                        }
                        case 4: {
                            if (compare < 0) break;
                            return true;
                        }
                        case 5: {
                            if (compare <= 0) break;
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
    }

    public static int fixMidnight(int time) {
        if (time > 1440) {
            time -= 1440;
        }
        return time;
    }

    public static String getItemTypeString(Conditional.ItemType t) {
        switch (t) {
            case SENSOR: {
                return Bundle.getMessage("BeanNameSensor");
            }
            case TURNOUT: {
                return Bundle.getMessage("BeanNameTurnout");
            }
            case LIGHT: {
                return Bundle.getMessage("BeanNameLight");
            }
            case SIGNALHEAD: {
                return Bundle.getMessage("BeanNameSignalHead");
            }
            case SIGNALMAST: {
                return Bundle.getMessage("BeanNameSignalMast");
            }
            case MEMORY: {
                return Bundle.getMessage("BeanNameMemory");
            }
            case CONDITIONAL: {
                return Bundle.getMessage("BeanNameConditional");
            }
            case WARRANT: {
                return Bundle.getMessage("BeanNameWarrant");
            }
            case CLOCK: {
                return Bundle.getMessage("FastClock");
            }
            case OBLOCK: {
                return Bundle.getMessage("BeanNameOBlock");
            }
            case ENTRYEXIT: {
                return Bundle.getMessage("BeanNameEntryExit");
            }
        }
        return "";
    }

    public static String getCompareOperationString(int index) {
        switch (index) {
            case 1: {
                return rbx.getString("LessThan");
            }
            case 2: {
                return rbx.getString("LessOrEqual");
            }
            case 0: 
            case 3: {
                return rbx.getString("Equal");
            }
            case 4: {
                return rbx.getString("GreaterOrEqual");
            }
            case 5: {
                return rbx.getString("GreaterThan");
            }
        }
        return "";
    }

    public static String getCompareSymbols(int index) {
        switch (index) {
            case 1: {
                return "<";
            }
            case 2: {
                return "<=";
            }
            case 0: 
            case 3: {
                return "=";
            }
            case 4: {
                return ">=";
            }
            case 5: {
                return ">";
            }
        }
        return "";
    }

    public static Conditional.Type stringToVariableTest(String str) {
        if (str.equals(Bundle.getMessage("SignalHeadStateRed"))) {
            return Conditional.Type.SIGNAL_HEAD_RED;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateYellow"))) {
            return Conditional.Type.SIGNAL_HEAD_YELLOW;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateGreen"))) {
            return Conditional.Type.SIGNAL_HEAD_GREEN;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateDark"))) {
            return Conditional.Type.SIGNAL_HEAD_DARK;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingRed"))) {
            return Conditional.Type.SIGNAL_HEAD_FLASHRED;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingYellow"))) {
            return Conditional.Type.SIGNAL_HEAD_FLASHYELLOW;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingGreen"))) {
            return Conditional.Type.SIGNAL_HEAD_FLASHGREEN;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateLunar"))) {
            return Conditional.Type.SIGNAL_HEAD_LUNAR;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingLunar"))) {
            return Conditional.Type.SIGNAL_HEAD_FLASHLUNAR;
        }
        if (str.length() > 0) {
            log.warn("Unexpected parameter to stringToVariableTest({})", (Object)str);
        }
        return Conditional.Type.ERROR;
    }

    public String toString() {
        String type = this._type.getTestTypeString();
        Conditional.ItemType itemType = this._type.getItemType();
        switch (itemType) {
            case SENSOR: {
                return MessageFormat.format(rbx.getString("VarStateDescrpt"), Bundle.getMessage("BeanNameSensor"), this.getName(), type);
            }
            case TURNOUT: {
                return MessageFormat.format(rbx.getString("VarStateDescrpt"), Bundle.getMessage("BeanNameTurnout"), this.getName(), type);
            }
            case LIGHT: {
                return MessageFormat.format(rbx.getString("VarStateDescrpt"), Bundle.getMessage("BeanNameLight"), this.getName(), type);
            }
            case SIGNALHEAD: {
                if (this._type == Conditional.Type.SIGNAL_HEAD_LIT || this._type == Conditional.Type.SIGNAL_HEAD_HELD) {
                    return MessageFormat.format(rbx.getString("VarStateDescrpt"), Bundle.getMessage("BeanNameSignalHead"), this.getName(), type);
                }
                return MessageFormat.format(rbx.getString("SignalHeadStateDescrpt"), Bundle.getMessage("BeanNameSignalHead"), this.getName(), type);
            }
            case SIGNALMAST: {
                if (this._type == Conditional.Type.SIGNAL_MAST_LIT || this._type == Conditional.Type.SIGNAL_MAST_HELD) {
                    return MessageFormat.format(rbx.getString("VarStateDescrpt"), Bundle.getMessage("BeanNameSignalMast"), this.getName(), type);
                }
                return MessageFormat.format(rbx.getString("SignalMastStateDescrpt"), Bundle.getMessage("BeanNameSignalMast"), this.getName(), this._dataString);
            }
            case MEMORY: {
                if (this._type == Conditional.Type.MEMORY_EQUALS || this._type == Conditional.Type.MEMORY_EQUALS_INSENSITIVE) {
                    return MessageFormat.format(rbx.getString("MemoryValueDescrpt"), Bundle.getMessage("BeanNameMemory"), this.getName(), ConditionalVariable.getCompareSymbols(this._num1), this._dataString);
                }
                return MessageFormat.format(rbx.getString("MemoryCompareDescrpt"), Bundle.getMessage("BeanNameMemory"), this.getName(), ConditionalVariable.getCompareSymbols(this._num1), this._dataString);
            }
            case CONDITIONAL: {
                return MessageFormat.format(rbx.getString("VarStateDescrpt"), Bundle.getMessage("BeanNameConditional"), this.getGuiName(), type);
            }
            case WARRANT: {
                return MessageFormat.format(rbx.getString("VarStateDescrpt"), rbx.getString("WarrantRoute"), this.getName(), type);
            }
            case CLOCK: {
                return MessageFormat.format(rbx.getString("FastClockDescrpt"), Bundle.getMessage("FastClock"), LogixTableAction.formatTime(this._num1 / 60, this._num1 - this._num1 / 60 * 60), LogixTableAction.formatTime(this._num2 / 60, this._num2 - this._num2 / 60 * 60));
            }
            case OBLOCK: {
                return MessageFormat.format(rbx.getString("VarStateDescrpt"), rbx.getString("OBlockStatus"), this.getName(), this._dataString);
            }
            case ENTRYEXIT: {
                return MessageFormat.format(rbx.getString("VarStateDescrpt"), Bundle.getMessage("BeanNameEntryExit"), this.getBean().getUserName(), type);
            }
            case NONE: {
                return String.valueOf(this.getName()) + " type " + type;
            }
        }
        return super.toString();
    }
}

