/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.BlockManager;
import jmri.Bundle;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.PhysicalLocationReporter;
import jmri.Reporter;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.SignalSpeedMap;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Block
extends AbstractNamedBean
implements PhysicalLocationReporter {
    public static final int OCCUPIED = 2;
    public static final int UNOCCUPIED = 4;
    public static final int UNDETECTED = 256;
    public static final int NONE = 0;
    public static final int GRADUAL = 1;
    public static final int TIGHT = 2;
    public static final int SEVERE = 4;
    public static final String OCC_SENSOR_CHANGE = "OccupancySensorChange";
    public static final String BLOCK_REPORTER_CHANGE = "BlockReporterChange";
    public static final String BLOCK_REPORTING_CURRENT = "BlockReportingCurrent";
    private final ArrayList<Path> paths = new ArrayList();
    private final ArrayList<NamedBeanHandle<Block>> blockDenyList = new ArrayList(1);
    public static final String BLOCK_PERMISSIVE_CHANGE = "BlockPermissiveWorking";
    private boolean _permissiveWorking = false;
    private String _blockSpeed = "";
    public static final String BLOCK_SPEED_CHANGE = "BlockSpeedChange";
    public static final String BLOCK_CURVATURE_CHANGE = "BlockCurvatureChange";
    public static final String BLOCK_LENGTH_CHANGE = "BlockLengthChange";
    private int _current = 256;
    private NamedBeanHandle<Sensor> _namedSensor = null;
    private PropertyChangeListener _sensorListener = null;
    private Object _value;
    private Object _previousValue;
    private int _direction;
    private int _curvature = 0;
    private float _length = 0.0f;
    private Reporter _reporter = null;
    private PropertyChangeListener _reporterListener = null;
    private boolean _reportingCurrent = false;
    private Path[] pListOfPossibleEntrancePaths = null;
    private int cntOfPossibleEntrancePaths = 0;
    private Instant _timeLastInactive;
    private final int maxInfoMessages = 5;
    private int infoMessageCount = 0;
    private static final Logger log = LoggerFactory.getLogger(Block.class);

    public Block(String systemName) {
        super(systemName);
    }

    public Block(String systemName, String userName) {
        super(systemName, userName);
    }

    public String toDebugString() {
        String result = String.valueOf(this.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)) + " ";
        switch (this.getState()) {
            case 256: {
                result = String.valueOf(result) + "UNDETECTED";
                break;
            }
            case 4: {
                result = String.valueOf(result) + "UNOCCUPIED";
                break;
            }
            case 2: {
                result = String.valueOf(result) + "OCCUPIED";
                break;
            }
            default: {
                result = String.valueOf(result) + "unknown " + this.getState();
            }
        }
        return result;
    }

    public boolean setSensor(String pName) {
        Sensor oldSensor = this.getSensor();
        if (pName == null || pName.isEmpty()) {
            if (oldSensor != null) {
                this.setNamedSensor(null);
                this.firePropertyChange(OCC_SENSOR_CHANGE, oldSensor, null);
            }
            return false;
        }
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            Sensor sensor;
            block7: {
                sensor = InstanceManager.sensorManagerInstance().provideSensor(pName);
                if (!sensor.equals(oldSensor)) break block7;
                return false;
            }
            try {
                this.setNamedSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, sensor));
                this.firePropertyChange(OCC_SENSOR_CHANGE, oldSensor, sensor);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setNamedSensor(null);
                this.firePropertyChange(OCC_SENSOR_CHANGE, oldSensor, null);
                log.error("Sensor '{}' not available", (Object)pName);
            }
        } else {
            log.error("No SensorManager for this protocol");
        }
        return false;
    }

    public void setNamedSensor(NamedBeanHandle<Sensor> s) {
        if (this._namedSensor != null && this._sensorListener != null) {
            this._namedSensor.getBean().removePropertyChangeListener(this._sensorListener);
            this._sensorListener = null;
        }
        this._namedSensor = s;
        if (this._namedSensor != null) {
            this._sensorListener = e -> this.handleSensorChange(e);
            this._namedSensor.getBean().addPropertyChangeListener(this._sensorListener, s.getName(), "Block Sensor " + this.getDisplayName());
            this.setState(this._namedSensor.getBean().getState());
        } else {
            this.setState(256);
        }
    }

    public Sensor getSensor() {
        if (this._namedSensor != null) {
            return this._namedSensor.getBean();
        }
        return null;
    }

    public NamedBeanHandle<Sensor> getNamedSensor() {
        return this._namedSensor;
    }

    public void setReporter(Reporter reporter) {
        if (Objects.equals(reporter, this._reporter)) {
            return;
        }
        if (this._reporter != null && this._reporterListener != null) {
            this._reporter.removePropertyChangeListener(this._reporterListener);
            this._reporterListener = null;
        }
        Reporter oldReporter = this._reporter;
        this._reporter = reporter;
        if (this._reporter != null) {
            this._reporterListener = e -> this.handleReporterChange(e);
            this._reporter.addPropertyChangeListener(this._reporterListener);
        }
        this.firePropertyChange(BLOCK_REPORTER_CHANGE, oldReporter, reporter);
    }

    public Reporter getReporter() {
        return this._reporter;
    }

    public void setReportingCurrent(boolean reportingCurrent) {
        if (this._reportingCurrent != reportingCurrent) {
            this._reportingCurrent = reportingCurrent;
            this.firePropertyChange(BLOCK_REPORTING_CURRENT, !reportingCurrent, reportingCurrent);
        }
    }

    public boolean isReportingCurrent() {
        return this._reportingCurrent;
    }

    @Override
    public int getState() {
        return this._current;
    }

    public void addPath(@Nonnull Path p) {
        if (p == null) {
            throw new IllegalArgumentException("Can't add null path");
        }
        this.paths.add(p);
    }

    public void removePath(Path p) {
        int j = -1;
        int i = 0;
        while (i < this.paths.size()) {
            if (p == this.paths.get(i)) {
                j = i;
            }
            ++i;
        }
        if (j > -1) {
            this.paths.remove(j);
        }
    }

    public boolean hasPath(Path p) {
        return this.paths.stream().anyMatch(t -> t.equals(p));
    }

    @Nonnull
    public List<Path> getPaths() {
        return new ArrayList<Path>(this.paths);
    }

    @Override
    public void setState(int v) {
        int old = this._current;
        this._current = v;
        try {
            this.firePropertyChange("state", old, this._current);
        }
        catch (Exception e) {
            log.error("{} got exception during firePropertyChange({},{}) in thread {} {}: {}", new Object[]{this.getDisplayName(), old, this._current, Thread.currentThread().getName(), Thread.currentThread().getId(), e});
        }
    }

    public void setValue(Object value) {
        if (value != this._value) {
            log.debug("Block {} value changed from '{}' to '{}'", new Object[]{this.getDisplayName(), this._value, value});
            this._previousValue = this._value;
            this._value = value;
            this.firePropertyChange("value", this._previousValue, this._value);
        }
    }

    public Object getValue() {
        return this._value;
    }

    public void setDirection(int direction) {
        if (direction != this._direction) {
            log.debug("Block {} direction changed from {} to {}", new Object[]{this.getDisplayName(), Path.decodeDirection(this._direction), Path.decodeDirection(direction)});
            int oldDirection = this._direction;
            this._direction = direction;
            this.firePropertyChange("direction", oldDirection, direction);
        }
    }

    public int getDirection() {
        return this._direction;
    }

    public void addBlockDenyList(@Nonnull String pName) {
        Block blk = InstanceManager.getDefault(BlockManager.class).getBlock(pName);
        if (blk == null) {
            throw new IllegalArgumentException("addBlockDenyList requests block \"" + pName + "\" exists");
        }
        NamedBeanHandle<Block> namedBlock = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, blk);
        if (!this.blockDenyList.contains(namedBlock)) {
            this.blockDenyList.add(namedBlock);
        }
    }

    public void addBlockDenyList(Block blk) {
        NamedBeanHandle<Block> namedBlock = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(blk.getDisplayName(), blk);
        if (!this.blockDenyList.contains(namedBlock)) {
            this.blockDenyList.add(namedBlock);
        }
    }

    public void removeBlockDenyList(String blk) {
        NamedBeanHandle<Block> toremove = null;
        for (NamedBeanHandle<Block> bean : this.blockDenyList) {
            if (!bean.getName().equals(blk)) continue;
            toremove = bean;
        }
        if (toremove != null) {
            this.blockDenyList.remove(toremove);
        }
    }

    public void removeBlockDenyList(Block blk) {
        NamedBeanHandle<Block> toremove = null;
        for (NamedBeanHandle<Block> bean : this.blockDenyList) {
            if (bean.getBean() != blk) continue;
            toremove = bean;
        }
        if (toremove != null) {
            this.blockDenyList.remove(toremove);
        }
    }

    public List<String> getDeniedBlocks() {
        ArrayList<String> list = new ArrayList<String>(this.blockDenyList.size());
        this.blockDenyList.forEach((Consumer<NamedBeanHandle<Block>>)((Consumer<NamedBeanHandle>)bean -> list.add(bean.getName())));
        return list;
    }

    public boolean isBlockDenied(String deny) {
        return this.blockDenyList.stream().anyMatch(bean -> bean.getName().equals(deny));
    }

    public boolean isBlockDenied(Block deny) {
        return this.blockDenyList.stream().anyMatch(bean -> bean.getBean() == deny);
    }

    public boolean getPermissiveWorking() {
        return this._permissiveWorking;
    }

    public void setPermissiveWorking(boolean w) {
        if (this._permissiveWorking != w) {
            this._permissiveWorking = w;
            this.firePropertyChange(BLOCK_PERMISSIVE_CHANGE, !w, w);
        }
    }

    public float getSpeedLimit() {
        if (this._blockSpeed == null || this._blockSpeed.isEmpty()) {
            return -1.0f;
        }
        String speed = this._blockSpeed;
        if (this._blockSpeed.equals("Global")) {
            speed = InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        }
        try {
            return Float.parseFloat(speed);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(speed);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1.0f;
            }
        }
    }

    public String getBlockSpeed() {
        if (this._blockSpeed.equals("Global")) {
            return String.valueOf(Bundle.getMessage("UseGlobal", "Global")) + " " + InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        }
        return this._blockSpeed;
    }

    public void setBlockSpeedName(String s) {
        this._blockSpeed = s == null ? "" : s;
    }

    public void setBlockSpeed(String s) throws JmriException {
        if (s == null || this._blockSpeed.equals(s)) {
            return;
        }
        if (s.contains("Global")) {
            s = "Global";
        } else {
            try {
                Float.parseFloat(s);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(s);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JmriException("Value of requested block speed is not valid");
                }
            }
        }
        String oldSpeed = this._blockSpeed;
        this._blockSpeed = s;
        this.firePropertyChange(BLOCK_SPEED_CHANGE, oldSpeed, s);
    }

    public void setCurvature(int c) {
        if (this._curvature != c) {
            int oldCurve = this._curvature;
            this._curvature = c;
            this.firePropertyChange(BLOCK_CURVATURE_CHANGE, oldCurve, c);
        }
    }

    public int getCurvature() {
        return this._curvature;
    }

    public void setLength(float l) {
        float oldLen = this.getLengthMm();
        if ((double)Math.abs(oldLen - l) > 1.0E-4) {
            this._length = l;
            this.getPaths().stream().forEach(p -> {
                if (p.getLength() > l) {
                    p.setLength(0.0f);
                }
            });
            this.firePropertyChange(BLOCK_LENGTH_CHANGE, Float.valueOf(oldLen), Float.valueOf(l));
        }
    }

    public float getLengthMm() {
        return this._length;
    }

    public float getLengthCm() {
        return this._length / 10.0f;
    }

    public float getLengthIn() {
        return this._length / 25.4f;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Block b = (Block)obj;
        return b.getSystemName().equals(this.getSystemName());
    }

    @Override
    public int hashCode() {
        return this.getSystemName().hashCode();
    }

    void resetCandidateEntrancePaths() {
        this.pListOfPossibleEntrancePaths = null;
        this.cntOfPossibleEntrancePaths = 0;
    }

    boolean setAsEntryBlockIfPossible(Block b) {
        int i = 0;
        while (i < this.cntOfPossibleEntrancePaths) {
            Block CandidateBlock = this.pListOfPossibleEntrancePaths[i].getBlock();
            if (CandidateBlock == b) {
                this.setValue(CandidateBlock.getValue());
                this.setDirection(this.pListOfPossibleEntrancePaths[i].getFromBlockDirection());
                log.info("Block {} gets LATE new value from {}, direction= {}", new Object[]{this.getDisplayName(), CandidateBlock.getDisplayName(), Path.decodeDirection(this.getDirection())});
                this.resetCandidateEntrancePaths();
                return true;
            }
            ++i;
        }
        return false;
    }

    void handleSensorChange(PropertyChangeEvent e) {
        Sensor s = this.getSensor();
        if (e.getPropertyName().equals("KnownState") && s != null) {
            int state = s.getState();
            switch (state) {
                case 2: {
                    this.goingActive();
                    break;
                }
                case 4: {
                    this.goingInactive();
                    break;
                }
                case 1: {
                    this.goingUnknown();
                    break;
                }
                default: {
                    this.goingInconsistent();
                }
            }
        }
    }

    public void goingUnknown() {
        this.setValue(null);
        this.setState(1);
    }

    public void goingInconsistent() {
        this.setValue(null);
        this.setState(8);
    }

    void handleReporterChange(PropertyChangeEvent e) {
        if (this._reportingCurrent && e.getPropertyName().equals("currentReport") || !this._reportingCurrent && e.getPropertyName().equals("lastReport")) {
            this.setValue(e.getNewValue());
        }
    }

    public void goingInactive() {
        log.debug("Block {} goes UNOCCUPIED", (Object)this.getDisplayName());
        for (Path path : this.paths) {
            Block b = path.getBlock();
            if (b == null) continue;
            b.setAsEntryBlockIfPossible(this);
        }
        this.setValue(null);
        this.setDirection(0);
        this.setState(4);
        this._timeLastInactive = Instant.now();
    }

    public void goingActive() {
        if (this.getState() == 2) {
            return;
        }
        log.debug("Block {} goes OCCUPIED", (Object)this.getDisplayName());
        this.resetCandidateEntrancePaths();
        int count = 0;
        Path next = null;
        int currPathCnt = this.paths.size();
        Path[] pList = new Path[currPathCnt];
        boolean[] isSet = new boolean[currPathCnt];
        boolean[] isActive = new boolean[currPathCnt];
        int[] pDir = new int[currPathCnt];
        int[] pFromDir = new int[currPathCnt];
        int i = 0;
        while (i < currPathCnt) {
            pList[i] = this.paths.get(i);
            isSet[i] = pList[i].checkPathSet();
            Block b = pList[i].getBlock();
            if (b != null) {
                isActive[i] = b.getState() == 2;
                pDir[i] = b.getDirection();
            } else {
                isActive[i] = false;
                pDir[i] = -1;
            }
            pFromDir[i] = pList[i].getFromBlockDirection();
            if (isSet[i] && isActive[i]) {
                ++count;
                next = pList[i];
            }
            ++i;
        }
        switch (count) {
            case 0: {
                if (this._previousValue != null) {
                    Instant tn = Instant.now();
                    BlockManager bm = InstanceManager.getDefault(BlockManager.class);
                    if (bm.timeSinceLastLayoutPowerOn() < 5000L || this._timeLastInactive != null && tn.toEpochMilli() - this._timeLastInactive.toEpochMilli() < 2000L) {
                        this.setValue(this._previousValue);
                        if (this.infoMessageCount >= 5) break;
                        log.debug("Sensor ACTIVE came out of nowhere, no neighbors active for block {}. Restoring previous value.", (Object)this.getDisplayName());
                        ++this.infoMessageCount;
                        break;
                    }
                    if (!log.isDebugEnabled()) break;
                    if (this._timeLastInactive != null) {
                        log.debug("not restoring previous value, block {} has been inactive for too long ({}ms) and layout power has not just been restored ({}ms ago)", new Object[]{this.getDisplayName(), tn.toEpochMilli() - this._timeLastInactive.toEpochMilli(), bm.timeSinceLastLayoutPowerOn()});
                        break;
                    }
                    log.debug("not restoring previous value, block {} has been inactive since the start of this session and layout power has not just been restored ({}ms ago)", (Object)this.getDisplayName(), (Object)bm.timeSinceLastLayoutPowerOn());
                    break;
                }
                if (this.infoMessageCount >= 5) break;
                log.debug("Sensor ACTIVE came out of nowhere, no neighbors active for block {}. Value not set.", (Object)this.getDisplayName());
                ++this.infoMessageCount;
                break;
            }
            case 1: {
                if (next != null && next.getBlock() != null) {
                    this.setValue(next.getBlock().getValue());
                    this.setDirection(next.getFromBlockDirection());
                    log.debug("Block {} gets new value '{}' from {}, direction={}", new Object[]{this.getDisplayName(), next.getBlock().getValue(), next.getBlock().getDisplayName(), Path.decodeDirection(this.getDirection())});
                    break;
                }
                if (next == null) {
                    log.error("unexpected next==null processing block {}", (Object)this.getDisplayName());
                    break;
                }
                log.error("unexpected next.getBlock()=null processing block {}", (Object)this.getDisplayName());
                break;
            }
            default: {
                log.debug("Block {} has {} active linked blocks, comparing directions", (Object)this.getDisplayName(), (Object)count);
                next = null;
                count = 0;
                i = 0;
                while (i < currPathCnt) {
                    if (isSet[i] && isActive[i]) {
                        log.debug("comparing {} ({}) to {} ({})", new Object[]{pList[i].getBlock().getDisplayName(), Path.decodeDirection(pDir[i]), this.getDisplayName(), Path.decodeDirection(pFromDir[i])});
                        if ((pDir[i] & pFromDir[i]) > 0) {
                            ++count;
                            next = pList[i];
                        }
                    }
                    ++i;
                }
                if (next == null) {
                    i = 0;
                    while (i < currPathCnt) {
                        if (isSet[i] && isActive[i]) {
                            ++count;
                            next = pList[i];
                        }
                        ++i;
                    }
                }
                if (next != null && count == 1) {
                    this.setValue(next.getBlock().getValue());
                    this.setDirection(next.getFromBlockDirection());
                    log.debug("Block {} gets new value '{}' from {}, direction {}", new Object[]{this.getDisplayName(), next.getBlock().getValue(), next.getBlock().getDisplayName(), Path.decodeDirection(this.getDirection())});
                    break;
                }
                log.warn("count of {} ACTIVE neightbors with proper direction can't be handled for block {} but maybe it can be determined when another block becomes free", (Object)count, (Object)this.getDisplayName());
                this.pListOfPossibleEntrancePaths = new Path[currPathCnt];
                this.cntOfPossibleEntrancePaths = 0;
                i = 0;
                while (i < currPathCnt) {
                    if (isSet[i] && isActive[i]) {
                        this.pListOfPossibleEntrancePaths[this.cntOfPossibleEntrancePaths] = pList[i];
                        ++this.cntOfPossibleEntrancePaths;
                    }
                    ++i;
                }
                break block0;
            }
        }
        this.setState(2);
    }

    public Path findFromPath() {
        int count = 0;
        Path next = null;
        int currPathCnt = this.paths.size();
        Path[] pList = new Path[currPathCnt];
        boolean[] isSet = new boolean[currPathCnt];
        boolean[] isActive = new boolean[currPathCnt];
        int[] pDir = new int[currPathCnt];
        int[] pFromDir = new int[currPathCnt];
        int i = 0;
        while (i < currPathCnt) {
            pList[i] = this.paths.get(i);
            isSet[i] = pList[i].checkPathSet();
            Block b = pList[i].getBlock();
            if (b != null) {
                isActive[i] = b.getState() == 2;
                pDir[i] = b.getDirection();
            } else {
                isActive[i] = false;
                pDir[i] = -1;
            }
            pFromDir[i] = pList[i].getFromBlockDirection();
            if (isSet[i] && isActive[i]) {
                ++count;
                next = pList[i];
            }
            ++i;
        }
        if (count != 0 && count != 1) {
            log.debug("Block {} - count of active linked blocks = {}", (Object)this.getDisplayName(), (Object)count);
            next = null;
            count = 0;
            i = 0;
            while (i < currPathCnt) {
                if (isSet[i] && isActive[i]) {
                    log.debug("comparing {} ({}) to {} ({})", new Object[]{pList[i].getBlock().getDisplayName(), Path.decodeDirection(pDir[i]), this.getDisplayName(), Path.decodeDirection(pFromDir[i])});
                    if ((pDir[i] & pFromDir[i]) > 0) {
                        ++count;
                        next = pList[i];
                    }
                }
                ++i;
            }
            if (next == null) {
                log.debug("next is null!");
            }
            if (next == null || count != 1) {
                log.warn("count of {} ACTIVE neighbors with proper direction can't be handled for block {}", (Object)count, (Object)this.getDisplayName());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Block {} with direction {} gets new value from {} + (informational. No state change)", new Object[]{this.getDisplayName(), Path.decodeDirection(this.getDirection()), next != null ? next.getBlock().getDisplayName() : "(no next block)"});
        }
        return next;
    }

    public void setAllocated(Boolean boo) {
        this.firePropertyChange("allocated", boo == false, boo);
    }

    @Override
    public LocoAddress getLocoAddress(String rep) {
        if (rep == null) {
            log.warn("String input is null!");
            return null;
        }
        if (this.getReporter() != null && this.getReporter() instanceof PhysicalLocationReporter) {
            return ((PhysicalLocationReporter)((Object)this.getReporter())).getLocoAddress(rep);
        }
        log.debug("report string: {}", (Object)rep);
        Pattern ln_p = Pattern.compile("(\\d+) (enter|exits|seen)\\s*(northbound|southbound)?");
        Matcher m = ln_p.matcher(rep);
        if (m.find()) {
            log.debug("Parsed address: {}", (Object)m.group(1));
            return new DccLocoAddress(Integer.parseInt(m.group(1)), LocoAddress.Protocol.DCC);
        }
        return null;
    }

    @Override
    public PhysicalLocationReporter.Direction getDirection(String rep) {
        block12: {
            if (rep == null) {
                log.warn("String input is null!");
                return null;
            }
            if (this.getReporter() != null && this.getReporter() instanceof PhysicalLocationReporter) {
                return ((PhysicalLocationReporter)((Object)this.getReporter())).getDirection(rep);
            }
            log.debug("report string: {}", (Object)rep);
            Pattern ln_p = Pattern.compile("(\\d+) (enter|exits|seen)\\s*(northbound|southbound)?");
            Matcher m = ln_p.matcher(rep);
            if (!m.find()) break block12;
            log.debug("Parsed direction: {}", (Object)m.group(2));
            switch (m.group(2)) {
                case "enter": {
                    return PhysicalLocationReporter.Direction.ENTER;
                }
                case "seen": {
                    return PhysicalLocationReporter.Direction.ENTER;
                }
            }
            return PhysicalLocationReporter.Direction.EXIT;
        }
        return PhysicalLocationReporter.Direction.UNKNOWN;
    }

    @Override
    public PhysicalLocation getPhysicalLocation() {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }

    @Override
    public PhysicalLocation getPhysicalLocation(String s) {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Sensor && evt.getOldValue().equals(this.getSensor())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
            if (evt.getOldValue() instanceof Reporter && evt.getOldValue().equals(this.getReporter())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Sensor && evt.getOldValue().equals(this.getSensor())) {
                this.setSensor(null);
            }
            if (evt.getOldValue() instanceof Reporter && evt.getOldValue().equals(this.getReporter())) {
                this.setReporter(null);
            }
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getSensor())) {
                report.add(new NamedBeanUsageReport("BlockSensor"));
            }
            if (bean.equals(this.getReporter())) {
                report.add(new NamedBeanUsageReport("BlockReporter"));
            }
            this.getPaths().forEach(path -> {
                if (bean.equals(path.getBlock())) {
                    report.add(new NamedBeanUsageReport("BlockPathNeighbor"));
                }
                path.getSettings().forEach(setting -> {
                    if (bean.equals(setting.getBean())) {
                        report.add(new NamedBeanUsageReport("BlockPathTurnout"));
                    }
                });
            });
        }
        return report;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameBlock");
    }
}

