/*
 * Decompiled with CFR 0.152.
 */
package apps.util;

import apps.SystemConsole;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.annotation.Nonnull;
import jmri.Version;
import jmri.util.FileUtil;
import jmri.util.exceptionhandler.UncaughtExceptionHandler;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Log4JUtil {
    private static final String LOG_HEADER = "****** JMRI log *******";
    private static final Logger log = LoggerFactory.getLogger(Log4JUtil.class);

    public static void initLogging() {
        Log4JUtil.initLogging(System.getProperty("jmri.log", "default.lcf"));
    }

    public static void initLogging(@Nonnull String controlfile) {
        Log4JUtil.initLog4J(controlfile);
    }

    static void initLog4J(@Nonnull String logFile) {
        if (LogManager.getRootLogger().getAllAppenders().hasMoreElements()) {
            log.debug("initLog4J already initialized!");
            return;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            SystemConsole.create();
        }
        Log4JUtil.initializeJavaUtilLogging();
        try {
            if (new File(logFile).isAbsolute() && new File(logFile).canRead()) {
                Log4JUtil.configureLogging(logFile);
            } else if (new File(String.valueOf(FileUtil.getPreferencesPath()) + logFile).canRead()) {
                Log4JUtil.configureLogging(String.valueOf(FileUtil.getPreferencesPath()) + logFile);
            } else if (new File(String.valueOf(FileUtil.getProgramPath()) + logFile).canRead()) {
                Log4JUtil.configureLogging(String.valueOf(FileUtil.getProgramPath()) + logFile);
            } else {
                BasicConfigurator.configure();
                org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
            }
        }
        catch (NoSuchMethodError e) {
            log.error("Exception starting logging", (Throwable)e);
        }
        catch (IOException iOException) {
            BasicConfigurator.configure();
            org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
    }

    static void initializeJavaUtilLogging() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    @Nonnull
    public static String startupInfo(@Nonnull String program) {
        log.info(LOG_HEADER);
        Enumeration e = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender a = (Appender)e.nextElement();
            if (a instanceof RollingFileAppender) {
                log.info("This log is appended to file: {}", (Object)((FileAppender)a).getFile());
                continue;
            }
            if (!(a instanceof FileAppender)) continue;
            log.info("This log is stored in file: {}", (Object)((FileAppender)a).getFile());
        }
        return String.valueOf(program) + " version " + Version.name() + " starts under Java " + System.getProperty("java.version", "<unknown>") + " on " + System.getProperty("os.name", "<unknown>") + " " + System.getProperty("os.arch", "<unknown>") + " v" + System.getProperty("os.version", "<unknown>") + " at " + new Date();
    }

    private static void configureLogging(@Nonnull String configFile) throws IOException {
        File logDir;
        Properties p = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream f = new FileInputStream(configFile);){
            p.load(f);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (System.getProperty("jmri.log.path") == null || p.getProperty("jmri.log.path") == null) {
            System.setProperty("jmri.log.path", String.valueOf(FileUtil.getPreferencesPath()) + "log" + File.separator);
            p.put("jmri.log.path", System.getProperty("jmri.log.path"));
        }
        if (!(logDir = new File(p.getProperty("jmri.log.path"))).exists()) {
            Files.createDirectories(logDir.toPath(), new FileAttribute[0]);
        }
        PropertyConfigurator.configure((Properties)p);
    }
}

