/*
 * Decompiled with CFR 0.152.
 */
package apps.systemconsole;

import apps.SystemConsole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import jmri.beans.Bean;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.spi.PreferencesManager;
import jmri.util.prefs.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConsolePreferencesManager
extends Bean
implements PreferencesManager {
    public static final String SCHEME = "scheme";
    public static final String FONT_SIZE = "fontSize";
    public static final String FONT_STYLE = "fontStyle";
    public static final String FONT_FAMILY = "fontFamily";
    public static final String WRAP_STYLE = "wrapStyle";
    private int scheme = 0;
    private int fontSize = 12;
    private int fontStyle = 0;
    private final String fontFamily = "Monospaced";
    private int wrapStyle = 2;
    private boolean initialized = false;
    private final List<InitializationException> exceptions = new ArrayList<InitializationException>();
    private static final Logger log = LoggerFactory.getLogger(SystemConsolePreferencesManager.class);

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.initialized) {
            Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
            this.setFontSize(preferences.getInt(FONT_SIZE, this.getFontSize()));
            this.setFontStyle(preferences.getInt(FONT_STYLE, this.getFontStyle()));
            this.setScheme(preferences.getInt(SCHEME, this.getScheme()));
            this.setWrapStyle(preferences.getInt(WRAP_STYLE, this.getWrapStyle()));
            this.initialized = true;
        }
    }

    @Override
    public void savePreferences(Profile profile) {
        Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
        preferences.putInt(FONT_SIZE, this.getFontSize());
        preferences.putInt(FONT_STYLE, this.getFontStyle());
        preferences.putInt(SCHEME, this.getScheme());
        preferences.putInt(WRAP_STYLE, this.getWrapStyle());
        try {
            preferences.sync();
        }
        catch (BackingStoreException ex) {
            log.error("Unable to save preferences.", (Throwable)ex);
        }
    }

    @Override
    public boolean isInitialized(Profile profile) {
        return this.initialized && this.exceptions.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<Class<? extends PreferencesManager>> getRequires() {
        return new HashSet<Class<? extends PreferencesManager>>();
    }

    @Override
    @Nonnull
    public Iterable<Class<?>> getProvides() {
        HashSet provides = new HashSet();
        provides.add(this.getClass());
        return provides;
    }

    public int getScheme() {
        return this.scheme;
    }

    public void setScheme(int scheme) {
        int oldScheme = this.scheme;
        this.scheme = scheme;
        this.firePropertyChange(SCHEME, oldScheme, scheme);
        SystemConsole.getInstance().setScheme(scheme);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        int oldFontSize = this.fontSize;
        int n = fontSize < 6 ? 6 : (this.fontSize = fontSize > 24 ? 24 : fontSize);
        if (this.fontSize != oldFontSize) {
            this.firePropertyChange(FONT_SIZE, oldFontSize, this.fontSize);
            SystemConsole.getInstance().setFontSize(this.fontSize);
        }
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle == 1 || fontStyle == 2 || fontStyle == 0 || fontStyle == 3) {
            int oldFontStyle = this.fontStyle;
            this.fontStyle = fontStyle;
            if (this.fontStyle != oldFontStyle) {
                this.firePropertyChange(FONT_STYLE, oldFontStyle, fontStyle);
                SystemConsole.getInstance().setFontStyle(this.fontStyle);
            }
        }
    }

    @Deprecated
    public String getFontFamily() {
        return "Monospaced";
    }

    @Deprecated
    public void setFontFamily(String fontFamily) {
    }

    public int getWrapStyle() {
        return this.wrapStyle;
    }

    public void setWrapStyle(int wrapStyle) {
        if (wrapStyle == 1 || wrapStyle == 0 || wrapStyle == 2) {
            int oldWrapStyle = this.wrapStyle;
            this.wrapStyle = wrapStyle;
            this.firePropertyChange(WRAP_STYLE, oldWrapStyle, wrapStyle);
            SystemConsole.getInstance().setWrapStyle(this.getWrapStyle());
        }
    }

    @Override
    public boolean isInitializedWithExceptions(Profile profile) {
        return this.initialized && !this.exceptions.isEmpty();
    }

    @Override
    @Nonnull
    public List<Exception> getInitializationExceptions(Profile profile) {
        return new ArrayList<Exception>(this.exceptions);
    }
}

