/*
 * Decompiled with CFR 0.152.
 */
package apps.swing;

import apps.swing.Bundle;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.Application;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.swing.ConnectionLabel;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AboutDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(AboutDialog.class);

    public AboutDialog(JFrame frame, boolean modal) {
        super((Frame)frame, modal);
        log.debug("Start UI");
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(this.namePane());
        pane.add(this.infoPane());
        this.add(pane);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setTitle(Bundle.getMessage("TitleAbout", Application.getApplicationName()));
        log.debug("End constructor");
    }

    protected JPanel namePane() {
        String logo = Application.getLogo();
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        if (log.isDebugEnabled()) {
            log.debug("Fetch main logo: {} ({})", (Object)logo, (Object)FileUtil.findURL(logo, FileUtil.Location.INSTALLED));
        }
        this.addCenteredComponent(new JLabel(new ImageIcon(this.getToolkit().getImage(FileUtil.findURL(logo, FileUtil.Location.INSTALLED)), "JMRI logo"), 0), pane);
        pane.add(Box.createRigidArea(new Dimension(0, 15)));
        String name = Application.getApplicationName();
        name = this.checkCopyright(name);
        JLabel appName = new JLabel(name, 0);
        appName.setFont(pane.getFont().deriveFont(1, (float)pane.getFont().getSize() * 1.2f));
        this.addCenteredComponent(appName, pane);
        this.addCenteredComponent(new JLabel(Application.getURL(), 0), pane);
        pane.add(Box.createRigidArea(new Dimension(0, 15)));
        pane.setAlignmentX(0.5f);
        return pane;
    }

    protected String checkCopyright(String name) {
        if (name.toUpperCase().equals("DECODERPRO")) {
            name = String.valueOf(name) + "\u00ae";
        }
        return name;
    }

    protected JPanel infoPane() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 1));
        log.debug("start labels");
        for (ConnectionConfig conn : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (conn.getDisabled()) continue;
            pane1.add(new ConnectionLabel(conn));
        }
        pane1.add(Box.createRigidArea(new Dimension(0, 15)));
        pane1.add(new JLabel(Bundle.getMessage("DefaultVersionCredit", Version.name())));
        pane1.add(new JLabel(Version.getCopyright()));
        pane1.add(new JLabel(Bundle.getMessage("JavaVersionCredit", System.getProperty("java.version", "<unknown>"), Locale.getDefault().toString())));
        pane1.setAlignmentX(0.5f);
        return pane1;
    }

    protected void addCenteredComponent(JComponent c, JPanel p) {
        c.setAlignmentX(0.5f);
        p.add(c);
    }
}

