/*
 * Decompiled with CFR 0.152.
 */
package apps.startup.configurexml;

import apps.startup.ScriptButtonModel;
import apps.startup.configurexml.Bundle;
import java.io.FileNotFoundException;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.util.FileUtil;
import jmri.util.prefs.InitializationException;
import jmri.util.startup.StartupActionsManager;
import jmri.util.startup.StartupModel;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptButtonModelXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(ScriptButtonModelXml.class);

    @Override
    public Element store(Object o) {
        Element element = new Element("perform");
        element.setAttribute("name", ((StartupModel)o).getName());
        element.setAttribute("type", "Button");
        element.setAttribute("class", this.getClass().getName());
        Element property = new Element("property");
        property.setAttribute("name", "script");
        property.setAttribute("value", FileUtil.getPortableFilename(((ScriptButtonModel)o).getScript()));
        element.addContent((Content)property);
        return element;
    }

    @Override
    public boolean loadDeferred() {
        return true;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        boolean result = false;
        ScriptButtonModel model = new ScriptButtonModel();
        model.setName(shared.getAttribute("name").getValue());
        for (Element child : shared.getChildren("property")) {
            if (!child.getAttributeValue("name").equals("script") || child.getAttributeValue("value") == null) continue;
            String script = child.getAttributeValue("value");
            try {
                model.setScript(FileUtil.getFile(script));
                result = true;
            }
            catch (FileNotFoundException ex) {
                model.addException(new InitializationException(Bundle.getMessage(Locale.ENGLISH, "ScriptButtonModel.ScriptNotFound", script), Bundle.getMessage("ScriptButtonModel.ScriptNotFound", script), ex));
                log.error("Unable to create button for script {}", (Object)script);
            }
        }
        InstanceManager.getDefault(StartupActionsManager.class).addAction(model);
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Unexpected call of load(Element, Object)");
    }
}

