/*
 * Decompiled with CFR 0.152.
 */
package apps.startup;

import apps.startup.Bundle;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Route;
import jmri.RouteManager;
import jmri.util.prefs.InitializationException;
import jmri.util.startup.AbstractStartupModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerRouteModel
extends AbstractStartupModel {
    private static final Logger log = LoggerFactory.getLogger(TriggerRouteModel.class);

    public String getUserName() {
        return this.getName();
    }

    public void setUserName(String name) {
        this.setName(name);
    }

    public Route getRoute() {
        return InstanceManager.getDefault(RouteManager.class).getByUserName(this.getUserName());
    }

    @Override
    public void performAction() throws JmriException {
        log.info("Setting route \"{}\" at startup.", (Object)this.getUserName());
        try {
            this.getRoute().setRoute();
        }
        catch (NullPointerException ex) {
            log.error("Unable to set route \"{}\"; it has not been defined. Is its panel loaded?", (Object)this.getUserName());
            InitializationException exception = new InitializationException(Bundle.getMessage(Locale.ENGLISH, "TriggerRouteModel.RouteNotDefined", this.getUserName()), Bundle.getMessage("TriggerRouteModel.RouteNotDefined", this.getUserName()), ex);
            this.addException(exception);
            throw new JmriException(exception);
        }
    }
}

