/*
 * Decompiled with CFR 0.152.
 */
package apps.plaf.macosx;

import apps.plaf.macosx.AboutHandler;
import apps.plaf.macosx.Application;
import apps.plaf.macosx.PreferencesHandler;
import apps.plaf.macosx.QuitHandler;
import java.awt.Desktop;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import jmri.script.JmriScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jdk9Application
extends Application {
    private static final Logger log = LoggerFactory.getLogger(Jdk9Application.class);

    Jdk9Application() {
    }

    private void setHandler(String methodName, String handlerType, Object handler) {
        try {
            Class<?> parameterType = Class.forName(handlerType);
            Class[] parameterTypes = new Class[]{parameterType};
            Method method = Desktop.class.getDeclaredMethod(methodName, parameterTypes);
            Object[] parameters = new Object[]{handler};
            method.invoke((Object)Desktop.getDesktop(), parameters);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            log.debug("Exception calling {} with {}", new Object[]{methodName, handlerType, ex});
        }
    }

    @Override
    public void setAboutHandler(AboutHandler handler) {
        if (handler != null) {
            try {
                InputStreamReader reader = new InputStreamReader(Jdk9Application.class.getResourceAsStream("AboutHandler.js"));
                ScriptEngine engine = JmriScriptEngineManager.getDefault().getEngineByMimeType("js");
                engine.eval((Reader)reader, this.getContext(handler));
            }
            catch (ScriptException ex) {
                log.error("Unable to execute script AboutHandler.js", (Throwable)ex);
            }
        } else {
            this.setHandler("setAboutHandler", "java.awt.desktop.AboutHandler", null);
        }
    }

    @Override
    public void setPreferencesHandler(PreferencesHandler handler) {
        if (handler != null) {
            try {
                InputStreamReader reader = new InputStreamReader(Jdk9Application.class.getResourceAsStream("PreferencesHandler.js"));
                ScriptEngine engine = JmriScriptEngineManager.getDefault().getEngineByMimeType("js");
                engine.eval((Reader)reader, this.getContext(handler));
            }
            catch (ScriptException ex) {
                log.error("Unable to execute script PreferencesHandler.js", (Throwable)ex);
            }
        } else {
            this.setHandler("setPreferencesHandler", "java.awt.desktop.PreferencesHandler", null);
        }
    }

    @Override
    public void setQuitHandler(QuitHandler handler) {
        if (handler != null) {
            try {
                InputStreamReader reader = new InputStreamReader(Jdk9Application.class.getResourceAsStream("QuitHandler.js"));
                ScriptEngine engine = JmriScriptEngineManager.getDefault().getEngineByMimeType("js");
                engine.eval((Reader)reader, this.getContext(handler));
            }
            catch (ScriptException ex) {
                log.error("Unable to execute script QuitHandler.js", (Throwable)ex);
            }
        } else {
            this.setHandler("setQuitHandler", "java.awt.desktop.QuitHandler", null);
        }
    }

    private ScriptContext getContext(Object handler) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("handler", handler);
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(bindings, 100);
        return context;
    }
}

