/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3.tabbedpreferences;

import apps.gui3.tabbedpreferences.Bundle;
import apps.gui3.tabbedpreferences.EditConnectionPreferences;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.swing.PreferencesPanel;

public final class EditConnectionPreferencesDialog
extends JDialog
implements WindowListener {
    final EditConnectionPreferences editConnectionPreferences;
    boolean restartProgram = false;

    @Override
    public String getTitle() {
        return this.editConnectionPreferences.getTitle();
    }

    public boolean isMultipleInstances() {
        return true;
    }

    public static boolean showDialog() {
        EditConnectionPreferencesDialog dialog = new EditConnectionPreferencesDialog();
        SwingUtilities.updateComponentTreeUI(dialog);
        dialog.pack();
        dialog.setVisible(true);
        return dialog.restartProgram;
    }

    public EditConnectionPreferencesDialog() {
        this.setModal(true);
        this.editConnectionPreferences = new EditConnectionPreferences(this);
        this.editConnectionPreferences.init();
        this.add(this.editConnectionPreferences);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public void gotoPreferenceItem(String item, String sub) {
        this.editConnectionPreferences.gotoPreferenceItem(item, sub);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        ShutDownManager sdm = InstanceManager.getDefault(ShutDownManager.class);
        if (!this.editConnectionPreferences.isPreferencesValid() && !sdm.isShuttingDown()) {
            for (PreferencesPanel panel : this.editConnectionPreferences.getPreferencesPanels().values()) {
                if (panel.isPreferencesValid()) continue;
                switch (JOptionPane.showConfirmDialog(this, Bundle.getMessage("InvalidPreferencesMessage", panel.getTabbedPreferencesTitle()), Bundle.getMessage("InvalidPreferencesTitle"), 0, 0)) {
                    case 0: {
                        this.editConnectionPreferences.gotoPreferenceItem(panel.getPreferencesItem(), panel.getTabbedPreferencesTitle());
                        return;
                    }
                }
            }
        }
        if (this.editConnectionPreferences.isDirty()) {
            switch (JOptionPane.showConfirmDialog(this, Bundle.getMessage("UnsavedChangesMessage", this.editConnectionPreferences.getTitle()), Bundle.getMessage("UnsavedChangesTitle"), 1, 3)) {
                case 0: {
                    this.editConnectionPreferences.savePressed(this.editConnectionPreferences.invokeSaveOptions());
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

