/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3.dp3;

import apps.gui3.Apps3;
import apps.gui3.dp3.Bundle;
import apps.gui3.dp3.DecoderPro3Window;
import apps.gui3.tabbedpreferences.TabbedPreferencesAction;
import java.awt.Dimension;
import java.io.File;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderPro3
extends Apps3 {
    private static String menuFile = null;
    private static String toolbarFile = null;
    private static final String applicationName = "DecoderPro";
    private static final Logger log = LoggerFactory.getLogger(DecoderPro3.class);

    public DecoderPro3(String[] args) {
        super(applicationName, "DecoderProConfig3.xml", args);
    }

    public static synchronized String getMenuFile() {
        if (menuFile == null) {
            menuFile = "dp3/Gui3Menus.xml";
            File file = new File(menuFile);
            if (!file.isAbsolute()) {
                menuFile = String.valueOf(FileUtil.getUserFilesPath()) + "dp3/Gui3Menus.xml";
                file = new File(menuFile);
            }
            if (!file.exists()) {
                menuFile = "xml/config/parts/jmri/jmrit/roster/swing/RosterFrameMenu.xml";
            } else {
                log.info("Found user created menu structure this will be used instead of the system default");
            }
        }
        return menuFile;
    }

    public static synchronized String getToolbarFile() {
        if (toolbarFile == null) {
            toolbarFile = "dp3/Gui3MainToolBar.xml";
            File file = new File(toolbarFile);
            if (!file.isAbsolute()) {
                toolbarFile = String.valueOf(FileUtil.getUserFilesPath()) + "dp3/Gui3MainToolBar.xml";
                file = new File(toolbarFile);
            }
            if (!file.exists()) {
                toolbarFile = "xml/config/parts/jmri/jmrit/roster/swing/RosterFrameToolBar.xml";
            } else {
                log.info("Found user created toolbar structure this will be used instead of the system default");
            }
        }
        return toolbarFile;
    }

    @Override
    protected void createMainFrame() {
        this.mainFrame = new DecoderPro3Window(DecoderPro3.getMenuFile(), DecoderPro3.getToolbarFile());
    }

    @Override
    protected void displayMainFrame(Dimension d) {
        UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
        if (!p.hasProperties(this.mainFrame.getWindowFrameRef())) {
            this.mainFrame.setSize(new Dimension(1024, 600));
            this.mainFrame.setPreferredSize(new Dimension(1024, 600));
        }
        this.mainFrame.setVisible(true);
    }

    public static void main(String[] args) {
        DecoderPro3.preInit(args);
        DecoderPro3 app = new DecoderPro3(args);
        app.start();
    }

    public static void preInit(String[] args) {
        Apps3.preInit(applicationName);
        Apps3.setConfigFilename("DecoderProConfig3.xml", args);
    }

    @Override
    protected void start() {
        super.start();
        if (!(this.configOK && this.configDeferredLoadOK || !this.preferenceFileExists)) {
            TabbedPreferencesAction prefsAction = new TabbedPreferencesAction(Bundle.getMessage("MenuItemPreferences"));
            prefsAction.actionPerformed(null);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    InstanceManager.getDefault(DecoderIndexFile.class);
                }
                catch (Exception ex) {
                    log.error("Error in trying to initialize decoder index file {}", (Object)ex.toString());
                }
            }
        };
        Thread thr = new Thread(r, "initialize decoder index");
        thr.start();
    }
}

