/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3;

import apps.gui3.Apps3;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import jmri.Application;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.PortAdapter;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstTimeStartUpWizard {
    Image splashIm;
    JmriJFrame parent;
    private final JmrixConfigPane connectionConfigPane = JmrixConfigPane.createNewPanel();
    JLabel header = new JLabel();
    ArrayList<WizardPage> wizPage = new ArrayList();
    Apps3 app;
    JPanel entryPanel = new JPanel();
    JPanel helpPanel = new JPanel();
    Dimension minHelpFieldDim = new Dimension(160, 20);
    Dimension maxHelpFieldDim = new Dimension(160, 300);
    JTextField owner = new JTextField(20);
    int currentScreen = 0;
    Locale initalLocale;
    JComboBox<String> localeBox;
    HashMap<String, Locale> locale;
    String[] localeNames;
    JPanel mainWizardPanel = new JPanel();
    private static final Logger log = LoggerFactory.getLogger(FirstTimeStartUpWizard.class);

    public FirstTimeStartUpWizard(JmriJFrame parent, Apps3 app) {
        this.parent = parent;
        this.app = app;
        this.mainWizardPanel.setLayout(new BorderLayout());
        this.mainWizardPanel.add((Component)this.createTopBanner(), "North");
        this.mainWizardPanel.add((Component)this.createHelpPanel(), "West");
        this.mainWizardPanel.add((Component)this.createEntryPanel(), "Center");
        this.mainWizardPanel.add((Component)this.createButtonPanel(), "South");
    }

    JPanel createTopBanner() {
        JPanel top = new JPanel();
        this.header.setText("Welcome to JMRI StartUp Wizard");
        top.add(this.header);
        return top;
    }

    JPanel createHelpPanel() {
        this.splashIm = Toolkit.getDefaultToolkit().getImage(FileUtil.findURL("resources/logo.gif", FileUtil.Location.INSTALLED));
        ImageIcon img = new ImageIcon(this.splashIm, "JMRI splash screen");
        int imageWidth = img.getIconWidth();
        this.minHelpFieldDim = new Dimension(imageWidth, 20);
        this.maxHelpFieldDim = new Dimension(imageWidth + 20, 350);
        this.helpPanel.setPreferredSize(this.maxHelpFieldDim);
        this.helpPanel.setMaximumSize(this.maxHelpFieldDim);
        this.helpPanel.setLayout(new BoxLayout(this.helpPanel, 1));
        JLabel l = new JLabel(img);
        l.setAlignmentX(0.5f);
        l.setOpaque(false);
        this.helpPanel.add(l);
        return this.helpPanel;
    }

    void createScreens() {
        this.firstWelcome();
        this.setDefaultOwner();
        this.setConnection();
        this.finishAndConnect();
    }

    public void dispose() {
        Cursor normalCursor = new Cursor(0);
        this.parent.setCursor(normalCursor);
        this.app.createAndDisplayFrame();
        this.parent.setVisible(false);
        this.parent.dispose();
    }

    JComponent createEntryPanel() {
        this.createScreens();
        int i = 0;
        while (i < this.wizPage.size()) {
            this.entryPanel.add(this.wizPage.get(i).getPanel());
            this.helpPanel.add(this.wizPage.get(i).getHelpDetails());
            ++i;
        }
        this.wizPage.get(0).getPanel().setVisible(true);
        this.wizPage.get(0).getHelpDetails().setVisible(true);
        this.header.setFont(this.header.getFont().deriveFont(14.0f));
        return this.entryPanel;
    }

    void setDefaultOwner() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.formatText("Select your language<br>"));
        this.initalLocale = Locale.getDefault();
        p.add(this.doLocale());
        p.add(this.formatText("<br>Enter in the default owner for all your loco roster entries<p>If you are part of group or club, where different people will be accessing DecoderPro, then you can leave this blank</p>"));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(new JLabel("Default Owner"));
        this.owner.setText(InstanceManager.getDefault(RosterConfigManager.class).getDefaultOwner());
        if (this.owner.getText().equals("")) {
            this.owner.setText(System.getProperty("user.name"));
        }
        p2.add(this.owner);
        p.add(p2);
        this.wizPage.add(new WizardPage(p, new JPanel(), "Set the Default Language and Owner"));
    }

    void setConnection() {
        JPanel h = new JPanel();
        h.setLayout(new BoxLayout(h, 1));
        h.setMaximumSize(this.maxHelpFieldDim);
        JTextArea text = new JTextArea("First select the manufacturer of your DCC system\n\nFollowed by the type of connection being used.\n\nFinally select the serial port or enter in the IP address of the device");
        text.setEditable(false);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setOpaque(false);
        text.setMinimumSize(this.minHelpFieldDim);
        text.setMaximumSize(this.maxHelpFieldDim);
        h.add(text);
        this.wizPage.add(new WizardPage(this.connectionConfigPane, h, "Select your DCC Connection"));
    }

    void firstWelcome() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.formatText("Welcome to JMRI's " + Application.getApplicationName() + "<p><br>This little wizard will help to guide you through setting up " + Application.getApplicationName() + " for the first time"));
        this.wizPage.add(new WizardPage(p, new JPanel(), "Welcome to JMRI StartUp Wizard"));
    }

    void finishAndConnect() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.formatText("Configuration is now all complete, press finish below to connect to your system and start using " + Application.getApplicationName() + "\n\nIf at any time you need to change your settings, you can find the preference setting under the Edit Menu"));
        this.wizPage.add(new WizardPage(p, new JPanel(), "Finish and Connect"));
    }

    JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.setBorder(new BevelBorder(1));
        JButton previous = new JButton("< Back");
        JButton next = new JButton("Next >");
        JButton finish = new JButton("Finish");
        finish.setVisible(false);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            Locale.setDefault(this.initalLocale);
            this.dispose();
        });
        previous.addActionListener(e -> {
            if (this.currentScreen < this.wizPage.size()) {
                this.wizPage.get(this.currentScreen).getPanel().setVisible(false);
                this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(false);
            }
            finish.setVisible(false);
            --this.currentScreen;
            if (this.currentScreen != -1) {
                this.wizPage.get(this.currentScreen).getPanel().setVisible(true);
                this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(true);
                this.header.setText(this.wizPage.get(this.currentScreen).getHeaderText());
                this.header.setFont(this.header.getFont().deriveFont(14.0f));
                if (this.currentScreen == 0) {
                    previous.setEnabled(false);
                }
                next.setEnabled(true);
                next.setVisible(true);
            } else {
                this.currentScreen = 0;
                previous.setEnabled(false);
            }
        });
        next.addActionListener(e -> {
            this.wizPage.get(this.currentScreen).getPanel().setVisible(false);
            this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(false);
            ++this.currentScreen;
            if (this.currentScreen < this.wizPage.size()) {
                this.wizPage.get(this.currentScreen).getPanel().setVisible(true);
                this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(true);
                this.header.setText(this.wizPage.get(this.currentScreen).getHeaderText());
                this.header.setFont(this.header.getFont().deriveFont(14.0f));
                previous.setEnabled(true);
                if (this.currentScreen == this.wizPage.size() - 1) {
                    next.setEnabled(false);
                    next.setVisible(false);
                    finish.setVisible(true);
                }
            }
        });
        finish.addActionListener(e -> {
            Connect r = new Connect();
            Thread connectThread = new Thread(r);
            connectThread.start();
            connectThread.setName("Start-Up Wizard Connect");
        });
        buttonPanel.add(previous);
        buttonPanel.add(next);
        buttonPanel.add(new JLabel("     "));
        buttonPanel.add(finish);
        buttonPanel.add(cancel);
        previous.setEnabled(false);
        return buttonPanel;
    }

    public JPanel doLocale() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.localeBox = new JComboBox<String>(new String[]{Locale.getDefault().getDisplayName(), "(Please Wait)"});
        panel.add(this.localeBox);
        Runnable r = () -> {
            Locale[] locales = Locale.getAvailableLocales();
            this.localeNames = new String[locales.length];
            this.locale = new HashMap();
            int i = 0;
            while (i < locales.length) {
                this.locale.put(locales[i].getDisplayName(), locales[i]);
                this.localeNames[i] = locales[i].getDisplayName();
                ++i;
            }
            Arrays.sort(this.localeNames);
            Runnable update = () -> {
                this.localeBox.setModel(new DefaultComboBoxModel<String>(this.localeNames));
                this.localeBox.setSelectedItem(Locale.getDefault().getDisplayName());
            };
            SwingUtilities.invokeLater(update);
        };
        new Thread(r).start();
        this.localeBox.addActionListener(a -> {
            if (this.localeBox == null || this.locale == null) {
                return;
            }
            String desired = (String)this.localeBox.getSelectedItem();
            Locale.setDefault(this.locale.get(desired));
        });
        return panel;
    }

    JLabel formatText(String text) {
        JLabel label = new JLabel();
        label.setText("<html><body width='450'>" + text + "</html>");
        return label;
    }

    public JPanel getPanel() {
        return this.mainWizardPanel;
    }

    protected class Connect
    implements Runnable {
        protected Connect() {
        }

        @Override
        public void run() {
            Cursor hourglassCursor = new Cursor(3);
            FirstTimeStartUpWizard.this.parent.setCursor(hourglassCursor);
            ConnectionConfig connect = FirstTimeStartUpWizard.this.connectionConfigPane.getCurrentObject();
            ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cm != null) {
                cm.registerPref(connect);
            }
            if (connect instanceof AbstractConnectionConfig) {
                ((AbstractConnectionConfig)connect).updateAdapter();
                PortAdapter adp = connect.getAdapter();
                try {
                    adp.connect();
                    adp.configure();
                }
                catch (Exception ex) {
                    log.error(ex.getLocalizedMessage(), (Throwable)ex);
                    Cursor normalCursor = new Cursor(0);
                    FirstTimeStartUpWizard.this.parent.setCursor(normalCursor);
                    JOptionPane.showMessageDialog(null, "An error occurred while trying to connect to " + connect.getConnectionName() + ", press the back button and check the connection details", "Error Opening Connection", 0);
                    return;
                }
            }
            Profile project = ProfileManager.getDefault().getActiveProfile();
            InstanceManager.getDefault(RosterConfigManager.class).setDefaultOwner(project, FirstTimeStartUpWizard.this.owner.getText());
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setLocale(Locale.getDefault());
            InstanceManager.getDefault(RosterConfigManager.class).savePreferences(project);
            InstanceManager.getDefault(GuiLafPreferencesManager.class).savePreferences(project);
            FirstTimeStartUpWizard.this.connectionConfigPane.savePreferences();
            InstanceManager.getDefault(ConfigureManager.class).storePrefs();
            FirstTimeStartUpWizard.this.dispose();
        }
    }

    static class WizardPage {
        static Dimension defaultInfoSize = new Dimension(500, 300);
        JComponent panel;
        JPanel helpDetails = new JPanel();
        String headerText = "";

        WizardPage(JComponent mainPanel, JPanel helpDetails, String headerText) {
            this.panel = mainPanel;
            if (helpDetails != null) {
                this.helpDetails = helpDetails;
                this.helpDetails.setLayout(new BoxLayout(this.helpDetails, 1));
            }
            if (this.panel != null) {
                this.panel.setPreferredSize(defaultInfoSize);
                this.panel.setVisible(false);
            }
            this.helpDetails.setVisible(false);
            this.headerText = headerText;
        }

        JComponent getPanel() {
            return this.panel;
        }

        JPanel getHelpDetails() {
            return this.helpDetails;
        }

        String getHeaderText() {
            return this.headerText;
        }
    }
}

