/*
 * Decompiled with CFR 0.152.
 */
package apps.configurexml;

import apps.GuiLafConfigPane;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.util.gui.GuiLafPreferencesManager;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GuiLafConfigPaneXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(GuiLafConfigPaneXml.class);

    @Override
    public Element store(Object o) {
        Element e = new Element("gui");
        GuiLafConfigPane g = (GuiLafConfigPane)o;
        String lafClassName = g.getClassName();
        e.setAttribute("LAFclass", lafClassName);
        e.setAttribute("class", this.getClass().getName());
        Locale l = g.getLocale();
        e.setAttribute("LocaleLanguage", l.getLanguage());
        e.setAttribute("LocaleCountry", l.getCountry());
        e.setAttribute("LocaleVariant", l.getVariant());
        GuiLafPreferencesManager manager = InstanceManager.getDefault(GuiLafPreferencesManager.class);
        if (manager.getFontSize() != manager.getDefaultFontSize()) {
            e.setAttribute("fontsize", Integer.toString(manager.getFontSize()));
        }
        e.setAttribute("nonStandardMouseEvent", g.mouseEvent.isSelected() ? "yes" : "no");
        e.setAttribute("graphicTableState", g.graphicStateDisplay.isSelected() ? "yes" : "no");
        e.setAttribute("tabbedOblockEditor", g.tabbedOblockEditor.isSelected() ? "yes" : "no");
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Attribute fontsize;
        Attribute oBlockTable;
        Attribute graphicAttr;
        Attribute clickAttr;
        boolean result = true;
        UIManager.LookAndFeelInfo[] plafs = UIManager.getInstalledLookAndFeels();
        Hashtable<String, String> installedLAFs = new Hashtable<String, String>(plafs.length);
        int i = 0;
        while (i < plafs.length) {
            installedLAFs.put(plafs[i].getName(), plafs[i].getClassName());
            ++i;
        }
        String name = shared.getAttribute("LAFclass").getValue();
        String className = (String)installedLAFs.get(name);
        log.debug("GUI selection: {} class name: {}", (Object)name, (Object)className);
        if (className != null) {
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setLookAndFeel(name);
            try {
                if (!className.equals(UIManager.getLookAndFeel().getClass().getName())) {
                    log.debug("set GUI to {},{}", (Object)name, (Object)className);
                    this.updateLookAndFeel(name, className);
                } else {
                    log.debug("skip updateLAF as already has className=={}", (Object)className);
                }
            }
            catch (Exception ex) {
                log.error("Exception while setting GUI look & feel: {}", (Throwable)ex);
                result = false;
            }
        }
        Attribute langAttr = shared.getAttribute("LocaleLanguage");
        Attribute countryAttr = shared.getAttribute("LocaleCountry");
        Attribute varAttr = shared.getAttribute("LocaleVariant");
        if (countryAttr != null && langAttr != null && varAttr != null) {
            Locale locale = new Locale(langAttr.getValue(), countryAttr.getValue(), varAttr.getValue());
            log.debug("About to setDefault Locale", (Throwable)new Exception(""));
            Locale.setDefault(locale);
            JComponent.setDefaultLocale(locale);
            JOptionPane.setDefaultLocale(locale);
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setLocale(locale);
        }
        if ((clickAttr = shared.getAttribute("nonStandardMouseEvent")) != null) {
            boolean nonStandardMouseEvent = clickAttr.getValue().equals("yes");
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setNonStandardMouseEvent(nonStandardMouseEvent);
        }
        if ((graphicAttr = shared.getAttribute("graphicTableState")) != null) {
            boolean graphicTableState = graphicAttr.getValue().equals("yes");
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setGraphicTableState(graphicTableState);
        }
        if ((oBlockTable = shared.getAttribute("tabbedOblockEditor")) != null) {
            boolean tabbedOblockEditor = oBlockTable.getValue().equals("yes");
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setOblockEditTabbed(tabbedOblockEditor);
        }
        GuiLafConfigPane g = new GuiLafConfigPane();
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerPref(g);
        }
        if ((fontsize = shared.getAttribute("fontsize")) != null) {
            int size = Integer.parseInt(fontsize.getValue());
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setFontSize(size);
            this.setUIFontSize(size);
        }
        return result;
    }

    public void updateLookAndFeel(String name, String className) {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            String errMsg = "The " + name + " look-and-feel ";
            errMsg = e instanceof UnsupportedLookAndFeelException ? String.valueOf(errMsg) + "is not supported on this platform." : (e instanceof ClassNotFoundException ? String.valueOf(errMsg) + "could not be found." : String.valueOf(errMsg) + "could not be loaded.");
            log.error(errMsg);
        }
    }

    public void setUIFontSize(float size) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            Font f = UIManager.getFont(key).deriveFont(((Font)value).getStyle(), size);
            UIManager.put(key, f);
        }
    }

    public void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }
}

