/*
 * Decompiled with CFR 0.152.
 */
package apps.configurexml;

import apps.FileLocationPane;
import java.util.List;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class FileLocationPaneXml
extends AbstractXmlAdapter {
    @Override
    public Element store(Object o) {
        Element e = new Element("fileLocations");
        this.storeLocation(e, "defaultScriptLocation", FileUtil.getScriptsPath());
        this.storeUserFilesLocation(e, FileUtil.getUserFilesPath());
        e.setAttribute("class", this.getClass().getName());
        return e;
    }

    private void storeLocation(Element locations, String attr, String value) {
        Element userLocation = new Element("fileLocation");
        userLocation.setAttribute(attr, FileUtil.getPortableFilename(value));
        locations.addContent((Content)userLocation);
    }

    private void storeUserFilesLocation(Element locations, String value) {
        Element userLocation = new Element("fileLocation");
        userLocation.setAttribute("defaultUserLocation", FileUtil.getPortableFilename(value, true, false));
        locations.addContent((Content)userLocation);
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        ConfigureManager cm;
        boolean result = true;
        String value = this.loadUserLocations(shared, "defaultUserLocation");
        if (value != null) {
            FileUtil.setUserFilesPath(ProfileManager.getDefault().getActiveProfile(), value);
        }
        if ((value = this.loadUserLocations(shared, "defaultScriptLocation")) != null) {
            FileUtil.setScriptsPath(ProfileManager.getDefault().getActiveProfile(), value);
        }
        if ((cm = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cm.registerPref(new FileLocationPane());
        }
        return result;
    }

    private String loadUserLocations(Element messages, String attr) {
        List messageList = messages.getChildren("fileLocation");
        for (Element message : messageList) {
            if (message.getAttribute(attr) == null) continue;
            return FileUtil.getAbsoluteFilename(message.getAttribute(attr).getValue());
        }
        return null;
    }
}

