/*
 * Decompiled with CFR 0.152.
 */
package apps.configurexml;

import apps.CreateButtonModel;
import java.lang.reflect.InvocationTargetException;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrix.swing.SystemConnectionAction;
import jmri.util.startup.StartupActionsManager;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateButtonModelXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(CreateButtonModelXml.class);

    @Override
    public Element store(Object o) {
        Element element = new Element("perform");
        CreateButtonModel g = (CreateButtonModel)o;
        element.setAttribute("name", g.getClassName());
        element.setAttribute("type", "Button");
        element.setAttribute("class", this.getClass().getName());
        Element property = new Element("property");
        property.setAttribute("name", "systemPrefix");
        property.setAttribute("value", g.getSystemPrefix());
        element.addContent((Content)property);
        return element;
    }

    @Override
    public boolean loadDeferred() {
        return true;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        boolean result = true;
        String className = shared.getAttribute("name").getValue();
        CreateButtonModel model = new CreateButtonModel();
        model.setClassName(className);
        shared.getChildren("property").forEach(child -> {
            String value = child.getAttributeValue("value");
            if (child.getAttributeValue("name").equals("systemPrefix") && value != null) {
                try {
                    Class<?> ac = Class.forName(className);
                    if (value.isEmpty() && SystemConnectionAction.class.isAssignableFrom(ac)) {
                        SystemConnectionAction a = (SystemConnectionAction)ac.getConstructor(new Class[0]).newInstance(new Object[0]);
                        InstanceManager.getList(SystemConnectionMemo.class).forEach(memo -> a.getSystemConnectionMemoClasses().stream().filter(mc -> memo.getClass().isAssignableFrom((Class<?>)mc)).forEach(mc -> model.setSystemPrefix(memo.getSystemPrefix())));
                    } else {
                        model.setSystemPrefix(value);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    log.warn("While trying to do {}, encountered exception", (Object)className, (Object)ex);
                }
            }
        });
        InstanceManager.getDefault(StartupActionsManager.class).addAction(model);
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Unexpected call of load(Element, Object)");
    }
}

