/*
 * Decompiled with CFR 0.152.
 */
package apps.TrainCrew;

import apps.TrainCrew.Bundle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import jmri.util.UnzipFileClass;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallFromURL
extends JmriAbstractAction {
    JPanel _who;
    private static final Logger log = LoggerFactory.getLogger(InstallFromURL.class);

    public InstallFromURL(String s, WindowInterface wi) {
        super(s, wi);
    }

    public InstallFromURL(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public InstallFromURL(String s) {
        super(s);
    }

    public InstallFromURL(String s, JPanel who) {
        super(s);
    }

    public InstallFromURL() {
        super(Bundle.getMessage("TrainCrewInstallMenu"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ResourceBundle bundle = ResourceBundle.getBundle("apps.TrainCrew.InstallFromURL");
        String urlString = bundle.getString("TrainCrewZipURL");
        String targetDirectory = bundle.getString("TrainCrewInstallDirectory");
        log.info("Will install from {} to {}", (Object)urlString, (Object)targetDirectory);
        try {
            URL url = new URL(urlString);
            try {
                InputStream inStream = url.openConnection().getInputStream();
                UnzipFileClass.unzipFunction(new File(targetDirectory), inStream);
                log.info("Complete!");
            }
            catch (IOException ex) {
                log.error("Error in transfer", (Throwable)ex);
            }
        }
        catch (MalformedURLException ex) {
            log.error("Invalid URL", (Throwable)ex);
        }
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

