/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.SystemConsole;
import apps.systemconsole.SystemConsolePreferencesManager;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import jmri.InstanceManager;
import jmri.swing.PreferencesPanel;

public class SystemConsoleConfigPanel
extends JPanel
implements PreferencesPanel {
    private static final ResourceBundle rbc = ResourceBundle.getBundle("apps.AppsConfigBundle");
    private static final Integer[] fontSizes = new Integer[]{8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 24};
    private static final Integer[] wrapStyles = new Integer[]{0, 1, 2};
    private static final String[] wrapStyleNames = new String[]{rbc.getString("ConsoleWrapStyleNone"), rbc.getString("ConsoleWrapStyleLine"), rbc.getString("ConsoleWrapStyleWord")};
    private static final JToggleButton fontStyleBold = new JToggleButton("B");
    private static final JToggleButton fontStyleItalic = new JToggleButton("I");
    private static final JComboBox<SystemConsole.Scheme> schemes = new JComboBox<SystemConsole.Scheme>(SystemConsole.getInstance().getSchemes());
    private static final JComboBox<Integer> fontSize = new JComboBox<Integer>(fontSizes);

    public SystemConsoleConfigPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel(new FlowLayout());
        p.add(new JLabel(rbc.getString("ConsoleScheme")));
        schemes.setSelectedIndex(this.getPreferencesManager().getScheme());
        schemes.addActionListener(e -> this.getPreferencesManager().setScheme(schemes.getSelectedIndex()));
        schemes.setRenderer((list, scheme, index, isSelected, hasFocus) -> {
            JPanel p1 = new JPanel();
            p1.setOpaque(index > -1);
            if (isSelected && index > -1) {
                p1.setBackground(list.getSelectionBackground());
                p1.setForeground(list.getSelectionForeground());
            } else {
                p1.setBackground(list.getBackground());
                p1.setForeground(list.getForeground());
            }
            JLabel l = new JLabel(" " + scheme.description + " ");
            l.setOpaque(true);
            l.setFont(new Font("Monospaced", this.getPreferencesManager().getFontStyle(), 12));
            l.setForeground(scheme.foreground);
            l.setBackground(scheme.background);
            p1.add(l);
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif") && index == -1) {
                return l;
            }
            return p1;
        });
        p.add(schemes);
        this.add(p);
        p = new JPanel(new FlowLayout());
        fontSize.addActionListener(e -> this.getPreferencesManager().setFontSize((Integer)fontSize.getSelectedItem()));
        fontSize.setToolTipText(rbc.getString("ConsoleFontSize"));
        fontSize.setSelectedItem(this.getPreferencesManager().getFontSize());
        JLabel fontSizeUoM = new JLabel(rbc.getString("ConsoleFontSizeUoM"));
        p.add(fontSize);
        p.add(fontSizeUoM);
        fontStyleBold.setFont(fontStyleBold.getFont().deriveFont(1));
        fontStyleBold.addActionListener(e -> this.doFontStyle());
        fontStyleBold.setToolTipText(rbc.getString("ConsoleFontStyleBold"));
        fontStyleBold.setSelected((this.getPreferencesManager().getFontStyle() & 1) == 1);
        p.add(fontStyleBold);
        fontStyleItalic.setFont(fontStyleItalic.getFont().deriveFont(2));
        fontStyleItalic.addActionListener(e -> this.doFontStyle());
        fontStyleItalic.setSelected((this.getPreferencesManager().getFontStyle() & 2) == 2);
        fontStyleItalic.setToolTipText(rbc.getString("ConsoleFontStyleItalic"));
        p.add(fontStyleItalic);
        this.add(p);
        p = new JPanel(new FlowLayout());
        JComboBox<String> wrapStyle = new JComboBox<String>(wrapStyleNames);
        wrapStyle.addActionListener(e -> this.getPreferencesManager().setWrapStyle(wrapStyles[wrapStyle.getSelectedIndex()]));
        wrapStyle.setSelectedIndex(this.getPreferencesManager().getWrapStyle());
        p.add(new JLabel(rbc.getString("ConsoleWrapStyle")));
        p.add(wrapStyle);
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.add(p);
    }

    private void doFontStyle() {
        this.getPreferencesManager().setFontStyle((fontStyleBold.isSelected() ? 1 : 0) | (fontStyleItalic.isSelected() ? 2 : 0));
        schemes.repaint();
    }

    @Override
    public String getPreferencesItem() {
        return "DISPLAY";
    }

    @Override
    public String getPreferencesItemText() {
        return rbc.getString("MenuDisplay");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return rbc.getString("TabbedLayoutConsole");
    }

    @Override
    public String getLabelKey() {
        return rbc.getString("LabelTabbedLayoutConsole");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isRestartRequired() {
        return false;
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    private SystemConsolePreferencesManager getPreferencesManager() {
        return InstanceManager.getDefault(SystemConsolePreferencesManager.class);
    }
}

