/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.util.FileUtil;

public class SplashWindow
extends JFrame {
    Image splashIm;

    public SplashWindow() {
        super("JMRI");
        this.splashWindowDisplay(null);
    }

    public SplashWindow(JPanel splashMsg) {
        super("JMRI");
        this.splashWindowDisplay(splashMsg);
    }

    public void splashWindowDisplay(JPanel splashMsg) {
        this.setUndecorated(true);
        MediaTracker mt = new MediaTracker(this);
        this.splashIm = Toolkit.getDefaultToolkit().getImage(FileUtil.findURL("resources/logo.gif", FileUtil.Location.INSTALLED));
        mt.addImage(this.splashIm, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        JLabel l = new JLabel(new ImageIcon(this.splashIm, "JMRI splash screen"));
        l.setOpaque(true);
        if (splashMsg != null) {
            JPanel full = new JPanel();
            full.setLayout(new BoxLayout(full, 1));
            l.setAlignmentX(0.5f);
            splashMsg.setAlignmentX(0.5f);
            full.add(l);
            full.add(splashMsg);
            this.getContentPane().add(full);
        } else {
            this.getContentPane().add(l);
        }
        this.pack();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle winDim = this.getBounds();
        winDim.height += 10;
        winDim.width += 10;
        this.setLocation((screenDim.width - winDim.width) / 2, (screenDim.height - winDim.height) / 2);
        this.setSize(winDim.width, winDim.height);
        this.setVisible(true);
    }
}

