/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Bundle;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.jmrit.mailreport.ReportContext;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;

public class ReportContextAction
extends JmriAbstractAction {
    JTextArea pane;

    public ReportContextAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public ReportContextAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public ReportContextAction() {
        super(Bundle.getMessage("TitleContext"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        final JmriJFrame frame = new JmriJFrame(Bundle.getMessage("TitleContext"));
        final Clipboard clipboard = frame.getToolkit().getSystemClipboard();
        this.pane = new JTextArea();
        this.pane.append("\n");
        this.pane.setEditable(false);
        this.pane.setLineWrap(true);
        this.pane.setWrapStyleWord(true);
        this.pane.setColumns(120);
        JScrollPane scroll = new JScrollPane(this.pane);
        frame.add((Component)scroll, "Center");
        ReportContext r = new ReportContext();
        this.addString(r.getReport(true));
        this.pane.append("\n");
        JPanel p = new JPanel();
        JButton copy = new JButton(Bundle.getMessage("ButtonCopyClip"));
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StringSelection text = new StringSelection(ReportContextAction.this.pane.getText());
                clipboard.setContents(text, text);
            }
        });
        p.add(copy);
        JButton close = new JButton(Bundle.getMessage("ButtonClose"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.setVisible(false);
                frame.dispose();
            }
        });
        p.add(close);
        frame.add((Component)p, "South");
        ((Window)frame).pack();
        this.pane.setCaretPosition(0);
        JScrollBar b = scroll.getVerticalScrollBar();
        b.setValue(b.getMaximum());
        frame.setVisible(true);
    }

    void addString(String val) {
        this.pane.append(String.valueOf(val) + "\n");
    }

    void addProperty(String prop) {
        this.addString(String.valueOf(prop) + ": " + System.getProperty(prop) + "  ");
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

