/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Bundle;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.managers.ManagerDefaultSelector;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.swing.PreferencesPanel;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagerDefaultsConfigPane
extends JmriPanel
implements PreferencesPanel {
    private static final ResourceBundle rb = ResourceBundle.getBundle("apps.AppsConfigBundle");
    private boolean dirty = false;
    JPanel matrix;
    ButtonGroup[] groups;
    private static final Logger log = LoggerFactory.getLogger(ManagerDefaultsConfigPane.class);

    public ManagerDefaultsConfigPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.matrix = new JPanel();
        this.add(this.matrix);
        InstanceManager.getDefault(ManagerDefaultSelector.class).addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("Updated")) {
                this.update();
            }
        });
        this.update();
    }

    public void update() {
        log.debug(" update start");
        this.matrix.removeAll();
        List<SystemConnectionMemo> connList = InstanceManager.getList(SystemConnectionMemo.class);
        if (!connList.isEmpty()) {
            log.debug("   update of {} connections", (Object)connList.size());
            this.reloadConnections(connList);
        } else {
            log.debug("   update with no new-form system connections configured");
            this.matrix.add(new JLabel("No new-form system connections configured"));
        }
        log.debug(" update end");
    }

    void reloadConnections(List<SystemConnectionMemo> connList) {
        log.debug(" reloadConnections start");
        ManagerDefaultSelector manager = InstanceManager.getDefault(ManagerDefaultSelector.class);
        this.matrix.setLayout(new GridLayout2(connList.size() + 1, manager.knownManagers.length + 1));
        this.matrix.add(new JLabel(""));
        ManagerDefaultSelector.Item[] itemArray = manager.knownManagers;
        int n = manager.knownManagers.length;
        int n2 = 0;
        while (n2 < n) {
            ManagerDefaultSelector.Item item = itemArray[n2];
            log.trace("   Add typeName {}", (Object)item.typeName);
            this.matrix.add(new JLabel(item.typeName));
            ++n2;
        }
        this.groups = new ButtonGroup[manager.knownManagers.length];
        int i = 0;
        while (i < manager.knownManagers.length) {
            this.groups[i] = new ButtonGroup();
            ++i;
        }
        boolean[] selected = new boolean[manager.knownManagers.length];
        int x = 0;
        while (x < connList.size()) {
            SystemConnectionMemo memo = connList.get(x);
            String connectionName = memo.getUserName();
            log.trace("   Connection name {}", (Object)connectionName);
            this.matrix.add(new JLabel(connectionName));
            int i2 = 0;
            ManagerDefaultSelector.Item[] itemArray2 = manager.knownManagers;
            int n3 = manager.knownManagers.length;
            int n4 = 0;
            while (n4 < n3) {
                JRadioButton r;
                ManagerDefaultSelector.Item item = itemArray2[n4];
                log.trace("      item {}", (Object)item.typeName);
                if (memo.provides(item.managerClass)) {
                    r = new SelectionButton(connectionName, item.typeName, item.managerClass, this);
                    this.matrix.add(r);
                    this.groups[i2].add(r);
                    if (!selected[i2] && manager.getDefault(item.managerClass) == null) {
                        log.trace("      setting selected based on default");
                        r.setSelected(true);
                        selected[i2] = true;
                    }
                } else {
                    r = new JRadioButton();
                    r.setToolTipText(Bundle.getMessage("TooltipDefaultnotValid", connectionName, ManagerDefaultsConfigPane.dropTags(item.typeName)));
                    r.setEnabled(false);
                    this.matrix.add(r);
                }
                ++i2;
                ++n4;
            }
            ++x;
        }
        this.revalidate();
        log.debug(" reloadConnections end");
    }

    @Override
    public String getPreferencesItem() {
        return "DEFAULTS";
    }

    @Override
    public String getPreferencesItemText() {
        return rb.getString("MenuDefaults");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return rb.getString("TabbedLayoutDefaults");
    }

    @Override
    public String getLabelKey() {
        return rb.getString("LabelTabbedLayoutDefaults");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            InstanceManager.getDefault(ManagerDefaultSelector.class).savePreferences(profile);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isRestartRequired() {
        return this.isDirty();
    }

    @Override
    public boolean isPreferencesValid() {
        return InstanceManager.getDefault(ManagerDefaultSelector.class).isPreferencesValid(ProfileManager.getDefault().getActiveProfile());
    }

    private static String dropTags(String s) {
        return s.replaceAll("</?[a-zA-Z]*>", " ");
    }

    static final class SelectionButton
    extends JRadioButton {
        String connectionName;
        String managerName;
        Class<?> managerClass;

        SelectionButton(String connectionName, String managerName, Class<?> managerClass, ManagerDefaultsConfigPane pane) {
            this.managerClass = managerClass;
            this.connectionName = connectionName;
            this.managerName = ManagerDefaultsConfigPane.dropTags(managerName);
            this.setToolTipText(this.makeToolTipText());
            log.trace("      SelectionButton ctor for {} as {}", (Object)connectionName, (Object)managerName);
            if (connectionName.equals(InstanceManager.getDefault(ManagerDefaultSelector.class).getDefault(managerClass))) {
                this.setSelected(true);
            }
            this.addActionListener(e -> {
                if (this.isSelected()) {
                    InstanceManager.getDefault(ManagerDefaultSelector.class).setDefault(this.managerClass, this.connectionName);
                    pane.dirty = true;
                    this.setToolTipText(Bundle.getMessage("TooltipDefaultSelectedRestart", this.connectionName, this.managerName));
                }
            });
        }

        private String makeToolTipText() {
            return this.isSelected() ? Bundle.getMessage("TooltipDefaultSelected", this.connectionName, this.managerName) : Bundle.getMessage("TooltipDefaultNotSelected", this.connectionName, this.managerName);
        }

        @Override
        public void setSelected(boolean t) {
            super.setSelected(t);
            log.debug("SelectionButton setSelected called with {}", (Object)t);
            this.setToolTipText(this.makeToolTipText());
            if (t) {
                InstanceManager.getDefault(ManagerDefaultSelector.class).setDefault(this.managerClass, this.connectionName);
            }
        }
    }
}

