/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.ConfigBundle;
import java.awt.FlowLayout;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jmri.InstanceManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.swing.PreferencesPanel;
import jmri.util.EarlyInitializationPreferences;
import jmri.util.gui.GuiLafPreferencesManager;

public final class GuiLafConfigPane
extends JPanel
implements PreferencesPanel {
    public static final int MAX_TOOLTIP_TIME = 3600;
    public static final int MIN_TOOLTIP_TIME = 1;
    public static final int MIN_DISPLAYED_FONT_SIZE = 9;
    public static final int MAX_DISPLAYED_FONT_SIZE = 20;
    private final JComboBox<String> localeBox = new JComboBox<String>(new String[]{Locale.getDefault().getDisplayName(), "(Please Wait)"});
    private final HashMap<String, Locale> locale = new HashMap();
    private final ButtonGroup LAFGroup = new ButtonGroup();
    public JCheckBox mouseEvent;
    private JComboBox<Integer> fontSizeComboBox;
    public JCheckBox graphicStateDisplay;
    public JCheckBox tabbedOblockEditor;
    public JCheckBox editorUseOldLocSizeDisplay;
    public JCheckBox force100percentScaling;
    private JSpinner maxComboRowsSpinner;
    private JSpinner toolTipDismissDelaySpinner;

    public GuiLafConfigPane() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        this.doLAF(p);
        this.add(p);
        p = new JPanel();
        this.doFontSize(p);
        this.add(p);
        p = new JPanel();
        this.doClickSelection(p);
        this.add(p);
        p = new JPanel();
        this.doGraphicState(p);
        this.add(p);
        p = new JPanel();
        this.doTabbedOblockEditor(p);
        this.add(p);
        p = new JPanel();
        this.doEditorUseOldLocSize(p);
        this.add(p);
        p = new JPanel();
        this.doForce100percentScaling(p);
        this.add(p);
        p = new JPanel();
        this.doMaxComboRows(p);
        this.add(p);
        p = new JPanel();
        this.doToolTipDismissDelay(p);
        this.add(p);
    }

    void doClickSelection(JPanel panel) {
        panel.setLayout(new FlowLayout());
        this.mouseEvent = new JCheckBox(ConfigBundle.getMessage("GUIButtonNonStandardRelease"));
        this.mouseEvent.addItemListener(e -> InstanceManager.getDefault(GuiLafPreferencesManager.class).setNonStandardMouseEvent(this.mouseEvent.isSelected()));
        panel.add(this.mouseEvent);
    }

    void doGraphicState(JPanel panel) {
        panel.setLayout(new FlowLayout());
        this.graphicStateDisplay = new JCheckBox(ConfigBundle.getMessage("GUIGraphicTableState"));
        this.graphicStateDisplay.setSelected(InstanceManager.getDefault(GuiLafPreferencesManager.class).isGraphicTableState());
        this.graphicStateDisplay.addItemListener(e -> InstanceManager.getDefault(GuiLafPreferencesManager.class).setGraphicTableState(this.graphicStateDisplay.isSelected()));
        panel.add(this.graphicStateDisplay);
    }

    void doTabbedOblockEditor(JPanel panel) {
        panel.setLayout(new FlowLayout());
        this.tabbedOblockEditor = new JCheckBox(ConfigBundle.getMessage("GUITabbedOblockEditor"));
        this.tabbedOblockEditor.setSelected(InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed());
        this.tabbedOblockEditor.setToolTipText(ConfigBundle.getMessage("GUIToolTipTabbedEdit"));
        this.tabbedOblockEditor.addItemListener(e -> InstanceManager.getDefault(GuiLafPreferencesManager.class).setOblockEditTabbed(this.tabbedOblockEditor.isSelected()));
        panel.add(this.tabbedOblockEditor);
    }

    void doEditorUseOldLocSize(JPanel panel) {
        panel.setLayout(new FlowLayout());
        this.editorUseOldLocSizeDisplay = new JCheckBox(ConfigBundle.getMessage("GUIUseOldLocSize"));
        this.editorUseOldLocSizeDisplay.setSelected(InstanceManager.getDefault(GuiLafPreferencesManager.class).isEditorUseOldLocSize());
        this.editorUseOldLocSizeDisplay.addItemListener(e -> InstanceManager.getDefault(GuiLafPreferencesManager.class).setEditorUseOldLocSize(this.editorUseOldLocSizeDisplay.isSelected()));
        panel.add(this.editorUseOldLocSizeDisplay);
    }

    void doForce100percentScaling(JPanel panel) {
        EarlyInitializationPreferences eip = EarlyInitializationPreferences.getInstance();
        panel.setLayout(new FlowLayout());
        this.force100percentScaling = new JCheckBox(ConfigBundle.getMessage("GUIForce100percentScaling"));
        this.force100percentScaling.setSelected(eip.getGUIForce100percentScaling());
        this.force100percentScaling.addItemListener(e -> eip.setGUIForce100percentScaling(this.force100percentScaling.isSelected()));
        panel.add(this.force100percentScaling);
    }

    void doLAF(JPanel panel) {
        panel.setLayout(new FlowLayout());
        UIManager.LookAndFeelInfo[] plafs = UIManager.getInstalledLookAndFeels();
        HashMap<String, String> installedLAFs = new HashMap<String, String>(plafs.length);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = plafs;
        int n = plafs.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo plaf = lookAndFeelInfoArray[n2];
            installedLAFs.put(plaf.getName(), plaf.getClassName());
            ++n2;
        }
        for (Map.Entry entry : installedLAFs.entrySet()) {
            String name = (String)entry.getKey();
            JRadioButton jmi = new JRadioButton(name);
            panel.add(jmi);
            this.LAFGroup.add(jmi);
            jmi.setActionCommand(name);
            jmi.addActionListener(e -> InstanceManager.getDefault(GuiLafPreferencesManager.class).setLookAndFeel((String)installedLAFs.get(name)));
            if (!((String)entry.getValue()).equals(UIManager.getLookAndFeel().getClass().getName())) continue;
            jmi.setSelected(true);
        }
    }

    public JPanel doLocale() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.localeBox);
        Runnable r = () -> {
            Locale[] locales = Locale.getAvailableLocales();
            Object[] localeNames = new String[locales.length];
            int i = 0;
            while (i < locales.length) {
                this.locale.put(locales[i].getDisplayName(), locales[i]);
                localeNames[i] = locales[i].getDisplayName();
                ++i;
            }
            Arrays.sort(localeNames);
            Runnable update = () -> this.lambda$7((String[])localeNames);
            SwingUtilities.invokeLater(update);
        };
        new Thread(r).start();
        return panel;
    }

    public void setLocale(String loc) {
        this.localeBox.setSelectedItem(loc);
    }

    @Override
    public Locale getLocale() {
        Locale desired = this.locale.get(this.localeBox.getSelectedItem().toString());
        return desired != null ? desired : Locale.getDefault();
    }

    public void doFontSize(JPanel panel) {
        GuiLafPreferencesManager manager = InstanceManager.getDefault(GuiLafPreferencesManager.class);
        Integer[] sizes = new Integer[12];
        int i = 0;
        while (i < sizes.length) {
            sizes[i] = i + 9;
            ++i;
        }
        this.fontSizeComboBox = new JComboBox<Integer>(sizes);
        this.fontSizeComboBox.setEditable(true);
        JLabel fontSizeLabel = new JLabel(ConfigBundle.getMessage("ConsoleFontSize"));
        this.fontSizeComboBox.setSelectedItem(manager.getFontSize());
        JLabel fontSizeUoM = new JLabel(ConfigBundle.getMessage("ConsoleFontSizeUoM"));
        JButton resetButton = new JButton(ConfigBundle.getMessage("ResetDefault"));
        resetButton.setToolTipText(ConfigBundle.getMessage("GUIFontSizeReset"));
        panel.add(fontSizeLabel);
        panel.add(this.fontSizeComboBox);
        panel.add(fontSizeUoM);
        panel.add(resetButton);
        this.fontSizeComboBox.addActionListener(e -> manager.setFontSize((Integer)this.fontSizeComboBox.getSelectedItem()));
        resetButton.addActionListener(e -> {
            if (((Integer)this.fontSizeComboBox.getSelectedItem()).intValue() != manager.getDefaultFontSize()) {
                this.fontSizeComboBox.setSelectedItem(manager.getDefaultFontSize());
            }
        });
    }

    public void doMaxComboRows(JPanel panel) {
        GuiLafPreferencesManager manager = InstanceManager.getDefault(GuiLafPreferencesManager.class);
        JLabel maxComboRowsLabel = new JLabel(ConfigBundle.getMessage("GUIMaxComboRows"));
        this.maxComboRowsSpinner = new JSpinner(new SpinnerNumberModel(manager.getMaxComboRows(), 0, 999, 1));
        this.maxComboRowsSpinner.addChangeListener(e -> manager.setMaxComboRows((Integer)this.maxComboRowsSpinner.getValue()));
        this.maxComboRowsSpinner.setToolTipText(ConfigBundle.getMessage("GUIMaxComboRowsToolTip"));
        maxComboRowsLabel.setToolTipText(this.maxComboRowsSpinner.getToolTipText());
        panel.add(maxComboRowsLabel);
        panel.add(this.maxComboRowsSpinner);
    }

    public void doToolTipDismissDelay(JPanel panel) {
        GuiLafPreferencesManager manager = InstanceManager.getDefault(GuiLafPreferencesManager.class);
        JLabel toolTipDismissDelayLabel = new JLabel(ConfigBundle.getMessage("GUIToolTipDismissDelay"));
        this.toolTipDismissDelaySpinner = new JSpinner(new SpinnerNumberModel(manager.getToolTipDismissDelay() / 1000, 1, 3600, 1));
        this.toolTipDismissDelaySpinner.addChangeListener(e -> manager.setToolTipDismissDelay((Integer)this.toolTipDismissDelaySpinner.getValue() * 1000));
        this.toolTipDismissDelaySpinner.setToolTipText(MessageFormat.format(ConfigBundle.getMessage("GUIToolTipDismissDelayToolTip"), 1, 3600));
        toolTipDismissDelayLabel.setToolTipText(this.toolTipDismissDelaySpinner.getToolTipText());
        JLabel toolTipDismissDelayUoM = new JLabel(ConfigBundle.getMessage("GUIToolTipDismissDelayUoM"));
        toolTipDismissDelayUoM.setToolTipText(this.toolTipDismissDelaySpinner.getToolTipText());
        panel.add(toolTipDismissDelayLabel);
        panel.add(this.toolTipDismissDelaySpinner);
        panel.add(toolTipDismissDelayUoM);
    }

    public String getClassName() {
        return this.LAFGroup.getSelection().getActionCommand();
    }

    @Override
    public String getPreferencesItem() {
        return "DISPLAY";
    }

    @Override
    public String getPreferencesItemText() {
        return ConfigBundle.getMessage("MenuDisplay");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return ConfigBundle.getMessage("TabbedLayoutGUI");
    }

    @Override
    public String getLabelKey() {
        return ConfigBundle.getMessage("LabelTabbedLayoutGUI");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            InstanceManager.getDefault(GuiLafPreferencesManager.class).savePreferences(profile);
        }
    }

    @Override
    public boolean isDirty() {
        return InstanceManager.getDefault(GuiLafPreferencesManager.class).isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return InstanceManager.getDefault(GuiLafPreferencesManager.class).isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    private /* synthetic */ void lambda$7(String[] stringArray) {
        this.localeBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.localeBox.setSelectedItem(Locale.getDefault().getDisplayName());
        this.localeBox.addActionListener(e -> InstanceManager.getDefault(GuiLafPreferencesManager.class).setLocale(this.locale.getOrDefault(this.localeBox.getSelectedItem(), Locale.getDefault())));
    }
}

