/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.ConfigBundle;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.implementation.FileLocationsPreferences;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.swing.PreferencesPanel;
import jmri.util.FileUtil;

public final class FileLocationPane
extends JPanel
implements PreferencesPanel {
    private boolean restartRequired = false;
    private final JTextField scriptLocation = new JTextField();
    private final JTextField userLocation = new JTextField();

    public FileLocationPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.prefLocation());
        this.add(this.scriptsLocation());
    }

    private JPanel scriptsLocation() {
        JButton bScript = new JButton(ConfigBundle.getMessage("ButtonSetDots"));
        JFileChooser fcScript = new JFileChooser(FileUtil.getScriptsPath());
        fcScript.setDialogTitle(ConfigBundle.getMessage("MessageSelectDirectory"));
        fcScript.setFileSelectionMode(1);
        fcScript.setAcceptAllFileFilterUsed(false);
        bScript.addActionListener(new OpenAction(fcScript, this.scriptLocation));
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        JLabel scripts = new JLabel(ConfigBundle.getMessage("ScriptDir"));
        p.add(scripts);
        p.add(this.scriptLocation);
        p.add(bScript);
        this.scriptLocation.setColumns(30);
        this.scriptLocation.setText(FileUtil.getScriptsPath());
        return p;
    }

    private JPanel prefLocation() {
        JPanel p = new JPanel();
        JLabel users = new JLabel(ConfigBundle.getMessage("PrefDir"));
        p.add(users);
        p.add(this.userLocation);
        this.userLocation.setColumns(30);
        this.userLocation.setText(FileUtil.getUserFilesPath());
        JButton bUser = new JButton(ConfigBundle.getMessage("ButtonSetDots"));
        JFileChooser fcUser = new JFileChooser(FileUtil.getUserFilesPath());
        fcUser.setDialogTitle(ConfigBundle.getMessage("MessageSelectDirectory"));
        fcUser.setFileSelectionMode(1);
        fcUser.setAcceptAllFileFilterUsed(false);
        bUser.addActionListener(new OpenAction(fcUser, this.userLocation));
        p.add(bUser);
        return p;
    }

    @Override
    public String getPreferencesItem() {
        return "FILELOCATIONS";
    }

    @Override
    public String getPreferencesItemText() {
        return ConfigBundle.getMessage("MenuFileLocation");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return ConfigBundle.getMessage("TabbedLayoutFileLocations");
    }

    @Override
    public String getLabelKey() {
        return ConfigBundle.getMessage("LabelTabbedFileLocations");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        Profile profile;
        if (!FileUtil.getUserFilesPath().equals(this.userLocation.getText())) {
            FileUtil.setUserFilesPath(ProfileManager.getDefault().getActiveProfile(), this.userLocation.getText());
            this.restartRequired = true;
        }
        if (!FileUtil.getScriptsPath().equals(this.scriptLocation.getText())) {
            FileUtil.setScriptsPath(ProfileManager.getDefault().getActiveProfile(), this.scriptLocation.getText());
            this.restartRequired = true;
        }
        if ((profile = ProfileManager.getDefault().getActiveProfile()) != null) {
            InstanceManager.getDefault(FileLocationsPreferences.class).savePreferences(profile);
        }
    }

    @Override
    public boolean isDirty() {
        return !FileUtil.getUserFilesPath().equals(this.userLocation.getText()) || !FileUtil.getScriptsPath().equals(this.scriptLocation.getText());
    }

    @Override
    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    private class OpenAction
    extends AbstractAction {
        JFileChooser chooser;
        JTextField field;

        OpenAction(JFileChooser chooser, JTextField field) {
            this.chooser = chooser;
            this.field = field;
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="protected by if instanceof")
        public void actionPerformed(ActionEvent e) {
            this.chooser.showOpenDialog(null);
            if (this.chooser.getSelectedFile() == null) {
                return;
            }
            this.field.setText(this.chooser.getSelectedFile() + File.separator);
            FileLocationPane.this.validate();
            if (FileLocationPane.this.getTopLevelAncestor() != null && FileLocationPane.this.getTopLevelAncestor() instanceof JFrame) {
                ((JFrame)FileLocationPane.this.getTopLevelAncestor()).pack();
            }
        }
    }
}

