/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Bundle;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jmri.Version;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForUpdateAction
extends JmriAbstractAction {
    private static final Logger log = LoggerFactory.getLogger(CheckForUpdateAction.class);

    public CheckForUpdateAction(@Nonnull String s, @Nonnull WindowInterface wi) {
        super(s, wi);
    }

    public CheckForUpdateAction(@Nonnull String s, @Nonnull Icon i, @Nonnull WindowInterface wi) {
        super(s, i, wi);
    }

    public CheckForUpdateAction() {
        super(Bundle.getMessage("TitleUpdate"));
    }

    /*
     * Loose catch block
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        String testrelease;
        String productionrelease;
        JTextArea text;
        JmriJFrame frame;
        block25: {
            frame = new JmriJFrame(Bundle.getMessage("TitleUpdate"), false, false);
            frame.setLayout(new BoxLayout(frame.getContentPane(), 1));
            text = new JTextArea();
            text.setEditable(false);
            frame.add(text);
            productionrelease = "";
            testrelease = "";
            InputStream in = null;
            try {
                String line;
                String urlname = "http://jmri.org/releaselist";
                URL url = new URL(urlname);
                in = url.openConnection().getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("production")) {
                        productionrelease = this.getNumber(reader);
                    }
                    if (!line.startsWith("test")) continue;
                    testrelease = this.getNumber(reader);
                }
            }
            catch (MalformedURLException e) {
                log.error("Unexpected failure in URL parsing", (Throwable)e);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e1) {
                    log.error("Exception closing input stream", (Throwable)e1);
                }
                return;
            }
            catch (FileNotFoundException e) {
                log.debug("Unable to get version info from web{}", (Throwable)e);
                break block25;
            }
            catch (IOException e) {
                log.debug("Unexpected failure during reading{}", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block25;
                }
                catch (IOException e1) {
                    log.error("Exception closing input stream", (Throwable)e1);
                }
                break block25;
            }
            {
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e1) {
                        log.error("Exception closing input stream", (Throwable)e1);
                    }
                }
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e1) {
                log.error("Exception closing input stream", (Throwable)e1);
            }
        }
        text.append(String.valueOf(Bundle.getMessage("MostRecent", productionrelease)) + "\n");
        text.append(String.valueOf(Bundle.getMessage("MostRecentTest", testrelease)) + "\n");
        text.append(String.valueOf(Bundle.getMessage("YouHaveVersion", Version.name())) + "\n");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        JButton go = new JButton(Bundle.getMessage("ButtonDownloadPage"));
        go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Desktop.getDesktop().browse(new URI("http://jmri.org/download"));
                }
                catch (URISyntaxException e) {
                    log.error("Invalid page requested", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Could no load page", (Throwable)e);
                }
            }
        });
        p.add(go);
        JButton close = new JButton(Bundle.getMessage("ButtonClose"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.setVisible(false);
                frame.dispose();
            }
        });
        p.add(close);
        frame.add(p);
        ((Window)frame).pack();
        frame.setVisible(true);
    }

    @Nonnull
    String getNumber(@Nonnull BufferedReader reader) throws IOException {
        reader.readLine();
        String line = reader.readLine();
        if (line == null) {
            return "";
        }
        return line.substring(0, line.length() - 1);
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

