/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Apps;
import apps.Bundle;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.Application;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrit.jython.Jynstrument;
import jmri.jmrit.jython.JynstrumentFactory;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.JmrixConfigPane;
import jmri.util.FileUtil;
import jmri.util.iharder.dnd.URIDrop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppsLaunchPane
extends JPanel
implements PropertyChangeListener {
    static String profileFilename;
    static JComponent _jynstrumentSpace;
    JLabel cs4 = new JLabel();
    JLabel cs5 = new JLabel();
    JLabel cs6 = new JLabel();
    JLabel cs7 = new JLabel();
    ConnectionConfig[] connection = new ConnectionConfig[4];
    static JComponent _buttonSpace;
    private static final Logger log;

    static {
        _jynstrumentSpace = null;
        _buttonSpace = null;
        log = LoggerFactory.getLogger(AppsLaunchPane.class);
    }

    public AppsLaunchPane() {
        super(true);
        this.setButtonSpace();
        this.setJynstrumentSpace();
        Application.setLogo(this.logo());
        Application.setURL(this.line2());
        log.debug("Start UI");
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.statusPanel());
        log.debug("Done with statusPanel, start buttonSpace");
        this.add(AppsLaunchPane.buttonSpace());
        this.add(_jynstrumentSpace);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="only one application at a time")
    protected void setButtonSpace() {
        _buttonSpace = new JPanel();
        _buttonSpace.setLayout(new FlowLayout());
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="only one application at a time")
    protected void setJynstrumentSpace() {
        _jynstrumentSpace = new JPanel();
        _jynstrumentSpace.setLayout(new FlowLayout());
        new URIDrop(_jynstrumentSpace, uris -> {
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                AppsLaunchPane.ynstrument(new File(uri).getPath());
                ++n2;
            }
        });
    }

    public static void ynstrument(String path) {
        Jynstrument it = JynstrumentFactory.createInstrument(path, _jynstrumentSpace);
        if (it == null) {
            log.error("Error while creating Jynstrument {}", (Object)path);
            return;
        }
        ThrottleFrame.setTransparent(it);
        it.setVisible(true);
        _jynstrumentSpace.setVisible(true);
        _jynstrumentSpace.add(it);
    }

    protected String line1() {
        return Bundle.getMessage("DefaultVersionCredit", Version.name());
    }

    protected String line2() {
        return "http://jmri.org/";
    }

    protected String line3() {
        return " ";
    }

    protected void buildLine4(JPanel pane) {
        if (this.connection[0] != null) {
            this.buildLine(this.connection[0], this.cs4, pane);
        }
    }

    protected void buildLine5(JPanel pane) {
        if (this.connection[1] != null) {
            this.buildLine(this.connection[1], this.cs5, pane);
        }
    }

    protected void buildLine6(JPanel pane) {
        if (this.connection[2] != null) {
            this.buildLine(this.connection[2], this.cs6, pane);
        }
    }

    protected void buildLine7(JPanel pane) {
        if (this.connection[3] != null) {
            this.buildLine(this.connection[3], this.cs7, pane);
        }
    }

    protected void buildLine(ConnectionConfig conn, JLabel cs, JPanel pane) {
        if (conn.name().equals(JmrixConfigPane.NONE)) {
            cs.setText(" ");
            return;
        }
        ConnectionStatus.instance().addConnection(conn.name(), conn.getInfo());
        cs.setFont(pane.getFont());
        this.updateLine(conn, cs);
        pane.add(cs);
    }

    protected void updateLine(ConnectionConfig conn, JLabel cs) {
        if (conn.getDisabled()) {
            return;
        }
        String name = conn.getConnectionName();
        if (name == null) {
            name = conn.getManufacturer();
        }
        if (ConnectionStatus.instance().isConnectionOk(null, conn.getInfo())) {
            cs.setForeground(Color.black);
            String cf = Bundle.getMessage("ConnectionSucceeded", name, conn.name(), conn.getInfo());
            cs.setText(cf);
        } else {
            cs.setForeground(Color.red);
            String cf = Bundle.getMessage("ConnectionFailed", name, conn.name(), conn.getInfo());
            cs.setText(cf);
        }
        this.revalidate();
    }

    protected String line8() {
        return " ";
    }

    protected String line9() {
        return Bundle.getMessage("JavaVersionCredit", System.getProperty("java.version", "<unknown>"), Locale.getDefault().toString());
    }

    protected String logo() {
        return "resources/logo.gif";
    }

    protected JPanel statusPanel() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        log.debug("Fetch main logo: {}", (Object)this.logo());
        pane1.add(new JLabel(new ImageIcon(this.getToolkit().getImage(FileUtil.findURL(this.logo(), FileUtil.Location.INSTALLED)), "JMRI logo"), 2));
        pane1.add(Box.createRigidArea(new Dimension(15, 0)));
        log.debug("start labels");
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BoxLayout(pane2, 1));
        pane2.add(new JLabel(this.line1()));
        pane2.add(new JLabel(this.line2()));
        pane2.add(new JLabel(this.line3()));
        ConnectionStatus.instance().addPropertyChangeListener(this);
        int i = 0;
        for (ConnectionConfig conn : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (!conn.getDisabled()) {
                this.connection[i] = conn;
                ++i;
            }
            if (i > 3) break;
        }
        this.buildLine4(pane2);
        this.buildLine5(pane2);
        this.buildLine6(pane2);
        this.buildLine7(pane2);
        pane2.add(new JLabel(this.line8()));
        pane2.add(new JLabel(this.line9()));
        pane1.add(pane2);
        return pane1;
    }

    protected static void setJmriSystemProperty(String key, String value) {
        try {
            String current = System.getProperty("org.jmri.Apps." + key);
            if (current == null) {
                System.setProperty("org.jmri.Apps." + key, value);
            } else if (!current.equals(value)) {
                log.warn("JMRI property {} already set to {}, skipping reset to {}", new Object[]{key, current, value});
            }
        }
        catch (Exception e) {
            log.error("Unable to set JMRI property {} to {} due to execption {}", new Object[]{key, value, e});
        }
    }

    public static JComponent buttonSpace() {
        return _buttonSpace;
    }

    protected static void setConfigFilename(String def, String[] args) {
        if (System.getProperty("org.jmri.Apps.configFilename") != null) {
            return;
        }
        if (args.length >= 1 && args[0] != null && !args[0].contains("=")) {
            def = args[0];
            log.debug("Config file was specified as: {}", (Object)args[0]);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] split = arg.split("=", 2);
            if (split[0].equalsIgnoreCase("config")) {
                def = split[1];
                log.debug("Config file was specified as: {}", (Object)arg);
            }
            ++n2;
        }
        Apps.configFilename = def;
        AppsLaunchPane.setJmriSystemProperty("configFilename", def);
    }

    public static String getConfigFileName() {
        log.debug("getConfigFileName() called, shouldn't have been", (Throwable)new Exception("bad call traceback"));
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        log.debug("property change: comm port status update");
        if (this.connection[0] != null) {
            this.updateLine(this.connection[0], this.cs4);
        }
        if (this.connection[1] != null) {
            this.updateLine(this.connection[1], this.cs5);
        }
        if (this.connection[2] != null) {
            this.updateLine(this.connection[2], this.cs6);
        }
        if (this.connection[3] != null) {
            this.updateLine(this.connection[3], this.cs7);
        }
    }

    protected abstract String windowHelpID();
}

