/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.AppsBase;
import apps.AppsConfigurationManager;
import apps.AppsMainMenu;
import apps.AppsPreferencesActionFactory;
import apps.Bundle;
import apps.CreateButtonModel;
import apps.SplashWindow;
import apps.gui3.tabbedpreferences.TabbedPreferences;
import apps.gui3.tabbedpreferences.TabbedPreferencesAction;
import apps.plaf.macosx.Application;
import apps.util.Log4JUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.JmriPlugin;
import jmri.LogixManager;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.Version;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.jython.Jynstrument;
import jmri.jmrit.jython.JynstrumentFactory;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.revhistory.FileHistory;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.JmrixConfigPane;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileManagerDialog;
import jmri.script.JmriScriptEngineManager;
import jmri.util.FileUtil;
import jmri.util.HelpUtil;
import jmri.util.JmriJFrame;
import jmri.util.SystemType;
import jmri.util.ThreadingUtil;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.iharder.dnd.URIDrop;
import jmri.util.prefs.JmriPreferencesActionFactory;
import jmri.util.swing.JFrameInterface;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Apps
extends JPanel
implements PropertyChangeListener,
WindowListener {
    static String profileFilename;
    private Action prefsAction;
    static JComponent _jynstrumentSpace;
    JLabel cs4 = new JLabel();
    JLabel cs5 = new JLabel();
    JLabel cs6 = new JLabel();
    JLabel cs7 = new JLabel();
    ConnectionConfig[] connection = new ConnectionConfig[4];
    static JComponent _buttonSpace;
    static SplashWindow sp;
    static AWTEventListener debugListener;
    static boolean debugFired;
    static boolean debugmsg;
    static String configFilename;
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="The following MUST be protected for 3rd party applications (such as CATS) which are derived from this class.")
    protected static boolean configOK;
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="The following MUST be protected for 3rd party applications (such as CATS) which are derived from this class.")
    protected static boolean configDeferredLoadOK;
    private JMenuBar menuBar;
    static String nameString;
    private static final Logger log;

    static {
        _jynstrumentSpace = null;
        _buttonSpace = null;
        sp = null;
        debugListener = null;
        debugFired = false;
        debugmsg = false;
        configFilename = System.getProperty("org.jmri.Apps.configFilename", "jmriconfig2.xml");
        nameString = "JMRI program";
        log = LoggerFactory.getLogger(Apps.class);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "SC_START_IN_CTOR"}, justification="only one application at a time. The thread is only called to help improve user experiance when opening the preferences, it is not critical for it to be run at this stage")
    public Apps() {
        super(true);
        long start = System.nanoTime();
        log.trace("starting ctor at {}", (Object)start);
        Apps.splash(false);
        Apps.splash(true, true);
        log.trace("splash screens up, about to setButtonSpace");
        this.setButtonSpace();
        log.trace("about to setJynstrumentSpace");
        this.setJynstrumentSpace();
        log.trace("setLogo");
        jmri.Application.setLogo(this.logo());
        log.trace("setURL");
        jmri.Application.setURL(this.line2());
        log.trace("start to get configuration profile - locate files");
        FileUtil.createDirectory(FileUtil.getPreferencesPath());
        profileFilename = configFilename.replaceFirst(".xml", ".properties");
        File profileFile = !new File(profileFilename).isAbsolute() ? new File(String.valueOf(FileUtil.getPreferencesPath()) + profileFilename) : new File(profileFilename);
        ProfileManager.getDefault().setConfigFile(profileFile);
        if (System.getProperties().containsKey("org.jmri.profile")) {
            ProfileManager.getDefault().setActiveProfile(System.getProperty("org.jmri.profile"));
        }
        log.trace("check if profile exists");
        if (!profileFile.exists()) {
            log.trace("profileFile {} doesn't exist", (Object)profileFile);
            try {
                if (ProfileManager.getDefault().migrateToProfiles(configFilename)) {
                    JOptionPane.showMessageDialog(sp, Bundle.getMessage("ConfigMigratedToProfile"), jmri.Application.getApplicationName(), 1);
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(sp, ex.getLocalizedMessage(), jmri.Application.getApplicationName(), 0);
                log.error("Exception migrating configuration to profiles: {}", (Object)ex.getMessage());
            }
        }
        log.trace("about to try getStartingProfile");
        try {
            ProfileManagerDialog.getStartingProfile(sp);
            configFilename = String.valueOf(FileUtil.getProfilePath()) + "ProfileConfig.xml";
            System.setProperty("org.jmri.Apps.configFilename", "ProfileConfig.xml");
            Profile profile = ProfileManager.getDefault().getActiveProfile();
            if (profile != null) {
                log.info("Starting with profile {}", (Object)profile.getId());
            } else {
                log.info("Starting without a profile");
            }
            GuiLafPreferencesManager.setLocaleMinimally(profile);
        }
        catch (IOException ex) {
            log.info("Profiles not configurable. Using fallback per-application configuration. Error: {}", (Object)ex.getMessage());
        }
        InstanceManager.store(new AppsPreferencesActionFactory(), JmriPreferencesActionFactory.class);
        ConfigureManager cm = InstanceManager.setDefault(ConfigureManager.class, new AppsConfigurationManager());
        InstanceManager.getDefault(FileHistory.class).addOperation("app", nameString, null);
        InstanceManager.store(new CreateButtonModel(), CreateButtonModel.class);
        File sharedConfig = null;
        File singleConfig = !new File(configFilename).isAbsolute() ? new File(String.valueOf(FileUtil.getUserFilesPath()) + configFilename) : new File(configFilename);
        try {
            sharedConfig = FileUtil.getFile("profile:profile/profile.xml");
            if (!sharedConfig.canRead()) {
                sharedConfig = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        final File file = sharedConfig != null ? sharedConfig : singleConfig;
        log.debug("*** About to getDefault(jmri.UserPreferencesManager.class) with file {}", (Object)file);
        ThreadingUtil.runOnGUI(() -> InstanceManager.getDefault(UserPreferencesManager.class));
        log.debug("*** Done");
        log.debug("Using config file(s) {}", (Object)file.getPath());
        if (file.exists()) {
            log.debug("start load config file {}", (Object)file.getPath());
            try {
                configOK = cm.load(file, true);
            }
            catch (JmriException e2) {
                log.error("Unhandled problem loading configuration", (Throwable)e2);
                configOK = false;
            }
            log.debug("end load config file, OK={}", (Object)configOK);
        } else {
            log.info("No saved preferences, will open preferences window.  Searched for {}", (Object)file.getPath());
            configOK = false;
        }
        log.debug("Start UI");
        this.setLayout(new BoxLayout(this, 1));
        long end = System.nanoTime();
        long elapsedTime = (end - start) / 1000000L;
        long sleep = 2500L - elapsedTime;
        if (sleep > 0L) {
            log.debug("Debug message was displayed for less than 2500ms ({}ms). Sleeping for {}ms to allow user sufficient time to do something.", (Object)elapsedTime, (Object)sleep);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e3) {
                log.error("", (Throwable)e3);
            }
        }
        FileUtil.logFilePaths();
        Apps.splash(false);
        Apps.splash(true, false);
        Toolkit.getDefaultToolkit().removeAWTEventListener(debugListener);
        while (debugmsg) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e4) {
                log.error("", (Throwable)e4);
            }
        }
        if (file.exists()) {
            if (file.equals(singleConfig)) {
                if (SwingUtilities.isEventDispatchThread()) {
                    configDeferredLoadOK = this.doDeferredLoad(file);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="configDeferredLoadOK write is semi-global")
                            public void run() {
                                configDeferredLoadOK = Apps.this.doDeferredLoad(file);
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        log.error("Exception creating system console frame", (Throwable)ex);
                    }
                }
            } else {
                configDeferredLoadOK = true;
            }
        } else {
            configDeferredLoadOK = false;
        }
        if (sharedConfig == null && configOK && configDeferredLoadOK) {
            log.info("Migrating preferences to new format...");
            InstanceManager.getOptionalDefault(TabbedPreferences.class).ifPresent(tp -> {
                tp.saveContents();
                cm.storePrefs();
            });
            log.info("Preferences have been migrated to new format.");
            log.info("New preferences format will be used after JMRI is restarted.");
            if (!GraphicsEnvironment.isHeadless()) {
                Profile profile = ProfileManager.getDefault().getActiveProfile();
                JOptionPane.showMessageDialog(sp, Bundle.getMessage("SingleConfigMigratedToSharedConfig", profile), jmri.Application.getApplicationName(), 1);
            }
        }
        InstanceManager.getDefault(LogixManager.class);
        InstanceManager.getDefault(LayoutBlockManager.class);
        new Thread(() -> {
            try {
                InstanceManager.getDefault(DecoderIndexFile.class);
            }
            catch (RuntimeException ex) {
                log.error("Error in trying to initialize decoder index file {}", (Object)ex.getMessage());
            }
        }, "initialize decoder index").start();
        if (Boolean.getBoolean("org.jmri.python.preload")) {
            new Thread(() -> {
                try {
                    JmriScriptEngineManager.getDefault().initializeAllEngines();
                }
                catch (RuntimeException ex) {
                    log.error("Error in trying to initialize python interpreter {}", (Object)ex.getMessage());
                }
            }, "initialize python interpreter").start();
        }
        log.debug("Config OK? {}, deferred config OK? {}", (Object)configOK, (Object)configDeferredLoadOK);
        if (!configOK || !configDeferredLoadOK) {
            HelpUtil.displayHelpRef("package.apps.AppConfigPanelErrorPage");
            this.doPreferences();
        }
        log.debug("Done with doPreferences, start statusPanel");
        this.add(this.statusPanel());
        log.debug("Done with statusPanel, start buttonSpace");
        this.add(Apps.buttonSpace());
        this.add(_jynstrumentSpace);
        long eventMask = 16L;
        Toolkit.getDefaultToolkit().addAWTEventListener(e -> {
            MouseEvent me;
            if (e instanceof MouseEvent && (me = (MouseEvent)e).isPopupTrigger() && me.getComponent() instanceof JTextComponent) {
                JTextComponent component1 = (JTextComponent)me.getComponent();
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem(new DefaultEditorKit.CopyAction());
                item.setText("Copy");
                item.setEnabled(component1.getSelectionStart() != component1.getSelectionEnd());
                menu.add(item);
                item = new JMenuItem(new DefaultEditorKit.CutAction());
                item.setText("Cut");
                item.setEnabled(component1.isEditable() && component1.getSelectionStart() != component1.getSelectionEnd());
                menu.add(item);
                item = new JMenuItem(new DefaultEditorKit.PasteAction());
                item.setText("Paste");
                item.setEnabled(component1.isEditable());
                menu.add(item);
                menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }, eventMask);
        InstanceManager.getDefault(LogixManager.class).activateAllLogixs();
        InstanceManager.getDefault(LayoutBlockManager.class).initializeLayoutBlockPaths();
        LogixNG_Manager logixNG_Manager = InstanceManager.getDefault(LogixNG_Manager.class);
        logixNG_Manager.setupAllLogixNGs();
        if (InstanceManager.getDefault(LogixNGPreferences.class).getStartLogixNGOnStartup()) {
            logixNG_Manager.activateAllLogixNGs();
        }
        log.debug("End constructor");
    }

    private boolean doDeferredLoad(File file) {
        boolean result;
        log.debug("start deferred load from config");
        try {
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                result = cmOD.loadDeferred(file);
            } else {
                log.error("Failed to get default configure manager");
                result = false;
            }
        }
        catch (JmriException e) {
            log.error("Unhandled problem loading deferred configuration", (Throwable)e);
            result = false;
        }
        log.debug("end deferred load from config file, OK={}", (Object)result);
        return result;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="only one application at a time")
    protected void setButtonSpace() {
        _buttonSpace = new JPanel();
        _buttonSpace.setLayout(new FlowLayout());
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="only one application at a time")
    protected void setJynstrumentSpace() {
        _jynstrumentSpace = new JPanel();
        _jynstrumentSpace.setLayout(new FlowLayout());
        new URIDrop(_jynstrumentSpace, uris -> {
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                Apps.ynstrument(new File(uri).getPath());
                ++n2;
            }
        });
    }

    public static void ynstrument(String path) {
        Jynstrument it = JynstrumentFactory.createInstrument(path, _jynstrumentSpace);
        if (it == null) {
            log.error("Error while creating Jynstrument {}", (Object)path);
            return;
        }
        ThrottleFrame.setTransparent(it);
        it.setVisible(true);
        _jynstrumentSpace.setVisible(true);
        _jynstrumentSpace.add(it);
    }

    protected void createMenus(JMenuBar menuBar, WindowInterface wi) {
        if (SystemType.isMacOSX()) {
            Application.getApplication().setQuitHandler(eo -> Apps.handleQuit());
        }
        AppsMainMenu.createMenus(menuBar, wi, this, this.mainWindowHelpID());
    }

    public void doPreferences() {
        if (this.prefsAction == null) {
            this.prefsAction = new TabbedPreferencesAction();
        }
        this.prefsAction.actionPerformed(null);
    }

    protected void setPrefsFrameHelp(JmriJFrame frame, String location) {
        frame.addHelpMenu(location, true);
    }

    protected String mainWindowHelpID() {
        return "package.apps.Apps";
    }

    protected String line1() {
        return Bundle.getMessage("DefaultVersionCredit", Version.name());
    }

    protected String line2() {
        return "http://jmri.org/";
    }

    protected String line3() {
        return " ";
    }

    protected void buildLine4(JPanel pane) {
        if (this.connection[0] != null) {
            this.buildLine(this.connection[0], this.cs4, pane);
        }
    }

    protected void buildLine5(JPanel pane) {
        if (this.connection[1] != null) {
            this.buildLine(this.connection[1], this.cs5, pane);
        }
    }

    protected void buildLine6(JPanel pane) {
        if (this.connection[2] != null) {
            this.buildLine(this.connection[2], this.cs6, pane);
        }
    }

    protected void buildLine7(JPanel pane) {
        if (this.connection[3] != null) {
            this.buildLine(this.connection[3], this.cs7, pane);
        }
    }

    protected void buildLine(ConnectionConfig conn, JLabel cs, JPanel pane) {
        if (conn.name().equals(JmrixConfigPane.NONE)) {
            cs.setText(" ");
            return;
        }
        log.debug("conn.name() is {} ", (Object)conn.name());
        log.debug("conn.getConnectionName() is {} ", (Object)conn.getConnectionName());
        log.debug("conn.getManufacturer() is {} ", (Object)conn.getManufacturer());
        ConnectionStatus.instance().addConnection(conn.getConnectionName(), conn.getInfo());
        cs.setFont(pane.getFont());
        this.updateLine(conn, cs);
        pane.add(cs);
    }

    protected void updateLine(ConnectionConfig conn, JLabel cs) {
        if (conn.getDisabled()) {
            return;
        }
        String name = conn.getConnectionName();
        if (name == null) {
            name = conn.getManufacturer();
        }
        if (ConnectionStatus.instance().isConnectionOk(name, conn.getInfo())) {
            cs.setForeground(Color.black);
            String cf = Bundle.getMessage("ConnectionSucceeded", name, conn.name(), conn.getInfo());
            cs.setText(cf);
        } else {
            cs.setForeground(Color.red);
            String cf = Bundle.getMessage("ConnectionFailed", name, conn.name(), conn.getInfo());
            cs.setText(cf);
        }
        this.revalidate();
    }

    protected String line8() {
        return " ";
    }

    protected String line9() {
        return Bundle.getMessage("JavaVersionCredit", System.getProperty("java.version", "<unknown>"), Locale.getDefault());
    }

    protected String logo() {
        return "resources/logo.gif";
    }

    protected JPanel statusPanel() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        log.debug("Fetch main logo: {}", (Object)this.logo());
        pane1.add(new JLabel(new ImageIcon(this.getToolkit().getImage(FileUtil.findURL(this.logo(), FileUtil.Location.ALL)), "JMRI logo"), 2));
        pane1.add(Box.createRigidArea(new Dimension(15, 0)));
        log.debug("start labels");
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BoxLayout(pane2, 1));
        pane2.add(new JLabel(this.line1()));
        pane2.add(new JLabel(this.line2()));
        pane2.add(new JLabel(this.line3()));
        String name = ProfileManager.getDefault().getActiveProfileName();
        pane2.add(new JLabel(Bundle.getMessage("ActiveProfile", name)));
        ConnectionStatus.instance().addPropertyChangeListener(this);
        int i = 0;
        for (ConnectionConfig conn : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (!conn.getDisabled()) {
                this.connection[i] = conn;
                ++i;
            }
            if (i > 3) break;
        }
        this.buildLine4(pane2);
        this.buildLine5(pane2);
        this.buildLine6(pane2);
        this.buildLine7(pane2);
        pane2.add(new JLabel(this.line8()));
        pane2.add(new JLabel(this.line9()));
        pane1.add(pane2);
        return pane1;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!InstanceManager.getDefault(ShutDownManager.class).isShuttingDown() && JOptionPane.showConfirmDialog(null, Bundle.getMessage("MessageLongCloseWarning"), Bundle.getMessage("MessageShortCloseWarning"), 0) == 0) {
            Apps.handleQuit();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    protected static void setJmriSystemProperty(String key, String value) {
        try {
            String current = System.getProperty("org.jmri.Apps." + key);
            if (current == null) {
                System.setProperty("org.jmri.Apps." + key, value);
            } else if (!current.equals(value)) {
                log.warn("JMRI property {} already set to {}, skipping reset to {}", new Object[]{key, current, value});
            }
        }
        catch (RuntimeException e) {
            log.error("Unable to set JMRI property {} to {} due to execption {}", new Object[]{key, value, e});
        }
    }

    public static JComponent buttonSpace() {
        return _buttonSpace;
    }

    protected static void splash(boolean show) {
        Apps.splash(show, false);
    }

    protected static void splash(boolean show, boolean debug) {
        Log4JUtil.initLogging();
        if (debugListener == null && debug) {
            debugFired = false;
            debugListener = e -> {
                if (!debugFired) {
                    debugmsg = true;
                    if (e.getID() == 401 && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 119) {
                        Apps.startupDebug();
                    } else {
                        debugmsg = false;
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(debugListener, 8L);
        }
        if (sp == null) {
            sp = debug ? new SplashWindow(Apps.splashDebugMsg()) : new SplashWindow();
        }
        sp.setVisible(show);
        if (!show) {
            sp.dispose();
            Toolkit.getDefaultToolkit().removeAWTEventListener(debugListener);
            debugListener = null;
            sp = null;
        }
    }

    protected static JPanel splashDebugMsg() {
        JLabel panelLabel = new JLabel(Bundle.getMessage("PressF8ToDebug"));
        panelLabel.setFont(panelLabel.getFont().deriveFont(9.0f));
        JPanel panel = new JPanel();
        panel.add(panelLabel);
        return panel;
    }

    protected static void startupDebug() {
        debugFired = true;
        debugmsg = true;
        Object[] options = new Object[]{"Disable", "Enable"};
        int retval = JOptionPane.showOptionDialog(null, "Start JMRI with Logix enabled or disabled?", "Start Up", 0, 3, null, options, options[0]);
        if (retval != 0) {
            debugmsg = false;
            return;
        }
        InstanceManager.getDefault(LogixManager.class).setLoadDisabled(true);
        log.info("Requested loading with Logixs disabled.");
        debugmsg = false;
    }

    public static boolean handleQuit() {
        return AppsBase.handleQuit();
    }

    public static boolean handleRestart() {
        return AppsBase.handleRestart();
    }

    protected static void setConfigFilename(String def, String[] args) {
        if (System.getProperty("org.jmri.Apps.configFilename") != null) {
            return;
        }
        if (args.length >= 1 && args[0] != null && !args[0].contains("=")) {
            def = args[0];
            log.debug("Config file was specified as: {}", (Object)args[0]);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] split = arg.split("=", 2);
            if (split[0].equalsIgnoreCase("config")) {
                def = split[1];
                log.debug("Config file was specified as: {}", (Object)arg);
            }
            ++n2;
        }
        configFilename = def;
        Apps.setJmriSystemProperty("configFilename", def);
    }

    public static String getConfigFileName() {
        return configFilename;
    }

    protected static void createFrame(Apps containedPane, JmriJFrame frame) {
        JFrameInterface wi = new JFrameInterface(frame);
        containedPane.menuBar = new JMenuBar();
        containedPane.createMenus(containedPane.menuBar, wi);
        containedPane.attachHelp();
        JmriPlugin.start(frame, containedPane.menuBar);
        frame.setJMenuBar(containedPane.menuBar);
        frame.getContentPane().add(containedPane);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(containedPane);
        frame.pack();
        Dimension screen = frame.getToolkit().getScreenSize();
        Dimension size = frame.getSize();
        frame.setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
        frame.setFrameLocation();
        frame.setVisible(true);
    }

    protected static void loadFile(String name) {
        ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cmOD != null) {
            URL pFile = cmOD.find(name);
            if (pFile != null) {
                try {
                    cmOD.load(pFile);
                }
                catch (JmriException e) {
                    log.error("Unhandled problem in loadFile", (Throwable)e);
                }
            } else {
                log.warn("Could not find {} config file", (Object)name);
            }
        } else {
            log.error("Failed to get default configure manager");
        }
    }

    protected static void setApplication(String name) {
        try {
            jmri.Application.setApplicationName(name);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            log.warn("Unable to set application name", (Throwable)ex);
        }
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="info message contains context information")
    protected static void setStartupInfo(String name) {
        try {
            jmri.Application.setApplicationName(name);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            log.warn("Unable to set application name", (Throwable)ex);
        }
        log.info("{}", (Object)Log4JUtil.startupInfo(name));
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        log.debug("property change: comm port status update");
        if (this.connection[0] != null) {
            this.updateLine(this.connection[0], this.cs4);
        }
        if (this.connection[1] != null) {
            this.updateLine(this.connection[1], this.cs5);
        }
        if (this.connection[2] != null) {
            this.updateLine(this.connection[2], this.cs6);
        }
        if (this.connection[3] != null) {
            this.updateLine(this.connection[3], this.cs7);
        }
    }

    protected void attachHelp() {
    }
}

