/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm;

import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jtermios.JTermios;
import jtermios.Termios;
import purejavacomm.CommDriver;
import purejavacomm.CommPort;
import purejavacomm.CommPortOwnershipListener;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.PureJavaSerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private static volatile Object m_Mutex = new Object();
    private volatile String m_PortName;
    private volatile int m_PortType;
    private volatile CommDriver m_Driver;
    private static volatile Hashtable<String, CommPortIdentifier> m_PortIdentifiers = new Hashtable();
    private static volatile Hashtable<CommPort, CommPortIdentifier> m_OpenPorts = new Hashtable();
    private static volatile Hashtable<CommPortIdentifier, String> m_Owners = new Hashtable();
    private volatile Hashtable<CommPortIdentifier, List<CommPortOwnershipListener>> m_OwnerShipListeners = new Hashtable();

    public boolean equals(Object x) {
        return x instanceof CommPortIdentifier && this.m_PortName.equals(((CommPortIdentifier)x).m_PortName);
    }

    public int hashCode() {
        return this.m_PortName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPortName(String portName, int portType, CommDriver driver) {
        Object object = m_Mutex;
        synchronized (object) {
            m_PortIdentifiers.put(portName, new CommPortIdentifier(portName, portType, driver));
        }
    }

    private CommPortIdentifier(String name, int portType, CommDriver driver) {
        this.m_PortName = name;
        this.m_PortType = portType;
        this.m_Driver = driver;
    }

    public static CommPortIdentifier getPortIdentifier(String portName) throws NoSuchPortException {
        Object object = m_Mutex;
        synchronized (object) {
            boolean ENUMERATE = false;
            for (CommPortIdentifier portid : m_OpenPorts.values()) {
                if (!portid.getName().equals(portName)) continue;
                return portid;
            }
            if (ENUMERATE) {
                Enumeration<CommPortIdentifier> e = CommPortIdentifier.getPortIdentifiers();
                while (e.hasMoreElements()) {
                    CommPortIdentifier portid;
                    portid = e.nextElement();
                    if (!portid.getName().equals(portName)) continue;
                    return portid;
                }
            } else {
                CommPortIdentifier portid = m_PortIdentifiers.get(portName);
                if (portid != null) {
                    return portid;
                }
                int fd = JTermios.open(portName, JTermios.O_RDWR | JTermios.O_NOCTTY | JTermios.O_NONBLOCK);
                if (fd != -1) {
                    if (JTermios.tcgetattr(fd, new Termios()) != -1 || JTermios.errno() != JTermios.ENOTTY) {
                        JTermios.close(fd);
                        return new CommPortIdentifier(portName, 1, null);
                    }
                    JTermios.close(fd);
                } else if (JTermios.errno() != JTermios.ENOENT) {
                    return new CommPortIdentifier(portName, 1, null);
                }
            }
            throw new NoSuchPortException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort port) throws NoSuchPortException {
        Object object = m_Mutex;
        synchronized (object) {
            CommPortIdentifier portid = m_OpenPorts.get(port);
            if (portid == null) {
                throw new NoSuchPortException();
            }
            return portid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommPort open(String appname, int timeout) throws PortInUseException {
        Object object = m_Mutex;
        synchronized (object) {
            long t0 = System.currentTimeMillis();
            String owner = m_Owners.get(this);
            if (owner != null) {
                this.fireOwnershipEvent(3);
                try {
                    while (System.currentTimeMillis() - t0 < (long)timeout) {
                        m_Mutex.wait(5L);
                        if (this.isCurrentlyOwned()) continue;
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isCurrentlyOwned()) {
                throw new PortInUseException(this.getCurrentOwner());
            }
            CommPortIdentifier info = m_PortIdentifiers.get(this.m_PortName);
            CommPort port = info != null ? info.m_Driver.getCommPort(this.m_PortName, info.m_PortType) : new PureJavaSerialPort(this.m_PortName, timeout);
            m_OpenPorts.put(port, this);
            m_Owners.put(this, appname);
            this.fireOwnershipEvent(1);
            return port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close(CommPort port) {
        Object object = m_Mutex;
        synchronized (object) {
            CommPortIdentifier portid = m_OpenPorts.remove(port);
            if (portid != null) {
                portid.fireOwnershipEvent(2);
                m_Owners.remove(portid);
            }
        }
    }

    public CommPort open(FileDescriptor fd) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("open from file descriptor not supported");
    }

    public String getName() {
        return this.m_PortName;
    }

    public int getPortType() {
        return this.m_PortType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<CommPortIdentifier> getPortIdentifiers() {
        Object object = m_Mutex;
        synchronized (object) {
            return new Enumeration(){
                List<CommPortIdentifier> m_PortIDs = new LinkedList<CommPortIdentifier>();
                Iterator<CommPortIdentifier> m_Iterator;
                {
                    for (CommPortIdentifier portid : m_PortIdentifiers.values()) {
                        this.m_PortIDs.add(portid);
                    }
                    List<String> pureports = JTermios.getPortList();
                    if (pureports != null) {
                        for (String name : pureports) {
                            this.m_PortIDs.add(new CommPortIdentifier(name, 1, null));
                        }
                    }
                    this.m_Iterator = this.m_PortIDs.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.m_Iterator != null ? this.m_Iterator.hasNext() : false;
                }

                public Object nextElement() {
                    return this.m_Iterator.next();
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentOwner() {
        Object object = m_Mutex;
        synchronized (object) {
            return m_Owners.get(this);
        }
    }

    public boolean isCurrentlyOwned() {
        return this.getCurrentOwner() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortOwnershipListener(CommPortOwnershipListener listener) {
        Object object = m_Mutex;
        synchronized (object) {
            List<CommPortOwnershipListener> list = this.m_OwnerShipListeners.get(this);
            if (list == null) {
                list = new LinkedList<CommPortOwnershipListener>();
                this.m_OwnerShipListeners.put(this, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePortOwnershipListener(CommPortOwnershipListener listener) {
        Object object = m_Mutex;
        synchronized (object) {
            List<CommPortOwnershipListener> list = this.m_OwnerShipListeners.get(this);
            if (list == null) {
                return;
            }
            list.remove(listener);
            if (list.isEmpty()) {
                this.m_OwnerShipListeners.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOwnershipEvent(int type) {
        Object object = m_Mutex;
        synchronized (object) {
            List<CommPortOwnershipListener> list = this.m_OwnerShipListeners.get(this);
            if (list == null) {
                return;
            }
            for (CommPortOwnershipListener listener : list) {
                listener.ownershipChange(type);
            }
        }
    }
}

