/*
 * Decompiled with CFR 0.152.
 */
package jtermios.testsuite;

import java.util.Iterator;
import jtermios.JTermios;
import jtermios.testsuite.TestFailedException;

public class TestBase {
    protected static volatile String m_TestPortName;
    protected static int m_Tab;
    protected static int m_Progress;
    private static volatile long m_T0;

    public static void S(int result) throws TestFailedException {
        TestBase.S(result, null);
    }

    public static void S(int result, String msg) throws TestFailedException {
        if (result == -1) {
            TestBase.fail(msg == null ? "Operation failed with errno %d" : msg + " (errno %d)", JTermios.errno());
        }
    }

    static void begin(String name) {
        System.out.printf("%-46s", name);
        m_Tab = 46;
        m_T0 = System.currentTimeMillis();
        m_Progress = 0;
    }

    protected static void sleep(int t) throws InterruptedException {
        int m = 1000;
        while (t > 0) {
            Thread.sleep(t > m ? (long)m : (long)t);
            t -= m;
            while ((System.currentTimeMillis() - m_T0) / (long)m > (long)m_Progress) {
                System.out.print(".");
                --m_Tab;
                ++m_Progress;
            }
        }
    }

    static void fail(String format, Object ... args) throws TestFailedException {
        System.out.println(" FAILED");
        System.out.println("------------------------------------------------------------");
        System.out.printf(format, args);
        System.out.println();
        System.out.println("------------------------------------------------------------");
        throw new TestFailedException();
    }

    static void finishedOK() {
        TestBase.finishedOK("", new Object[0]);
    }

    static void finishedOK(String format, Object ... args) {
        for (int i = 0; i < m_Tab; ++i) {
            System.out.print(".");
        }
        System.out.printf(" OK " + format, args);
        System.out.println();
    }

    public static void init(String[] args) {
        m_TestPortName = "cu.usbserial-FTOXM3NX";
        if (args.length > 0) {
            m_TestPortName = args[0];
        } else {
            Iterator<String> iterator = JTermios.getPortList().iterator();
            while (iterator.hasNext()) {
                String port;
                m_TestPortName = port = iterator.next();
            }
        }
    }

    public static String getPortName() {
        return m_TestPortName;
    }
}

