/*
 * Decompiled with CFR 0.152.
 */
package jtermios.testsuite;

import jtermios.JTermios;
import jtermios.Termios;
import jtermios.TimeVal;
import jtermios.testsuite.TestBase;
import jtermios.testsuite.TestFailedException;

public class JTermiosDemo {
    public static void run() throws TestFailedException {
        String port = TestBase.getPortName();
        int fd = JTermios.open(port, JTermios.O_RDWR | JTermios.O_NOCTTY | JTermios.O_NONBLOCK);
        TestBase.S(fd, "failed to open port");
        Termios opts = new Termios();
        TestBase.S(JTermios.tcgetattr(fd, opts));
        opts.c_iflag = JTermios.IGNBRK | JTermios.IGNPAR;
        opts.c_oflag = 0;
        opts.c_cflag = JTermios.CLOCAL | JTermios.CREAD | JTermios.CS8;
        opts.c_lflag = 0;
        opts.c_cc[JTermios.VMIN] = 0;
        opts.c_cc[JTermios.VTIME] = 10;
        JTermios.cfsetispeed(opts, JTermios.B9600);
        JTermios.cfsetospeed(opts, JTermios.B9600);
        TestBase.S(JTermios.tcsetattr(fd, JTermios.TCSANOW, opts));
        TestBase.S(JTermios.tcflush(fd, JTermios.TCIOFLUSH));
        String TEST_STRING = "Not so very long text string";
        byte[] tx = "Not so very long text string".getBytes();
        byte[] rx = new byte[tx.length];
        int l = tx.length;
        TestBase.S(JTermios.write(fd, tx, l), "write() failed ");
        JTermios.FDSet rdset = JTermios.newFDSet();
        JTermios.FD_ZERO(rdset);
        JTermios.FD_SET(fd, rdset);
        TimeVal tout = new TimeVal();
        tout.tv_sec = 10L;
        byte[] buffer = new byte[1024];
        while (l > 0) {
            int s = JTermios.select(fd + 1, rdset, null, null, tout);
            TestBase.S(s, "select() failed ");
            if (s == 0) {
                TestBase.fail("Timeout (no dongle connected?)", new Object[0]);
                continue;
            }
            int m = JTermios.read(fd, buffer, l);
            TestBase.S(m, "read() failed ");
            System.arraycopy(buffer, 0, rx, rx.length - l, m);
            l -= m;
        }
        if (!new String(rx).equals("Not so very long text string")) {
            TestBase.fail("Didn't receive what we expected (is \"%s\", should be \"%s\")", new String(rx), "Not so very long text string");
        }
        TestBase.S(JTermios.close(fd));
    }
}

