/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinDirection;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.exception.InvalidPinException;
import com.pi4j.io.gpio.exception.InvalidPinModeException;
import com.pi4j.io.gpio.exception.UnsupportedPinModeException;
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.GpioInterrupt;
import com.pi4j.wiringpi.GpioInterruptEvent;
import com.pi4j.wiringpi.GpioInterruptListener;
import com.pi4j.wiringpi.GpioUtil;
import com.pi4j.wiringpi.SoftPwm;
import java.util.List;

public abstract class WiringPiGpioProviderBase
extends GpioProviderBase
implements GpioProvider,
GpioInterruptListener {
    protected static short MAX_PIN_CACHE = (short)51;
    protected static short[] pinSupportedCache = new short[MAX_PIN_CACHE];
    protected static PinMode[] pinModeCache = new PinMode[MAX_PIN_CACHE];

    @Override
    public abstract String getName();

    @Override
    public boolean hasPin(Pin pin) {
        if (pinSupportedCache[pin.getAddress()] == 1) {
            return true;
        }
        if (pinSupportedCache[pin.getAddress()] == -1) {
            return false;
        }
        if (GpioUtil.isPinSupported(pin.getAddress()) > 0) {
            WiringPiGpioProviderBase.pinSupportedCache[pin.getAddress()] = 1;
            return true;
        }
        WiringPiGpioProviderBase.pinSupportedCache[pin.getAddress()] = -1;
        return false;
    }

    @Override
    public void export(Pin pin, PinMode mode) {
        this.export(pin, mode, null);
    }

    @Override
    public void export(Pin pin, PinMode mode, PinState defaultState) {
        super.export(pin, mode);
        int direction = mode.getDirection().getValue();
        if (defaultState != null && mode.getDirection() == PinDirection.OUT) {
            if (defaultState == PinState.LOW) {
                direction = 3;
            } else if (defaultState == PinState.HIGH) {
                direction = 2;
            }
        }
        if (!GpioUtil.isExported(pin.getAddress())) {
            GpioUtil.export(pin.getAddress(), direction);
        } else if (GpioUtil.getDirection(pin.getAddress()) != mode.getDirection().getValue()) {
            GpioUtil.setDirection(pin.getAddress(), direction);
        }
        this.setMode(pin, mode);
    }

    @Override
    public boolean isExported(Pin pin) {
        super.isExported(pin);
        return GpioUtil.isExported(pin.getAddress());
    }

    @Override
    public void unexport(Pin pin) {
        super.unexport(pin);
        GpioUtil.unexport(pin.getAddress());
    }

    @Override
    public void setMode(Pin pin, PinMode mode) {
        super.setMode(pin, mode);
        WiringPiGpioProviderBase.pinModeCache[pin.getAddress()] = mode;
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; pin [" + pin.getName() + "] does not support this mode.");
        }
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new UnsupportedPinModeException(pin, mode);
        }
        this.getPinCache(pin).setMode(mode);
        Gpio.pinMode(pin.getAddress(), mode.getValue());
    }

    @Override
    public PinMode getMode(Pin pin) {
        return pinModeCache[pin.getAddress()];
    }

    @Override
    public void setPullResistance(Pin pin, PinPullResistance resistance) {
        super.setPullResistance(pin, resistance);
        Gpio.pullUpDnControl(pin.getAddress(), resistance.getValue());
    }

    @Override
    public void setState(Pin pin, PinState state) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (pinModeCache[pin.getAddress()] != PinMode.DIGITAL_OUTPUT) {
            throw new InvalidPinModeException(pin, "Invalid pin mode on pin [" + pin.getName() + "]; cannot setState() when pin mode is [" + pinModeCache[pin.getAddress()].getName() + "]");
        }
        Gpio.digitalWrite(pin.getAddress(), state.getValue());
        this.dispatchPinDigitalStateChangeEvent(pin, state);
    }

    @Override
    public PinState getState(Pin pin) {
        super.getState(pin);
        PinState state = null;
        int ret = Gpio.digitalRead(pin.getAddress());
        if (ret >= 0) {
            state = PinState.getState(ret);
        }
        return state;
    }

    @Override
    public void setValue(Pin pin, double value) {
        super.setValue(pin, value);
        throw new RuntimeException("This GPIO provider does not support analog pins.");
    }

    @Override
    public double getValue(Pin pin) {
        super.getValue(pin);
        throw new RuntimeException("This GPIO provider does not support analog pins.");
    }

    @Override
    public void setPwm(Pin pin, int value) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (mode == PinMode.PWM_OUTPUT) {
            Gpio.pwmWrite(pin.getAddress(), value);
        } else if (mode == PinMode.SOFT_PWM_OUTPUT) {
            SoftPwm.softPwmWrite(pin.getAddress(), value);
        } else {
            throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; unable to setPwm(" + value + ")");
        }
        this.getPinCache(pin).setPwmValue(value);
    }

    @Override
    public void setPwmRange(Pin pin, int range) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (mode == PinMode.PWM_OUTPUT) {
            Gpio.pwmSetRange(range);
        } else if (mode == PinMode.SOFT_PWM_OUTPUT) {
            SoftPwm.softPwmStop(pin.getAddress());
            SoftPwm.softPwmCreate(pin.getAddress(), 0, range);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public int getPwm(Pin pin) {
        return super.getPwm(pin);
    }

    @Override
    public void pinStateChange(GpioInterruptEvent event) {
        for (Pin pin : this.listeners.keySet()) {
            if (pin.getAddress() != event.getPin()) continue;
            this.dispatchPinDigitalStateChangeEvent(pin, PinState.getState(event.getState()));
        }
    }

    @Override
    public void addListener(Pin pin, PinListener listener) {
        super.addListener(pin, listener);
        this.updateInterruptListener(pin);
    }

    @Override
    public void removeListener(Pin pin, PinListener listener) {
        super.removeListener(pin, listener);
        this.updateInterruptListener(pin);
    }

    protected void updateInterruptListener(Pin pin) {
        if (this.listeners.size() > 0) {
            if (!GpioInterrupt.hasListener(this)) {
                GpioInterrupt.addListener(this);
            }
            if (pinModeCache[pin.getAddress()] == PinMode.DIGITAL_INPUT) {
                if (this.listeners.containsKey(pin) && ((List)this.listeners.get(pin)).size() > 0) {
                    GpioInterrupt.enablePinStateChangeCallback(pin.getAddress());
                } else {
                    GpioInterrupt.disablePinStateChangeCallback(pin.getAddress());
                }
            }
        } else {
            GpioInterrupt.disablePinStateChangeCallback(pin.getAddress());
            if (GpioInterrupt.hasListener(this)) {
                GpioInterrupt.removeListener(this);
            }
        }
    }
}

