/*
 * Decompiled with CFR 0.152.
 */
package xAPlib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class xAPProperties {
    String DEFAULT_CONFIG_FILE = "xAPLib.cfg";
    String COPYRIGHT_NOTICE = "xAPLib for Java v.0.1 (c) Patrick Lidstone 2005, all rights reserved";
    String gUid;
    String gBroadcastIP;
    String gVendor;
    String gSource;
    String gInstance;
    String gHeartbeat;
    String gPort;

    public xAPProperties() {
        this.ReadProperties(this.DEFAULT_CONFIG_FILE);
    }

    public xAPProperties(String aConfigFilename) {
        this.ReadProperties(aConfigFilename);
    }

    private void ReadProperties(String aConfigFilename) {
        String iHomedir = System.getProperty("user.home");
        Properties iOptions = new Properties();
        File iConfigfile = new File(iHomedir, aConfigFilename);
        try {
            iOptions.load(new FileInputStream(iConfigfile));
        }
        catch (IOException e1) {
            iOptions.setProperty("uid", "FFFFFFFF");
            iOptions.setProperty("ip", "192.168.33.255");
            iOptions.setProperty("vendor", "rocket");
            iOptions.setProperty("source", "test");
            iOptions.setProperty("instance", "1");
            iOptions.setProperty("heartbeat", "60");
            iOptions.setProperty("port", "3639");
            try {
                iOptions.store(new FileOutputStream(iConfigfile), this.COPYRIGHT_NOTICE);
            }
            catch (IOException e2) {
                System.out.println("Unable to write configuration file " + iHomedir + aConfigFilename);
                System.exit(1);
            }
        }
        this.gUid = iOptions.getProperty("uid", "FFFFFFFF");
        this.gBroadcastIP = iOptions.getProperty("ip", "192.168.33.255");
        this.gVendor = iOptions.getProperty("vendor", "rocket");
        this.gSource = iOptions.getProperty("source", "test");
        this.gInstance = iOptions.getProperty("instance", "1");
        this.gHeartbeat = iOptions.getProperty("heartbeat", "60");
        this.gPort = iOptions.getProperty("port", "3639");
    }

    public String getUID() {
        return this.gUid;
    }

    public String getBroadcastIP() {
        return this.gBroadcastIP;
    }

    public String getVendor() {
        return this.gVendor;
    }

    public String getSource() {
        return this.gSource;
    }

    public String getInstance() {
        return this.gInstance;
    }

    public int getHeartbeatInterval() {
        Integer i = new Integer(this.gHeartbeat);
        return i;
    }

    public int getPort() {
        Integer i = new Integer(this.gPort);
        return i;
    }

    public String getxAPAddress() {
        return this.gVendor + "." + this.gSource + "." + this.gInstance;
    }
}

