/*
 * Decompiled with CFR 0.152.
 */
package xAPlib;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.event.EventListenerList;
import xAPlib.xAPHeartbeatMessage;
import xAPlib.xAPMessage;
import xAPlib.xAPProperties;
import xAPlib.xAPRxEvent;
import xAPlib.xAPRxEventListener;

public class xAPNetwork
extends Thread {
    private int gPort = 0;
    private int gEphemeralPortMin = 10000;
    private int gEphemeralPortMax = 30000;
    private Timer gHeartbeatTimer;
    private xAPProperties gProperties = null;
    private xAPHeartbeatMessage gHbeat = null;
    protected EventListenerList listenerList = new EventListenerList();

    public void addMyEventListener(xAPRxEventListener listener) {
        this.listenerList.add(xAPRxEventListener.class, listener);
    }

    public void removeMyEventListener(xAPRxEventListener listener) {
        this.listenerList.remove(xAPRxEventListener.class, listener);
    }

    public void fireMyEvent(xAPRxEvent aEvent, String aMessage) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != xAPRxEventListener.class) continue;
            ((xAPRxEventListener)listeners[i + 1]).myEventOccurred(aEvent, aMessage);
        }
    }

    public xAPNetwork(String aConfigurationFileName) {
        this.gProperties = new xAPProperties(aConfigurationFileName);
        this.start();
    }

    public void run() {
        int bytesToReceive = 1500;
        DatagramSocket mySocket = null;
        this.gPort = this.gProperties.getPort();
        while (true) {
            try {
                mySocket = new DatagramSocket(this.gPort);
            }
            catch (IOException e) {
                if (this.gPort == this.gProperties.getPort()) {
                    this.gPort = this.gEphemeralPortMin;
                    System.out.println("xAPNetwork: found hub active");
                    continue;
                }
                if (this.gPort < this.gEphemeralPortMax) {
                    ++this.gPort;
                    System.out.println("xAPNetwork: skipping client connection that is already in use");
                    continue;
                }
                System.out.println("xAPNetwork: exhausted all possible socket connections, but still failed to connect");
                System.exit(1);
                continue;
            }
            break;
        }
        this.gHbeat = new xAPHeartbeatMessage(this.gProperties.getUID(), this.gProperties.getxAPAddress(), this.gProperties.getHeartbeatInterval(), this.gPort);
        this.gHeartbeatTimer = new Timer();
        this.gHeartbeatTimer.schedule((TimerTask)new sendHeartbeatTask(), 0L, (long)(this.gProperties.getHeartbeatInterval() * 1000));
        while (true) {
            DatagramPacket packet = new DatagramPacket(new byte[bytesToReceive], bytesToReceive);
            try {
                mySocket.receive(packet);
            }
            catch (IOException e) {
                System.out.println("xAPNetwork: Received bad packet");
                continue;
            }
            String message = new String(packet.getData(), 0, packet.getLength());
            int packetLength = packet.getLength();
            xAPRxEvent evt = new xAPRxEvent(this);
            this.fireMyEvent(evt, message);
        }
    }

    public void sendMessage(xAPMessage aMessage) {
        this.sendMessage(aMessage.toString());
    }

    public void sendMessage(String aMessage) {
        byte[] b = null;
        try {
            b = aMessage.getBytes("8859_1");
        }
        catch (Exception e) {
            System.out.println("Failed to transcode string to byte stream");
            System.exit(1);
        }
        this.sendMessage(b);
    }

    public void sendMessage(byte[] aMessage) {
        try {
            InetAddress address = InetAddress.getByName(this.gProperties.getBroadcastIP());
            DatagramPacket packet = new DatagramPacket(aMessage, aMessage.length, address, this.gProperties.getPort());
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
        }
        catch (Exception e) {
            System.out.println("Failed to send broadcast packet");
            System.exit(1);
        }
    }

    public xAPProperties getProperties() {
        return this.gProperties;
    }

    class sendHeartbeatTask
    extends TimerTask {
        sendHeartbeatTask() {
        }

        public void run() {
            byte[] b = xAPNetwork.this.gHbeat.toBytes();
            xAPNetwork.this.sendMessage(b);
        }
    }
}

