/*
 * Decompiled with CFR 0.152.
 */
package sidlo64.translatorsHelper;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableModel;
import sidlo64.translatorsHelper.CbmLanguage;
import sidlo64.translatorsHelper.LanguageRenderer;
import sidlo64.translatorsHelper.LanguageVersion;
import sidlo64.translatorsHelper.RecordFile;
import sidlo64.translatorsHelper.TableFile;
import sidlo64.translatorsHelper.TableLanguage;

public class TranslatorsHelper
extends JFrame {
    private File startDirectory;
    private TableFile tableFile;
    private CbmLanguage cbmLanguage;
    private TableLanguage tableLanguage;
    private JFileChooser fc;
    private JButton jBopen;
    private JButton jBrun;
    private JComboBox jCBlanguage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTFstartDirectory;
    private JTextField jTFtotalKeys;
    private JTabbedPane jTabbedPane1;
    private JTable jTfiles;
    private JTable jTlanguages;
    private JToolBar jToolBar1;

    public TranslatorsHelper() {
        this.initComponents();
        URL iconURL = this.getClass().getResource("/sidlo64/translatorsHelper/jmri32x32.gif");
        ImageIcon icon = new ImageIcon(iconURL);
        this.setIconImage(icon.getImage());
        this.startDirectory = FileSystemView.getFileSystemView().getHomeDirectory();
        this.jTFstartDirectory.setText(this.startDirectory.getAbsolutePath());
        this.cbmLanguage = new CbmLanguage();
        JLabel l = new JLabel("X");
        this.jCBlanguage.setRenderer(new LanguageRenderer());
        this.jTfiles.setRowHeight(l.getPreferredSize().height);
        this.tableFile = new TableFile(this.cbmLanguage);
        this.jTfiles.setModel(this.tableFile);
        this.tableFile.setColumns(this.jTfiles);
        this.tableFile.fireTableDataChanged();
        this.jTlanguages.setRowHeight(l.getPreferredSize().height);
        this.tableLanguage = new TableLanguage(this.cbmLanguage);
        this.jTlanguages.setModel(this.tableLanguage);
        this.tableLanguage.setColumns(this.jTlanguages);
        this.tableLanguage.fireTableDataChanged();
    }

    private void initComponents() {
        this.fc = new JFileChooser();
        this.jToolBar1 = new JToolBar();
        this.jBopen = new JButton();
        this.jBrun = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jTFtotalKeys = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTlanguages = new JTable();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTfiles = new JTable();
        this.jLabel2 = new JLabel();
        this.jCBlanguage = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTFstartDirectory = new JTextField();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Translators Helper");
        this.setMinimumSize(new Dimension(600, 356));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jBopen.setIcon(new ImageIcon(this.getClass().getResource("/sidlo64/translatorsHelper/folder.png")));
        this.jBopen.setToolTipText("Open directory");
        this.jBopen.setBorderPainted(false);
        this.jBopen.setContentAreaFilled(false);
        this.jBopen.setFocusable(false);
        this.jBopen.setHorizontalTextPosition(0);
        this.jBopen.setVerticalTextPosition(3);
        this.jBopen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                TranslatorsHelper.this.jBopenMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TranslatorsHelper.this.jBopenMouseEntered(evt);
            }
        });
        this.jBopen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslatorsHelper.this.jBopenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBopen);
        this.jBrun.setIcon(new ImageIcon(this.getClass().getResource("/sidlo64/translatorsHelper/runProject.png")));
        this.jBrun.setToolTipText("Run");
        this.jBrun.setBorderPainted(false);
        this.jBrun.setContentAreaFilled(false);
        this.jBrun.setFocusable(false);
        this.jBrun.setHorizontalTextPosition(0);
        this.jBrun.setVerticalTextPosition(3);
        this.jBrun.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                TranslatorsHelper.this.jBrunMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TranslatorsHelper.this.jBrunMouseEntered(evt);
            }
        });
        this.jBrun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslatorsHelper.this.jBrunActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBrun);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        this.jTFtotalKeys.setEditable(false);
        this.jTFtotalKeys.setText("0");
        this.jLabel3.setText("Total keys:");
        this.jTlanguages.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.jTlanguages);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTFtotalKeys)).addComponent(this.jScrollPane2)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTFtotalKeys, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 335, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Languages", this.jPanel2);
        this.jTfiles.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTfiles);
        this.jLabel2.setText("Localization:");
        this.jCBlanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslatorsHelper.this.jCBlanguageActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCBlanguage, 0, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCBlanguage, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 335, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Files", this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("Pane1");
        this.jLabel1.setText("Start directory:");
        this.jTFstartDirectory.setToolTipText("Enter JMRI/java/src directory");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTFstartDirectory, -1, 355, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTFstartDirectory, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.jMenuItem1.setText("Open directory");
        this.jMenuItem1.setToolTipText("");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslatorsHelper.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.jMenuItem2.setText("Run");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslatorsHelper.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        this.jMenuItem3.setText("Exit");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslatorsHelper.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jBopenMouseEntered(MouseEvent evt) {
        this.jBopen.setContentAreaFilled(true);
    }

    private void jBopenMouseExited(MouseEvent evt) {
        this.jBopen.setContentAreaFilled(false);
    }

    private void jBrunMouseEntered(MouseEvent evt) {
        this.jBrun.setContentAreaFilled(true);
    }

    private void jBrunMouseExited(MouseEvent evt) {
        this.jBrun.setContentAreaFilled(false);
    }

    private void jBopenActionPerformed(ActionEvent evt) {
        this.openDirectory();
    }

    private void jBrunActionPerformed(ActionEvent evt) {
        this.calculation();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.openDirectory();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.calculation();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jCBlanguageActionPerformed(ActionEvent evt) {
        int idx = this.jCBlanguage.getSelectedIndex();
        if (this.tableFile != null) {
            this.tableFile.setShowLanguage(idx);
        }
    }

    public static void main(String[] args) {
        block7: {
            try {
                boolean mamLaf = false;
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"GTK+".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    mamLaf = true;
                    break;
                }
                if (mamLaf) break block7;
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(TranslatorsHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(TranslatorsHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(TranslatorsHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Logger.getLogger(TranslatorsHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TranslatorsHelper().setVisible(true);
            }
        });
    }

    private void calculation() {
        if (this.startDirectory == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.cbmLanguage.getData().clear();
            this.findLanguageVersion(this.startDirectory);
            this.cbmLanguage.sort();
            this.jCBlanguage.setModel(this.cbmLanguage);
            if (this.jCBlanguage.getItemCount() > 0) {
                this.jCBlanguage.setSelectedIndex(0);
            }
            this.tableFile = new TableFile(this.cbmLanguage);
            this.jTfiles.setModel(this.tableFile);
            this.tableFile.setColumns(this.jTfiles);
            this.tableFile.fireTableDataChanged();
            this.tableLanguage = new TableLanguage(this.cbmLanguage);
            this.jTlanguages.setModel(this.tableLanguage);
            this.tableLanguage.setColumns(this.jTlanguages);
            this.tableLanguage.fireTableDataChanged();
            this.findAllLanguageVersions(this.startDirectory);
            this.findFilesDefaultEnglish(this.startDirectory);
            this.tableFile.fireTableDataChanged();
            this.countLanguageVersions();
            this.countLanguageVersionTotal();
        }
        finally {
            this.setCursor(null);
        }
    }

    private void findLanguageVersion(File directory) {
        int i;
        File[] files = directory.listFiles();
        for (i = 0; i < files.length; ++i) {
            String language;
            int start2;
            File oneFile = files[i];
            if (!oneFile.isFile() || !oneFile.getName().endsWith(".properties")) continue;
            String name = oneFile.getAbsolutePath();
            name = name.replace(this.startDirectory.getAbsolutePath(), ".");
            name = oneFile.getName();
            boolean hasUnderscore2 = name.startsWith("_", start2 = name.length() - 17);
            if (hasUnderscore2) {
                language = name.substring(start2 + 1, start2 + 3);
                String country = name.substring(start2 + 4, start2 + 6);
                this.addVersion(new LanguageVersion(language, country));
                continue;
            }
            int start1 = name.length() - 14;
            boolean hasUnderscore1 = name.startsWith("_", start1);
            if (!hasUnderscore1) continue;
            language = name.substring(start1 + 1, start1 + 3);
            this.addVersion(new LanguageVersion(language));
        }
        for (i = 0; i < files.length; ++i) {
            File oneDirectory = files[i];
            if (!oneDirectory.isDirectory()) continue;
            this.findLanguageVersion(oneDirectory);
        }
    }

    private void findFilesDefaultEnglish(File directory) {
        int i;
        File[] files = directory.listFiles();
        for (i = 0; i < files.length; ++i) {
            int start1;
            boolean hasUnderscore1;
            int start2;
            File oneFile = files[i];
            if (!oneFile.isFile() || !oneFile.getName().endsWith(".properties")) continue;
            String wholeName = oneFile.getAbsolutePath();
            String middleName = wholeName.replace(this.startDirectory.getAbsolutePath(), ".");
            String shortName = oneFile.getName();
            boolean hasUnderscore2 = shortName.startsWith("_", start2 = shortName.length() - 17);
            if (hasUnderscore2 || (hasUnderscore1 = shortName.startsWith("_", start1 = shortName.length() - 14))) continue;
            RecordFile oneRecordFile = new RecordFile(middleName, this.cbmLanguage);
            this.tableFile.addRow(oneRecordFile);
        }
        for (i = 0; i < files.length; ++i) {
            File oneDirectory = files[i];
            if (!oneDirectory.isDirectory()) continue;
            this.findFilesDefaultEnglish(oneDirectory);
        }
    }

    private void findAllLanguageVersions(File directory) {
        int i;
        File[] files = directory.listFiles();
        for (i = 0; i < files.length; ++i) {
            String language;
            int start2;
            File oneFile = files[i];
            if (!oneFile.isFile() || !oneFile.getName().endsWith(".properties")) continue;
            String wholeName = oneFile.getAbsolutePath();
            String middleName = wholeName.replace(this.startDirectory.getAbsolutePath(), ".");
            String shortName = oneFile.getName();
            boolean hasUnderscore2 = shortName.startsWith("_", start2 = shortName.length() - 17);
            if (hasUnderscore2) {
                language = shortName.substring(start2 + 1, start2 + 3);
                String country = shortName.substring(start2 + 4, start2 + 6);
                this.addVersion(new LanguageVersion(language, country));
                continue;
            }
            int start1 = shortName.length() - 14;
            boolean hasUnderscore1 = shortName.startsWith("_", start1);
            if (!hasUnderscore1) continue;
            language = shortName.substring(start1 + 1, start1 + 3);
            this.addVersion(new LanguageVersion(language));
        }
        for (i = 0; i < files.length; ++i) {
            File oneDirectory = files[i];
            if (!oneDirectory.isDirectory()) continue;
            this.findFilesDefaultEnglish(oneDirectory);
        }
    }

    private void openDirectory() {
        this.fc.setFileSelectionMode(1);
        this.fc.setSelectedFile(this.startDirectory);
        int respVal = this.fc.showOpenDialog(this);
        if (respVal == 0) {
            this.startDirectory = this.fc.getSelectedFile();
            this.jTFstartDirectory.setText(this.startDirectory.getAbsolutePath());
        } else {
            this.startDirectory = null;
            this.jTFstartDirectory.setText("");
        }
    }

    private void addVersion(LanguageVersion version) {
        boolean found = false;
        for (LanguageVersion p : this.cbmLanguage.getData()) {
            if (!p.getLocale().getDisplayName().equals(version.getLocale().getDisplayName())) continue;
            found = true;
        }
        if (!found) {
            this.cbmLanguage.addRecord(version);
        }
    }

    private void countLanguageVersions() {
        int numberOfLanguageVersions = this.cbmLanguage.getData().size();
        for (int i = 0; i < this.tableFile.getRowCount(); ++i) {
            RecordFile recordFile = this.tableFile.getRow(i);
            String nameDefaultFile = this.startDirectory + recordFile.getFileName().substring(1);
            File file = new File(nameDefaultFile);
            try {
                FileInputStream defaultInput = new FileInputStream(file);
                Properties defaultProperties = new Properties();
                defaultProperties.load(defaultInput);
                Set<Object> defaultKeys = defaultProperties.keySet();
                int numberOfDefaultKeys = defaultKeys.size();
                recordFile.setNumberOfKeys(numberOfDefaultKeys);
                recordFile.setDefaultKeys(defaultKeys);
                for (int j = 0; j < numberOfLanguageVersions; ++j) {
                    LanguageVersion oneVersion = recordFile.getListOfLanguageVersions().getElementAt(j);
                    String suffix = oneVersion.getSuffix();
                    String nameFileVersion = nameDefaultFile.substring(0, nameDefaultFile.length() - 11) + suffix + nameDefaultFile.substring(nameDefaultFile.length() - 11, nameDefaultFile.length());
                    File fileVersion = new File(nameFileVersion);
                    try {
                        FileInputStream localeInput = new FileInputStream(fileVersion);
                        Properties localeProperties = new Properties();
                        localeProperties.load(localeInput);
                        Set<Object> localeKeys = localeProperties.keySet();
                        int numberOfVersionKeys = 0;
                        for (Object oneDefaultKeys : defaultKeys) {
                            if (!localeKeys.contains(oneDefaultKeys)) continue;
                            ++numberOfVersionKeys;
                        }
                        oneVersion.setTranslated(numberOfVersionKeys);
                        if (numberOfDefaultKeys <= 0) continue;
                        oneVersion.setPercentTranslated(100.0f * (float)numberOfVersionKeys / (float)numberOfDefaultKeys);
                        continue;
                    }
                    catch (FileNotFoundException localeInput) {
                        continue;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TranslatorsHelper.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                continue;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(TranslatorsHelper.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(TranslatorsHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void countLanguageVersionTotal() {
        int totalKeys = 0;
        for (int i = 0; i < this.tableFile.getRowCount(); ++i) {
            RecordFile recordFile = this.tableFile.getRow(i);
            totalKeys += recordFile.getNumberOfKeys();
        }
        this.jTFtotalKeys.setText(String.format("%,d", totalKeys));
        int numberOfLanguageVersions = this.cbmLanguage.getData().size();
        for (int i = 0; i < this.tableFile.getRowCount(); ++i) {
            RecordFile recordFile = this.tableFile.getRow(i);
            for (int j = 0; j < numberOfLanguageVersions; ++j) {
                LanguageVersion oneLanguageVersion = recordFile.getListOfLanguageVersions().getElementAt(j);
                Locale locale = oneLanguageVersion.getLocale();
                LanguageVersion jazykJednaMutace = this.tableLanguage.getRowLocale(locale);
                jazykJednaMutace.setTranslated(jazykJednaMutace.getTranslated() + oneLanguageVersion.getTranslated());
                jazykJednaMutace.setPercentTranslated(100.0f * (float)jazykJednaMutace.getTranslated() / (float)totalKeys);
            }
            this.tableLanguage.fireTableDataChanged();
        }
    }
}

