/*
 * Decompiled with CFR 0.152.
 */
package sidlo64.translatorsHelper;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import sidlo64.translatorsHelper.CbmLanguage;
import sidlo64.translatorsHelper.LanguageVersion;
import sidlo64.translatorsHelper.ProgressRenderer;
import sidlo64.translatorsHelper.RendererInteger;

public class TableLanguage
extends AbstractTableModel {
    private static final int COLUMN_FLAG = 0;
    private static final int COLUMN_LOCALE_NAME = 1;
    private static final int COLUMN_LANGUAGE_SUFFIX = 2;
    private static final int COLUMN_TRANSLATED = 3;
    private static final int COLUMN_PROGRESS = 4;
    private static final int COLUMN_COUNT = 5;
    private static final String TITLE_FLAG = "Flag";
    private static final String TITLE_LOCALE_NAME = "Language";
    private static final String TITLE_LANGUAGE_SUFFIX = "Suffix";
    private static final String TITLE_TRANSLATED = "Translated";
    private static final String TITLE_PROGRESS = "Progress";
    private List<LanguageVersion> data = new ArrayList<LanguageVersion>();

    public TableLanguage(CbmLanguage listOfLanguageVersion) {
        this.data = listOfLanguageVersion.getData();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LanguageVersion oneRecord = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return oneRecord.getIcon();
            }
            case 1: {
                return oneRecord.getLocale().getDisplayName();
            }
            case 2: {
                return oneRecord.getSuffix();
            }
            case 3: {
                return oneRecord.getTranslated();
            }
            case 4: {
                float floatNumber = oneRecord.getPercentTranslated();
                int integerNumber = Math.round(floatNumber);
                return integerNumber;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return TITLE_FLAG;
            }
            case 1: {
                return TITLE_LOCALE_NAME;
            }
            case 2: {
                return TITLE_LANGUAGE_SUFFIX;
            }
            case 3: {
                return TITLE_TRANSLATED;
            }
            case 4: {
                return TITLE_PROGRESS;
            }
        }
        return null;
    }

    public void addRow(LanguageVersion recordLanguageVersion) {
        this.data.add(recordLanguageVersion);
        this.fireTableDataChanged();
    }

    public LanguageVersion getRow(int row) {
        return this.data.get(row);
    }

    public LanguageVersion getRowLocale(Locale locale) {
        for (LanguageVersion oneRecord : this.data) {
            if (!oneRecord.getLocale().equals(locale)) continue;
            return oneRecord;
        }
        return null;
    }

    public void setColumns(JTable table) {
        table.getColumnModel().getColumn(0).setPreferredWidth(30);
        table.getColumnModel().getColumn(1).setPreferredWidth(500);
        table.getColumnModel().getColumn(2).setPreferredWidth(80);
        table.getColumnModel().getColumn(3).setPreferredWidth(80);
        table.getColumnModel().getColumn(4).setPreferredWidth(120);
        table.getColumnModel().getColumn(3).setCellRenderer(new RendererInteger());
        table.getColumnModel().getColumn(4).setCellRenderer(new ProgressRenderer(0, 100));
    }
}

