/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.IBMJ9Helper;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class UtilsJavaSE {
    static final boolean javaSECompiledOut = false;
    static final int javaSpecificationVersion = UtilsJavaSE.getJavaSpecificationVersion();
    static boolean java13 = false;
    static boolean java14 = false;
    static boolean detectJava5Helper = true;
    static JavaSE5Features java5Helper;
    static final boolean ibmJ9midp;
    static final boolean canCallNotLoadedNativeMethod;

    private UtilsJavaSE() {
    }

    private static boolean detectJ9midp() {
        String ibmJ9config;
        try {
            ibmJ9config = System.getProperty("com.ibm.oti.configuration");
        }
        catch (SecurityException webstart) {
            return false;
        }
        return ibmJ9config != null && ibmJ9config.indexOf("midp") != -1;
    }

    private static int getJavaSpecificationVersion() {
        try {
            String javaV = System.getProperty("java.specification.version");
            if (javaV == null || javaV.length() < 3) {
                return 0;
            }
            return Integer.valueOf(javaV.substring(2, 3));
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private static void detectJava5Helper() {
        if (java13 || ibmJ9midp || !detectJava5Helper || javaSpecificationVersion < 5) {
            return;
        }
        detectJava5Helper = false;
        try {
            Class<?> klass = Class.forName("com.intel.bluetooth.UtilsJavaSE5");
            java5Helper = (JavaSE5Features)klass.newInstance();
            DebugLog.debug("Use java 1.5+ features:", UtilsJavaSE.vmInfo());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static StackTraceLocation getLocation(Vector fqcnSet) {
        if (java13 || ibmJ9midp) {
            return null;
        }
        if (!java14) {
            try {
                Class.forName("java.lang.StackTraceElement");
                java14 = true;
                DebugLog.debug("Java 1.4+ detected:", UtilsJavaSE.vmInfo());
            }
            catch (ClassNotFoundException e) {
                java13 = true;
                return null;
            }
        }
        try {
            return UtilsJavaSE.getLocationJava14(fqcnSet);
        }
        catch (Throwable e) {
            java13 = true;
            return null;
        }
    }

    static String vmInfo() {
        try {
            return System.getProperty("java.version") + "; " + System.getProperty("java.vm.name") + "; " + System.getProperty("java.vendor");
        }
        catch (SecurityException ignore) {
            return "";
        }
    }

    private static StackTraceLocation getLocationJava14(Vector fqcnSet) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        for (int i = 0; i < ste.length - 1; ++i) {
            String nextClassName;
            if (!fqcnSet.contains(ste[i].getClassName()) || (nextClassName = ste[i + 1].getClassName()).startsWith("java.") || nextClassName.startsWith("sun.") || fqcnSet.contains(nextClassName)) continue;
            StackTraceElement st = ste[i + 1];
            StackTraceLocation loc = new StackTraceLocation();
            loc.className = st.getClassName();
            loc.methodName = st.getMethodName();
            loc.fileName = st.getFileName();
            loc.lineNumber = st.getLineNumber();
            return loc;
        }
        return null;
    }

    public static void threadSetDaemon(Thread thread) {
        try {
            if (!ibmJ9midp) {
                thread.setDaemon(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static boolean runtimeAddShutdownHook(Thread thread) {
        try {
            if (ibmJ9midp) {
                IBMJ9Helper.addShutdownClass(thread);
                return true;
            }
            Runtime.getRuntime().addShutdownHook(thread);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static void runtimeRemoveShutdownHook(Thread thread) {
        try {
            if (!ibmJ9midp) {
                Runtime.getRuntime().removeShutdownHook(thread);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void setSystemProperty(String propertyName, String propertyValue) {
        if (ibmJ9midp) {
            return;
        }
        boolean propertySet = false;
        try {
            Properties props = System.getProperties();
            if (propertyValue != null) {
                ((Hashtable)props).put(propertyName, propertyValue);
                propertySet = propertyValue.equals(System.getProperty(propertyName));
            } else {
                ((Hashtable)props).remove(propertyName);
                propertySet = System.getProperty(propertyName) == null;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (!propertySet) {
            try {
                if (propertyValue != null) {
                    System.setProperty(propertyName, propertyValue);
                } else {
                    UtilsJavaSE.detectJava5Helper();
                    if (java5Helper != null) {
                        java5Helper.clearProperty(propertyName);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Throwable initCause(Throwable throwable, Throwable cause) {
        if (!java14 || cause == null) {
            return throwable;
        }
        try {
            return throwable.initCause(cause);
        }
        catch (Throwable j9pp10) {
            return throwable;
        }
    }

    static boolean isCurrentThreadInterrupted() {
        if (ibmJ9midp) {
            return false;
        }
        return Thread.interrupted();
    }

    static Throwable getCause(PrivilegedActionException e) {
        try {
            return e.getCause();
        }
        catch (Throwable j9pp10) {
            try {
                return e.getException();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    static {
        ibmJ9midp = UtilsJavaSE.detectJ9midp();
        canCallNotLoadedNativeMethod = !ibmJ9midp;
    }

    static interface JavaSE5Features {
        public void clearProperty(String var1);
    }

    static class StackTraceLocation {
        public String className;
        public String methodName;
        public String fileName;
        public int lineNumber;

        StackTraceLocation() {
        }
    }
}

