/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DebugLog {
    private static final boolean debugCompiledOut = false;
    public static final int DEBUG = 1;
    public static final int ERROR = 4;
    private static boolean debugEnabled = false;
    private static boolean initialized = false;
    private static boolean debugInternalEnabled = false;
    private static final String FQCN = (class$com$intel$bluetooth$DebugLog == null ? (class$com$intel$bluetooth$DebugLog = DebugLog.class$("com.intel.bluetooth.DebugLog")) : class$com$intel$bluetooth$DebugLog).getName();
    private static final Vector fqcnSet = new Vector();
    private static boolean java13 = false;
    private static Vector loggerAppenders = new Vector();
    static /* synthetic */ Class class$com$intel$bluetooth$DebugLog;

    private DebugLog() {
    }

    private static synchronized void initialize() {
        boolean useStdOut;
        if (initialized) {
            return;
        }
        initialized = true;
        debugEnabled = BlueCoveImpl.getConfigProperty("bluecove.debug", false);
        if (debugEnabled) {
            // empty if block
        }
        debugInternalEnabled = (useStdOut = BlueCoveImpl.getConfigProperty("bluecove.debug.stdout", true)) && debugEnabled;
        boolean useLog4j = BlueCoveImpl.getConfigProperty("bluecove.debug.log4j", true);
        if (useLog4j) {
            try {
                LoggerAppenderExt log4jAppender = (LoggerAppenderExt)Class.forName("com.intel.bluetooth.DebugLog4jAppender").newInstance();
                System.out.println("BlueCove log redirected to log4j");
                DebugLog.addAppender(log4jAppender);
                if (log4jAppender.isLogEnabled(1)) {
                    debugEnabled = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isDebugEnabled() {
        if (!initialized) {
            DebugLog.initialize();
        }
        return debugEnabled;
    }

    public static void setDebugEnabled(boolean debugEnabled) {
        if (!initialized) {
            DebugLog.initialize();
        }
        if (debugEnabled) {
            // empty if block
        }
        BlueCoveImpl.instance().enableNativeDebug(debugEnabled);
        debugInternalEnabled = DebugLog.debugEnabled = debugEnabled;
    }

    public static void debug(String message) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, null, null);
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message, null);
        }
    }

    public static void debug(String message, String v) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " ", v);
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + " " + v, null);
        }
    }

    public static void debug(String message, Throwable t) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " ", t.toString());
            DebugLog.printLocation();
            if (!UtilsJavaSE.ibmJ9midp) {
                t.printStackTrace(System.out);
            } else if (debugInternalEnabled) {
                t.printStackTrace();
            }
            DebugLog.callAppenders(1, message, t);
        }
    }

    public static void debug(String message, Object obj) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " ", obj.toString());
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + " " + obj.toString(), null);
        }
    }

    public static void debug(String message, String v, String v2) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " ", v + " " + v2);
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + " " + v + " " + v2, null);
        }
    }

    public static void debug(String message, long v) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " ", Long.toString(v));
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + " " + Long.toString(v), null);
        }
    }

    public static void debug0x(String message, long v) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " 0x", Utils.toHexString(v));
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + " 0x" + Utils.toHexString(v), null);
        }
    }

    public static void debug0x(String message, String s, long v) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " " + s + " 0x", Utils.toHexString(v));
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + " " + s + " 0x" + Utils.toHexString(v), null);
        }
    }

    public static void debug(String message, boolean v) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, " ", String.valueOf(v));
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + " " + v, null);
        }
    }

    public static void debug(String message, byte[] data) {
        DebugLog.debug(message, data, 0, data == null ? 0 : data.length);
    }

    public static void debug(String message, byte[] data, int off, int len) {
        if (DebugLog.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            if (data == null) {
                buf.append(" null byte[]");
            } else {
                buf.append(" [");
                for (int i = off; i < off + len; ++i) {
                    if (i != off) {
                        buf.append(", ");
                    }
                    buf.append(new Byte(data[i]).toString());
                }
                buf.append("]");
                if (len > 4) {
                    buf.append(" ").append(len);
                }
            }
            DebugLog.log(message, buf.toString(), null);
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + buf.toString(), null);
        }
    }

    public static void debug(String message, int[] data) {
        DebugLog.debug(message, data, 0, data == null ? 0 : data.length);
    }

    public static void debug(String message, int[] data, int off, int len) {
        if (DebugLog.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            if (data == null) {
                buf.append(" null int[]");
            } else {
                buf.append(" [");
                for (int i = off; i < off + len; ++i) {
                    if (i != off) {
                        buf.append(", ");
                    }
                    buf.append(Integer.toString(data[i]));
                }
                buf.append("]");
                if (len > 4) {
                    buf.append(" ").append(len);
                }
            }
            DebugLog.log(message, buf.toString(), null);
            DebugLog.printLocation();
            DebugLog.callAppenders(1, message + buf.toString(), null);
        }
    }

    public static void nativeDebugCallback(String fileName, int lineN, String message) {
        try {
            if (fileName != null && fileName.startsWith(".\\")) {
                fileName = fileName.substring(2);
            }
            DebugLog.debugNative(fileName + ":" + lineN, message);
        }
        catch (Throwable e) {
            try {
                System.out.println("Error when calling debug " + e);
            }
            catch (Throwable e2) {
                // empty catch block
            }
        }
    }

    public static void debugNative(String location, String message) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log(message, "\n\t  ", location);
            DebugLog.callAppenders(1, message, null);
        }
    }

    public static void error(String message) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log("error ", message, null);
            DebugLog.printLocation();
            DebugLog.callAppenders(4, message, null);
        }
    }

    public static void error(String message, long v) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log("error ", message, " " + v);
            DebugLog.printLocation();
            DebugLog.callAppenders(4, message + " " + v, null);
        }
    }

    public static void error(String message, String v) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log("error ", message, " " + v);
            DebugLog.printLocation();
            DebugLog.callAppenders(4, message + " " + v, null);
        }
    }

    public static void error(String message, Throwable t) {
        if (DebugLog.isDebugEnabled()) {
            DebugLog.log("error ", message, " " + t);
            DebugLog.printLocation();
            if (!UtilsJavaSE.ibmJ9midp) {
                t.printStackTrace(System.out);
            } else if (debugInternalEnabled) {
                t.printStackTrace();
            }
            DebugLog.callAppenders(4, message, t);
        }
    }

    public static void fatal(String message) {
        DebugLog.log("error ", message, null);
        DebugLog.printLocation();
        DebugLog.callAppenders(4, message, null);
    }

    public static void fatal(String message, Throwable t) {
        DebugLog.log("error ", message, " " + t);
        DebugLog.printLocation();
        if (!UtilsJavaSE.ibmJ9midp) {
            t.printStackTrace(System.out);
        } else if (debugInternalEnabled) {
            t.printStackTrace();
        }
        DebugLog.callAppenders(4, message, t);
    }

    private static void callAppenders(int level, String message, Throwable throwable) {
        Enumeration iter = loggerAppenders.elements();
        while (iter.hasMoreElements()) {
            LoggerAppender a = (LoggerAppender)iter.nextElement();
            a.appendLog(level, message, throwable);
        }
    }

    public static void addAppender(LoggerAppender newAppender) {
        loggerAppenders.addElement(newAppender);
    }

    public static void removeAppender(LoggerAppender newAppender) {
        loggerAppenders.removeElement(newAppender);
    }

    private static String d00(int i) {
        if (i > 9) {
            return String.valueOf(i);
        }
        return "0" + String.valueOf(i);
    }

    private static String d000(int i) {
        if (i > 99) {
            return String.valueOf(i);
        }
        if (i > 9) {
            return "0" + String.valueOf(i);
        }
        return "00" + String.valueOf(i);
    }

    private static void log(String message, String va1, String va2) {
        if (!debugInternalEnabled) {
            return;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(System.currentTimeMillis()));
            StringBuffer sb = new StringBuffer();
            sb.append(DebugLog.d00(calendar.get(11))).append(":");
            sb.append(DebugLog.d00(calendar.get(12))).append(":");
            sb.append(DebugLog.d00(calendar.get(13))).append(".");
            sb.append(DebugLog.d000(calendar.get(14))).append(" ");
            sb.append(message);
            if (va1 != null) {
                sb.append(va1);
            }
            if (va2 != null) {
                sb.append(va2);
            }
            System.out.println(sb.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void printLocation() {
        if (java13 || !debugInternalEnabled) {
            return;
        }
        try {
            UtilsJavaSE.StackTraceLocation ste = UtilsJavaSE.getLocation(fqcnSet);
            if (ste != null) {
                System.out.println("\t  " + DebugLog.formatLocation(ste));
            }
        }
        catch (Throwable e) {
            java13 = true;
        }
    }

    private static String formatLocation(UtilsJavaSE.StackTraceLocation ste) {
        if (ste == null) {
            return "";
        }
        return ste.className + "." + ste.methodName + "(" + ste.fileName + ":" + ste.lineNumber + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fqcnSet.addElement(FQCN);
    }

    public static interface LoggerAppenderExt
    extends LoggerAppender {
        public boolean isLogEnabled(int var1);
    }

    public static interface LoggerAppender {
        public void appendLog(int var1, String var2, Throwable var3);
    }
}

