/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveConfigProperties;
import com.intel.bluetooth.BluetoothConnectionNotifierBase;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.BluetoothStackBlueSoleil;
import com.intel.bluetooth.BluetoothStackMicrosoft;
import com.intel.bluetooth.BluetoothStackOSX;
import com.intel.bluetooth.BluetoothStackToshiba;
import com.intel.bluetooth.BluetoothStackWIDCOMM;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.NativeLibLoader;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.ThreadLocalWrapper;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import com.intel.bluetooth.UtilsStringTokenizer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;

public class BlueCoveImpl {
    public static final String BLUETOOTH_API_VERSION = "1.1.1";
    public static final String OBEX_API_VERSION = "1.1.1";
    public static final int versionMajor1 = 2;
    public static final int versionMajor2 = 1;
    public static final int versionMinor = 1;
    public static final int versionBuild = 0;
    public static final String versionSufix = "-SNAPSHOT";
    public static final String version = String.valueOf(2) + "." + String.valueOf(1) + "." + String.valueOf(1) + "-SNAPSHOT";
    public static final int nativeLibraryVersionExpected = 2010100;
    public static final String STACK_WINSOCK = "winsock";
    public static final String STACK_WIDCOMM = "widcomm";
    public static final String STACK_BLUESOLEIL = "bluesoleil";
    public static final String STACK_TOSHIBA = "toshiba";
    public static final String STACK_BLUEZ = "bluez";
    public static final String STACK_BLUEZ_DBUS = "bluez-dbus";
    public static final String STACK_OSX = "mac";
    public static final String STACK_EMULATOR = "emulator";
    public static final String STACK_ANDROID_2_X = "android_2.x";
    private static final boolean oneDLLbuild = false;
    public static final String NATIVE_LIB_MS = "intelbth";
    public static final String NATIVE_LIB_WIDCOMM = "bluecove";
    public static final String NATIVE_LIB_TOSHIBA = "bluecove";
    public static final String NATIVE_LIB_BLUEZ = "bluecove";
    public static final String NATIVE_LIB_OSX = "bluecove";
    public static final String NATIVE_LIB_BLUESOLEIL = "intelbth";
    static final int BLUECOVE_STACK_DETECT_MICROSOFT = 1;
    static final int BLUECOVE_STACK_DETECT_WIDCOMM = 2;
    static final int BLUECOVE_STACK_DETECT_BLUESOLEIL = 4;
    static final int BLUECOVE_STACK_DETECT_TOSHIBA = 8;
    static final int BLUECOVE_STACK_DETECT_OSX = 16;
    public static final int BLUECOVE_STACK_DETECT_BLUEZ = 32;
    public static final int BLUECOVE_STACK_DETECT_EMULATOR = 64;
    public static final int BLUECOVE_STACK_DETECT_BLUEZ_DBUS = 128;
    public static final int BLUECOVE_STACK_DETECT_ANDROID_1_X = 256;
    public static final int BLUECOVE_STACK_DETECT_ANDROID_2_X = 512;
    static final String TRUE = "true";
    static final String FALSE = "false";
    private static final String FQCN = (class$com$intel$bluetooth$BlueCoveImpl == null ? (class$com$intel$bluetooth$BlueCoveImpl = BlueCoveImpl.class$("com.intel.bluetooth.BlueCoveImpl")) : class$com$intel$bluetooth$BlueCoveImpl).getName();
    private static final Vector fqcnSet = new Vector();
    private Object accessControlContext;
    private static ShutdownHookThread shutdownHookRegistered;
    private static BlueCoveImpl instance;
    private static BluetoothStackHolder singleStack;
    private static ThreadLocalWrapper threadStack;
    private static BluetoothStackHolder threadStackIDDefault;
    private static Hashtable resourceConfigProperties;
    private static Hashtable stacks;
    private static Vector initializationProperties;
    static /* synthetic */ Class class$com$intel$bluetooth$BlueCoveImpl;
    static /* synthetic */ Class class$com$intel$bluetooth$DebugLog;

    public static synchronized BlueCoveImpl instance() {
        if (instance == null) {
            instance = new BlueCoveImpl();
        }
        return instance;
    }

    private BlueCoveImpl() {
        try {
            this.accessControlContext = AccessController.getContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DebugLog.isDebugEnabled();
        this.copySystemProperties(null);
    }

    static int getNativeLibraryVersion() {
        return 2010100;
    }

    private synchronized void createShutdownHook() {
        if (shutdownHookRegistered != null) {
            return;
        }
        AsynchronousShutdownThread shutdownHookThread = new AsynchronousShutdownThread();
        shutdownHookRegistered = new ShutdownHookThread(shutdownHookThread);
        if (UtilsJavaSE.runtimeAddShutdownHook(shutdownHookRegistered)) {
            UtilsJavaSE.threadSetDaemon(shutdownHookThread);
            shutdownHookThread.start();
        }
    }

    private int getStackId(String stack) {
        if (STACK_WIDCOMM.equalsIgnoreCase(stack)) {
            return 2;
        }
        if (STACK_BLUESOLEIL.equalsIgnoreCase(stack)) {
            return 4;
        }
        if (STACK_TOSHIBA.equalsIgnoreCase(stack)) {
            return 8;
        }
        if (STACK_WINSOCK.equalsIgnoreCase(stack)) {
            return 1;
        }
        if (STACK_BLUEZ.equalsIgnoreCase(stack)) {
            return 32;
        }
        if (STACK_BLUEZ_DBUS.equalsIgnoreCase(stack)) {
            return 128;
        }
        if (STACK_WINSOCK.equalsIgnoreCase(stack)) {
            return 16;
        }
        if (STACK_EMULATOR.equalsIgnoreCase(stack)) {
            return 64;
        }
        return 0;
    }

    private Class loadStackClass(String classPropertyName, String classNamesDefault) throws BluetoothStateException {
        String classNames = BlueCoveImpl.getConfigProperty(classPropertyName);
        if (classNames == null) {
            classNames = classNamesDefault;
        }
        UtilsStringTokenizer tok = new UtilsStringTokenizer(classNames, "|");
        while (tok.hasMoreTokens()) {
            String className = tok.nextToken();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                DebugLog.error(className, e);
            }
        }
        throw new BluetoothStateException("BlueCove " + classNames + " not available");
    }

    private BluetoothStack newStackInstance(Class ctackClass) throws BluetoothStateException {
        String className = ctackClass.getName();
        try {
            return (BluetoothStack)ctackClass.newInstance();
        }
        catch (InstantiationException e) {
            DebugLog.error(className, e);
        }
        catch (IllegalAccessException e) {
            DebugLog.error(className, e);
        }
        throw new BluetoothStateException("BlueCove " + className + " can't instantiate");
    }

    private BluetoothStack loadStack(String classPropertyName, String classNameDefault) throws BluetoothStateException {
        return this.newStackInstance(this.loadStackClass(classPropertyName, classNameDefault));
    }

    static void loadNativeLibraries(BluetoothStack stack) throws BluetoothStateException {
        try {
            if (UtilsJavaSE.canCallNotLoadedNativeMethod && stack.isNativeCodeLoaded()) {
                return;
            }
        }
        catch (Error e) {
            // empty catch block
        }
        BluetoothStack.LibraryInformation[] libs = stack.requireNativeLibraries();
        if (libs == null || libs.length == 0) {
            return;
        }
        for (int i = 0; i < libs.length; ++i) {
            Class<?> c = libs[i].stackClass;
            if (c == null) {
                c = stack.getClass();
            }
            if (NativeLibLoader.isAvailable(libs[i].libraryName, c, libs[i].required)) continue;
            if (libs[i].required) {
                throw new BluetoothStateException("BlueCove library " + libs[i].libraryName + " not available;" + NativeLibLoader.getLoadErrors(libs[i].libraryName));
            }
            DebugLog.debug("library " + libs[i].libraryName + " not available");
        }
    }

    private static boolean isNativeLibrariesAvailable(BluetoothStack stack) {
        try {
            if (UtilsJavaSE.canCallNotLoadedNativeMethod) {
                return stack.isNativeCodeLoaded();
            }
        }
        catch (Error e) {
            // empty catch block
        }
        BluetoothStack.LibraryInformation[] libs = stack.requireNativeLibraries();
        if (libs == null || libs.length == 0) {
            return true;
        }
        for (int i = 0; i < libs.length; ++i) {
            Class<?> c = libs[i].stackClass;
            if (c == null) {
                c = stack.getClass();
            }
            if (NativeLibLoader.isAvailable(libs[i].libraryName, c)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BluetoothStack detectStack() throws BluetoothStateException {
        String stackSelected;
        BluetoothStack detectorStack;
        block18: {
            block19: {
                int aval;
                block22: {
                    block21: {
                        block20: {
                            detectorStack = null;
                            String stackFirstDetector = BlueCoveImpl.getConfigProperty("bluecove.stack.first");
                            stackSelected = BlueCoveImpl.getConfigProperty("bluecove.stack");
                            if (stackFirstDetector == null) {
                                stackFirstDetector = stackSelected;
                            }
                            if (STACK_EMULATOR.equals(stackSelected)) {
                                detectorStack = this.loadStack("bluecove.emulator.class", "com.intel.bluetooth.BluetoothEmulator");
                            } else {
                                switch (NativeLibLoader.getOS()) {
                                    case 1: 
                                    case 5: {
                                        Class stackClass = this.loadStackClass("bluecove.bluez.class", "com.intel.bluetooth.BluetoothStackBlueZ|com.intel.bluetooth.BluetoothStackBlueZDBus");
                                        detectorStack = this.newStackInstance(stackClass);
                                        BlueCoveImpl.loadNativeLibraries(detectorStack);
                                        stackSelected = detectorStack.getStackID();
                                        break;
                                    }
                                    case 6: {
                                        String androidBluetoothStack = "com.intel.bluetooth.BluetoothStackAndroid";
                                        try {
                                            Class<?> androidStackClass = Class.forName(androidBluetoothStack);
                                            detectorStack = this.newStackInstance(androidStackClass);
                                            stackSelected = detectorStack.getStackID();
                                            break;
                                        }
                                        catch (ClassNotFoundException ex) {
                                            throw new BluetoothStateException("BlueCove " + androidBluetoothStack + " not available");
                                        }
                                    }
                                    case 4: {
                                        detectorStack = new BluetoothStackOSX();
                                        BlueCoveImpl.loadNativeLibraries(detectorStack);
                                        stackSelected = detectorStack.getStackID();
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        detectorStack = this.createDetectorOnWindows(stackFirstDetector);
                                        if (!DebugLog.isDebugEnabled()) break;
                                        detectorStack.enableNativeDebug(class$com$intel$bluetooth$DebugLog == null ? (class$com$intel$bluetooth$DebugLog = BlueCoveImpl.class$("com.intel.bluetooth.DebugLog")) : class$com$intel$bluetooth$DebugLog, true);
                                        break;
                                    }
                                    default: {
                                        throw new BluetoothStateException("BlueCove not available");
                                    }
                                }
                            }
                            int libraryVersion = detectorStack.getLibraryVersion();
                            if (2010100 != libraryVersion) {
                                DebugLog.fatal("BlueCove native library version mismatch " + libraryVersion + " expected " + 2010100);
                                throw new BluetoothStateException("BlueCove native library version mismatch");
                            }
                            if (stackSelected != null) break block19;
                            aval = detectorStack.detectBluetoothStack();
                            DebugLog.debug("BluetoothStack detected", aval);
                            int detectorID = this.getStackId(detectorStack.getStackID());
                            if ((aval & detectorID) == 0) break block20;
                            stackSelected = detectorStack.getStackID();
                            break block18;
                        }
                        if ((aval & 1) == 0) break block21;
                        stackSelected = STACK_WINSOCK;
                        break block18;
                    }
                    if ((aval & 2) == 0) break block22;
                    stackSelected = STACK_WIDCOMM;
                    break block18;
                }
                if ((aval & 4) != 0) {
                    stackSelected = STACK_BLUESOLEIL;
                    break block18;
                } else if ((aval & 8) != 0) {
                    stackSelected = STACK_TOSHIBA;
                    break block18;
                } else {
                    if ((aval & 0x10) == 0) {
                        DebugLog.fatal("BluetoothStack not detected");
                        throw new BluetoothStateException("BluetoothStack not detected");
                    }
                    stackSelected = STACK_OSX;
                }
                break block18;
            }
            DebugLog.debug("BluetoothStack selected", stackSelected);
        }
        BluetoothStack stack = this.setBluetoothStack(stackSelected, detectorStack);
        stackSelected = stack.getStackID();
        this.copySystemProperties(stack);
        if (!stackSelected.equals(STACK_EMULATOR)) {
            System.out.println("BlueCove version " + version + " on " + stackSelected);
        }
        return stack;
    }

    public static Vector getLocalDevicesID() throws BluetoothStateException {
        Vector<String> v = new Vector<String>();
        String ids = BluetoothStackHolder.getBluetoothStack().getLocalDeviceProperty("bluecove.local_devices_ids");
        if (ids != null) {
            UtilsStringTokenizer tok = new UtilsStringTokenizer(ids, ",");
            while (tok.hasMoreTokens()) {
                v.addElement(tok.nextToken());
            }
        }
        return v;
    }

    public static synchronized void useThreadLocalBluetoothStack() {
        BluetoothStackHolder s;
        if (threadStack == null) {
            threadStack = new ThreadLocalWrapper();
        }
        if ((s = (BluetoothStackHolder)threadStack.get()) == null) {
            if (singleStack != null) {
                s = singleStack;
                singleStack = null;
            } else {
                s = new BluetoothStackHolder();
            }
            threadStack.set(s);
        }
    }

    public static synchronized Object getThreadBluetoothStackID() throws BluetoothStateException {
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BluetoothStackHolder.getBluetoothStack();
        return threadStack.get();
    }

    public static synchronized Object getCurrentThreadBluetoothStackID() {
        if (threadStack == null) {
            return null;
        }
        return threadStack.get();
    }

    public static synchronized void setThreadBluetoothStackID(Object stackID) {
        if (stackID != null && !(stackID instanceof BluetoothStackHolder)) {
            throw new IllegalArgumentException("stackID is not valid");
        }
        if (threadStack == null) {
            throw new IllegalArgumentException("ThreadLocal configuration is not initialized");
        }
        threadStack.set(stackID);
    }

    public static synchronized void releaseThreadBluetoothStack() {
        if (threadStack == null) {
            throw new IllegalArgumentException("ThreadLocal configuration is not initialized");
        }
        threadStack.set(null);
    }

    public static synchronized void setDefaultThreadBluetoothStackID(Object stackID) {
        if (stackID != null && !(stackID instanceof BluetoothStackHolder)) {
            throw new IllegalArgumentException("stackID is not valid");
        }
        if (threadStack == null) {
            throw new IllegalArgumentException("ThreadLocal configuration is not initialized");
        }
        threadStackIDDefault = (BluetoothStackHolder)stackID;
    }

    static synchronized void setThreadBluetoothStack(BluetoothStack bluetoothStack) {
        if (threadStack == null) {
            return;
        }
        BluetoothStackHolder s = (BluetoothStackHolder)threadStack.get();
        if (s != null && s.bluetoothStack == bluetoothStack) {
            return;
        }
        BluetoothStackHolder sh = (BluetoothStackHolder)stacks.get(bluetoothStack);
        if (sh == null) {
            throw new RuntimeException("ThreadLocal not found for BluetoothStack");
        }
        threadStack.set(sh);
    }

    public static synchronized void shutdownThreadBluetoothStack() {
        if (threadStack == null) {
            return;
        }
        BluetoothStackHolder s = (BluetoothStackHolder)threadStack.get();
        if (s == null) {
            return;
        }
        if (threadStackIDDefault == s) {
            threadStackIDDefault = null;
        }
        s.configProperties.clear();
        if (s.bluetoothStack != null) {
            BluetoothConnectionNotifierBase.shutdownConnections(s.bluetoothStack);
            RemoteDeviceHelper.shutdownConnections(s.bluetoothStack);
            s.bluetoothStack.destroy();
            stacks.remove(s.bluetoothStack);
            s.bluetoothStack = null;
        }
    }

    public static synchronized void shutdown() {
        Enumeration en = stacks.elements();
        while (en.hasMoreElements()) {
            BluetoothStackHolder s = (BluetoothStackHolder)en.nextElement();
            s.configProperties.clear();
            if (s.bluetoothStack == null) continue;
            BluetoothConnectionNotifierBase.shutdownConnections(s.bluetoothStack);
            RemoteDeviceHelper.shutdownConnections(s.bluetoothStack);
            try {
                s.bluetoothStack.destroy();
            }
            finally {
                s.bluetoothStack = null;
            }
        }
        stacks.clear();
        singleStack = null;
        threadStackIDDefault = null;
        if (shutdownHookRegistered != null) {
            shutdownHookRegistered.deRegister();
        }
        BlueCoveImpl.clearSystemProperties();
    }

    public static void setConfigProperty(String name, String value) {
        BlueCoveImpl.setConfigObject(name, value);
    }

    public static void setConfigObject(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("key is null");
        }
        BluetoothStackHolder sh = BlueCoveImpl.currentStackHolder(true);
        if (sh.bluetoothStack != null && initializationProperties.contains(name)) {
            throw new IllegalArgumentException("BlueCove Stack already initialized");
        }
        if (value == null) {
            sh.configProperties.remove(name);
        } else {
            sh.configProperties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getConfigObject(String key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        String value = null;
        BluetoothStackHolder sh = BlueCoveImpl.currentStackHolder(false);
        if (sh != null) {
            value = (String)sh.configProperties.get(key);
        }
        if (value == null) {
            try {
                value = System.getProperty(key);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (value == null) {
            Hashtable hashtable = resourceConfigProperties;
            synchronized (hashtable) {
                Object casheValue = resourceConfigProperties.get(key);
                if (casheValue != null) {
                    if (casheValue instanceof String) {
                        value = (String)casheValue;
                    }
                } else {
                    value = Utils.getResourceProperty(class$com$intel$bluetooth$BlueCoveImpl == null ? (class$com$intel$bluetooth$BlueCoveImpl = BlueCoveImpl.class$("com.intel.bluetooth.BlueCoveImpl")) : class$com$intel$bluetooth$BlueCoveImpl, key);
                    if (value == null) {
                        resourceConfigProperties.put(key, new Object());
                    } else {
                        resourceConfigProperties.put(key, value);
                    }
                }
            }
        }
        return value;
    }

    public static String getConfigProperty(String key) {
        return (String)BlueCoveImpl.getConfigObject(key);
    }

    public static boolean getConfigProperty(String key, boolean defaultValue) {
        String value = BlueCoveImpl.getConfigProperty(key);
        if (value != null) {
            return TRUE.equals(value) || "1".equals(value);
        }
        return defaultValue;
    }

    static int getConfigProperty(String key, int defaultValue) {
        String value = BlueCoveImpl.getConfigProperty(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    static String[] getSystemPropertiesList() {
        String[] p = new String[]{"bluetooth.master.switch", "bluetooth.sd.attr.retrievable.max", "bluetooth.connected.devices.max", "bluetooth.l2cap.receiveMTU.max", "bluetooth.sd.trans.max", "bluetooth.connected.inquiry.scan", "bluetooth.connected.page.scan", "bluetooth.connected.inquiry", "bluetooth.connected.page"};
        return p;
    }

    static void clearSystemProperties() {
        UtilsJavaSE.setSystemProperty("bluetooth.api.version", null);
        UtilsJavaSE.setSystemProperty("obex.api.version", null);
        String[] property = BlueCoveImpl.getSystemPropertiesList();
        for (int i = 0; i < property.length; ++i) {
            UtilsJavaSE.setSystemProperty(property[i], null);
        }
    }

    void copySystemProperties(BluetoothStack bluetoothStack) {
        UtilsJavaSE.setSystemProperty("bluetooth.api.version", "1.1.1");
        UtilsJavaSE.setSystemProperty("obex.api.version", "1.1.1");
        if (bluetoothStack != null) {
            String[] property = BlueCoveImpl.getSystemPropertiesList();
            for (int i = 0; i < property.length; ++i) {
                UtilsJavaSE.setSystemProperty(property[i], bluetoothStack.getLocalDeviceProperty(property[i]));
            }
        }
    }

    public String getLocalDeviceFeature(int featureID) throws BluetoothStateException {
        return (BluetoothStackHolder.getBluetoothStack().getFeatureSet() & featureID) != 0 ? TRUE : FALSE;
    }

    private BluetoothStack createDetectorOnWindows(String stackFirst) throws BluetoothStateException {
        BluetoothStack stack;
        if (stackFirst != null) {
            BluetoothStack detectorStack;
            DebugLog.debug("detector stack", stackFirst);
            if (STACK_WIDCOMM.equalsIgnoreCase(stackFirst)) {
                detectorStack = new BluetoothStackWIDCOMM();
                if (BlueCoveImpl.isNativeLibrariesAvailable(detectorStack)) {
                    return detectorStack;
                }
            } else if (STACK_BLUESOLEIL.equalsIgnoreCase(stackFirst)) {
                detectorStack = new BluetoothStackBlueSoleil();
                if (BlueCoveImpl.isNativeLibrariesAvailable(detectorStack)) {
                    return detectorStack;
                }
            } else if (STACK_WINSOCK.equalsIgnoreCase(stackFirst)) {
                detectorStack = new BluetoothStackMicrosoft();
                if (BlueCoveImpl.isNativeLibrariesAvailable(detectorStack)) {
                    return detectorStack;
                }
            } else if (STACK_TOSHIBA.equalsIgnoreCase(stackFirst)) {
                detectorStack = new BluetoothStackToshiba();
                if (BlueCoveImpl.isNativeLibrariesAvailable(detectorStack)) {
                    return detectorStack;
                }
            } else {
                throw new IllegalArgumentException("Invalid BlueCove detector stack [" + stackFirst + "]");
            }
        }
        if (BlueCoveImpl.isNativeLibrariesAvailable(stack = new BluetoothStackMicrosoft())) {
            return stack;
        }
        stack = new BluetoothStackWIDCOMM();
        if (BlueCoveImpl.isNativeLibrariesAvailable(stack)) {
            return stack;
        }
        throw new BluetoothStateException("BlueCove libraries not available");
    }

    public String setBluetoothStack(String stack) throws BluetoothStateException {
        return this.setBluetoothStack(stack, null).getStackID();
    }

    private synchronized BluetoothStack setBluetoothStack(String stack, BluetoothStack detectorStack) throws BluetoothStateException {
        BluetoothStackHolder s;
        if (singleStack != null) {
            if (singleStack.bluetoothStack != null) {
                singleStack.bluetoothStack.destroy();
                stacks.remove(singleStack.bluetoothStack);
                singleStack.bluetoothStack = null;
            }
        } else if (threadStack != null && (s = (BluetoothStackHolder)threadStack.get()) != null && s.bluetoothStack != null) {
            s.bluetoothStack.destroy();
            stacks.remove(s.bluetoothStack);
            s.bluetoothStack = null;
        }
        BluetoothStack newStack = detectorStack != null && detectorStack.getStackID().equalsIgnoreCase(stack) ? detectorStack : (STACK_WIDCOMM.equalsIgnoreCase(stack) ? new BluetoothStackWIDCOMM() : (STACK_BLUESOLEIL.equalsIgnoreCase(stack) ? new BluetoothStackBlueSoleil() : (STACK_TOSHIBA.equalsIgnoreCase(stack) ? new BluetoothStackToshiba() : new BluetoothStackMicrosoft())));
        BlueCoveImpl.loadNativeLibraries(newStack);
        int libraryVersion = newStack.getLibraryVersion();
        if (2010100 != libraryVersion) {
            DebugLog.fatal("BlueCove native library version mismatch " + libraryVersion + " expected " + 2010100);
            throw new BluetoothStateException("BlueCove native library version mismatch");
        }
        if (DebugLog.isDebugEnabled()) {
            newStack.enableNativeDebug(class$com$intel$bluetooth$DebugLog == null ? (class$com$intel$bluetooth$DebugLog = BlueCoveImpl.class$("com.intel.bluetooth.DebugLog")) : class$com$intel$bluetooth$DebugLog, true);
        }
        newStack.initialize();
        this.createShutdownHook();
        BluetoothStackHolder sh = BlueCoveImpl.currentStackHolder(true);
        sh.bluetoothStack = newStack;
        stacks.put(newStack, sh);
        if (threadStack != null) {
            threadStack.set(sh);
        }
        return newStack;
    }

    public void enableNativeDebug(boolean on) {
        BluetoothStackHolder s = BlueCoveImpl.currentStackHolder(false);
        if (s != null && s.bluetoothStack != null) {
            s.bluetoothStack.enableNativeDebug(class$com$intel$bluetooth$DebugLog == null ? (class$com$intel$bluetooth$DebugLog = BlueCoveImpl.class$("com.intel.bluetooth.DebugLog")) : class$com$intel$bluetooth$DebugLog, on);
        }
    }

    private static BluetoothStackHolder currentStackHolder(boolean create) {
        if (threadStack != null) {
            BluetoothStackHolder s = (BluetoothStackHolder)threadStack.get();
            if (s == null && threadStackIDDefault != null) {
                return threadStackIDDefault;
            }
            if (s == null && create) {
                s = new BluetoothStackHolder();
                threadStack.set(s);
            }
            return s;
        }
        if (singleStack == null && create) {
            singleStack = new BluetoothStackHolder();
        }
        return singleStack;
    }

    public synchronized BluetoothStack getBluetoothStack() throws BluetoothStateException {
        Utils.isLegalAPICall(fqcnSet);
        BluetoothStackHolder sh = BlueCoveImpl.currentStackHolder(false);
        if (sh != null && sh.bluetoothStack != null) {
            return sh.bluetoothStack;
        }
        if (sh == null && threadStack != null) {
            throw new BluetoothStateException("No BluetoothStack or Adapter for current thread");
        }
        BluetoothStack stack = this.accessControlContext == null ? this.detectStack() : this.detectStackPrivileged();
        return stack;
    }

    private BluetoothStack detectStackPrivileged() throws BluetoothStateException {
        try {
            return (BluetoothStack)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BluetoothStateException {
                    return BlueCoveImpl.this.detectStack();
                }
            }, (AccessControlContext)this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = UtilsJavaSE.getCause(e);
            if (cause instanceof BluetoothStateException) {
                throw (BluetoothStateException)cause;
            }
            throw (BluetoothStateException)UtilsJavaSE.initCause(new BluetoothStateException(e.getMessage()), cause);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        resourceConfigProperties = new Hashtable();
        stacks = new Hashtable();
        initializationProperties = new Vector();
        fqcnSet.addElement(FQCN);
        for (int i = 0; i < BlueCoveConfigProperties.INITIALIZATION_PROPERTIES.length; ++i) {
            initializationProperties.addElement(BlueCoveConfigProperties.INITIALIZATION_PROPERTIES[i]);
        }
    }

    private class ShutdownHookThread
    extends Thread {
        AsynchronousShutdownThread shutdownHookThread;

        ShutdownHookThread(AsynchronousShutdownThread shutdownHookThread) {
            super("BluecoveShutdownHookThread");
            this.shutdownHookThread = shutdownHookThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object monitor;
            Object object = monitor = this.shutdownHookThread.monitor;
            synchronized (object) {
                this.shutdownHookThread.shutdownStart = 1;
                monitor.notifyAll();
                if (!stacks.isEmpty()) {
                    try {
                        monitor.wait(7000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        void deRegister() {
            shutdownHookRegistered = null;
            UtilsJavaSE.runtimeRemoveShutdownHook(this);
            this.shutdownHookThread.deRegister();
        }
    }

    private class AsynchronousShutdownThread
    extends Thread {
        final Object monitor = new Object();
        int shutdownStart = 0;

        AsynchronousShutdownThread() {
            super("BluecoveAsynchronousShutdownThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                while (this.shutdownStart == 0) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            if (this.shutdownStart == -1) {
                return;
            }
            if (!stacks.isEmpty()) {
                Enumeration en = stacks.elements();
                while (en.hasMoreElements()) {
                    BluetoothStackHolder s = (BluetoothStackHolder)en.nextElement();
                    if (s.bluetoothStack == null) continue;
                    try {
                        s.bluetoothStack.destroy();
                    }
                    finally {
                        s.bluetoothStack = null;
                    }
                }
                stacks.clear();
                System.out.println("BlueCove stack shutdown completed");
            }
            object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deRegister() {
            this.shutdownStart = -1;
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    private static class BluetoothStackHolder {
        private BluetoothStack bluetoothStack;
        Hashtable configProperties = new Hashtable();

        private BluetoothStackHolder() {
        }

        private static BluetoothStack getBluetoothStack() throws BluetoothStateException {
            return BlueCoveImpl.instance().getBluetoothStack();
        }

        public String toString() {
            if (this.bluetoothStack == null) {
                return "not initialized";
            }
            return this.bluetoothStack.toString();
        }
    }
}

