/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedQueue<T> {
    private T value;
    private ArrayBlockingQueue<ElemQueue<T>> elems_queue;
    private QueueConsumer qc;
    private volatile Thread threadQueueConsumer;

    public TimedQueue(String name, int queue_size, CallBack cb) {
        this.elems_queue = new ArrayBlockingQueue(queue_size > 10 ? queue_size : 10, true);
        this.qc = new QueueConsumer(cb);
        this.threadQueueConsumer = new Thread((Runnable)this.qc, name + " QueueConsumer");
        this.threadQueueConsumer.start();
    }

    public void stop() {
        this.qc.end = true;
        this.threadQueueConsumer.interrupt();
    }

    public T getValue() {
        return this.value;
    }

    public boolean setValueNext(T value) {
        this.value = value;
        return this.setValue(value, 0L, false, false);
    }

    public boolean setValueImm(T value) {
        this.value = value;
        return this.setValue(value, 0L, false, true);
    }

    public boolean setValueTemp(T value, long millis) {
        return this.setValue(value, millis, true, false);
    }

    public boolean setValueSeq(T value, long millis) {
        return this.setValue(value, millis, false, false);
    }

    public boolean setValue(T value, long millis, boolean restore, boolean clear) {
        if (this.value == null) {
            this.value = value;
        }
        if (clear) {
            this.elems_queue.clear();
        }
        if (!this.elems_queue.offer(new ElemQueue<T>(value, millis))) {
            return false;
        }
        if (restore) {
            try {
                this.elems_queue.put(new ElemQueue<T>(this.value, 0L));
                return true;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    public T getQueueValue() throws Exception {
        return this.elems_queue.peek().value;
    }

    private class QueueConsumer
    implements Runnable {
        boolean end = false;
        ElemQueue<T> elem;
        CallBack cb;

        QueueConsumer(CallBack cb) {
            this.cb = cb;
        }

        public void run() {
            Thread thisThread = Thread.currentThread();
            try {
                while (!this.end) {
                    this.elem = (ElemQueue)TimedQueue.this.elems_queue.take();
                    this.cb.cbMethod.invoke(this.cb.cbObject, this.elem.value);
                    if (this.elem.millis <= 0L) continue;
                    Thread.sleep(this.elem.millis);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class CallBack
    extends Exception {
        Object cbObject = null;
        Method cbMethod = null;

        CallBack(Object cbo, String cbmname) throws Exception {
            this.cbObject = cbo;
            this.cbMethod = this.cbObject.getClass().getMethod(cbmname, Object.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElemQueue<T> {
        T value;
        long millis;

        ElemQueue(T val, long mil) {
            this.value = val;
            this.millis = mil;
        }
    }
}

