/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import net.bobis.jinput.hidraw.HidRawInputReport;

public abstract class ReDACInputReport
extends HidRawInputReport {
    private static final int minAnalogPort = 1;
    private static final int maxAnalogPort = 1;
    private static final int minDigitalPort = 1;
    private static final int maxDigitalPort = 2;
    private static final int minPin = 2;
    private static final int maxPin = 24;

    public ReDACInputReport() {
        this.dataBytes = new byte[31];
    }

    public int getValueAnalog(int port, int pin) {
        if (port > 1 || port < 1) {
            return Integer.MAX_VALUE;
        }
        if (pin > 24 || pin < 2) {
            return Integer.MAX_VALUE;
        }
        return this.dataBytes[1 + (port - 1) * 23 + (pin - 2)] & 0xFF;
    }

    public int getValueDigital(int port, int pin) {
        if (port > 2 || port < 1) {
            return Integer.MAX_VALUE;
        }
        if (pin > 24 || pin < 2) {
            return Integer.MAX_VALUE;
        }
        byte val = this.dataBytes[24 + (port - 1) * 3 + (pin - 2) / 8];
        if ((val & 1 << (pin - 2) % 8) == 0) {
            return 0;
        }
        return 1;
    }

    public int getUnitID() {
        return this.dataBytes[30] & 0xFF;
    }
}

