/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.util.BitSet;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.bobis.jinput.hidraw.HidRawOutputReport;

public abstract class ReDACDigitalOutputReport
extends HidRawOutputReport {
    private BitSet bitSet = new BitSet(24);
    private boolean dataInvalid = true;

    ReDACDigitalOutputReport(HidRawDevice dev) throws Exception {
        super(dev);
        this.dataBytes = new byte[9];
        this.dataBytes[1] = -109;
        this.clean();
    }

    public void sendData(Object obj) {
        try {
            this.device.writeReportSync((byte[])obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clean() {
        this.bitSet.clear();
        for (int i = 2; i < this.dataBytes.length; ++i) {
            this.dataBytes[i] = 0;
        }
    }

    public boolean putValuePin(boolean value, int pin_id) {
        if (pin_id > 25 || pin_id < 2) {
            return false;
        }
        this.bitSet.set(pin_id - 2, value);
        this.dataInvalid = true;
        return true;
    }

    public byte[] getOutData() {
        if (this.dataInvalid) {
            for (int i = 0; i < 3; ++i) {
                byte val = 0;
                for (int j = 0; j < 8; ++j) {
                    val = (byte)(val + (this.bitSet.get(i * 8 + j) ? 1 << j : 0));
                }
                this.dataBytes[2 + i] = val;
            }
            this.dataInvalid = false;
        }
        return this.dataBytes;
    }
}

